/*
 * Decompiled with CFR 0.152.
 */
package mc.craig.software.angels.common.blockentities;

import java.util.Iterator;
import mc.craig.software.angels.common.WAObjects;
import mc.craig.software.angels.common.blockentities.StatueBlockEntity;
import mc.craig.software.angels.common.blocks.StatueBlock;
import mc.craig.software.angels.common.entities.WeepingAngel;
import mc.craig.software.angels.utils.AngelUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.registries.ForgeRegistries;

public class CoffinBlockEntity
extends BlockEntity
implements BlockEntityTicker<CoffinBlockEntity> {
    private Coffin coffin = Coffin.NEW;
    private boolean isOpen;
    private boolean hasSkeleton = false;
    private float openAmount = 0.0f;
    private float alpha = 1.0f;
    private boolean doingSomething = false;
    private int ticks;
    private int pulses;
    private int knockTime;

    public CoffinBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)WAObjects.Tiles.COFFIN.get(), pos, state);
    }

    public Coffin getCoffin() {
        return this.coffin;
    }

    public void setCoffin(Coffin coffin) {
        this.coffin = coffin;
    }

    public boolean isOpen() {
        return this.isOpen;
    }

    public void setOpen(boolean open) {
        this.isOpen = open;
    }

    public float getOpenAmount() {
        return this.openAmount;
    }

    public void setHasSkeleton(boolean hasSkeleton) {
        this.hasSkeleton = hasSkeleton;
    }

    public boolean hasSkeleton() {
        return this.hasSkeleton;
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt) {
        super.onDataPacket(net, pkt);
        this.handleUpdateTag(pkt.m_131708_());
    }

    public void onLoad() {
        if (this.coffin == null) {
            this.coffin = AngelUtil.randomCoffin();
            this.m_6596_();
        }
    }

    public void tick(Level p_155253_, BlockPos p_155254_, BlockState p_155255_, CoffinBlockEntity p_155256_) {
        this.openAmount = this.isOpen ? (this.openAmount += 0.1f) : (this.openAmount -= 0.1f);
        if (this.openAmount > 1.0f) {
            this.openAmount = 1.0f;
        }
        if (this.openAmount < 0.0f) {
            this.openAmount = 0.0f;
        }
        if (this.knockTime <= 0) {
            this.knockTime = AngelUtil.RAND.nextInt(1810);
        }
        if (this.knockTime > 0 && this.f_58857_.m_46467_() > 0L && this.f_58857_.m_46467_() % (long)this.knockTime == 0L && !this.coffin.isPoliceBox() && !this.isOpen() && this.hasSkeleton()) {
            this.f_58857_.m_6263_(null, (double)this.m_58899_().m_123341_(), (double)this.m_58899_().m_123342_(), (double)this.m_58899_().m_123343_(), (SoundEvent)WAObjects.Sounds.KNOCK.get(), SoundSource.BLOCKS, 16.0f, 1.0f);
            this.knockTime = AngelUtil.RAND.nextInt(1810);
        }
        if (this.doingSomething && this.coffin.isPoliceBox()) {
            this.alpha = this.ticks % 60 < 30 ? (this.pulses <= 2 ? (float)((double)this.alpha - 0.01) : (float)((double)this.alpha - 0.02)) : (float)((double)this.alpha + 0.01);
            if (this.ticks % 60 == 0) {
                ++this.pulses;
            }
            ++this.ticks;
            if (this.ticks >= 360 && !this.f_58857_.f_46443_) {
                int j;
                this.f_58857_.m_7471_(this.f_58858_, false);
                this.activateAngels(40);
                if (ModList.get().isLoaded("tardis")) {
                    this.f_58857_.m_46597_(this.f_58858_.m_7494_(), ((Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation("tardis", "broken_exterior"))).m_49966_());
                }
                for (int i = 25; i > 0; i -= j) {
                    j = ExperienceOrb.m_20782_((int)i);
                    this.f_58857_.m_7967_((Entity)new ExperienceOrb(this.f_58857_, (double)this.f_58858_.m_123341_(), (double)this.f_58858_.m_123342_(), (double)this.f_58858_.m_123343_(), j));
                }
            }
        }
    }

    private void activateAngels(int range) {
        Iterator iterator = BlockPos.m_121985_((BlockPos)this.f_58858_, (int)range, (int)range, (int)range).iterator();
        while (iterator.hasNext()) {
            BlockEntity blockEntity;
            BlockPos pos = (BlockPos)iterator.next();
            ServerLevel serverWorld = (ServerLevel)this.f_58857_;
            if (this.f_58857_.m_46791_() == Difficulty.PEACEFUL || !((blockEntity = serverWorld.m_7702_(pos)) instanceof StatueBlockEntity)) continue;
            StatueBlockEntity statueBlockEntity = (StatueBlockEntity)blockEntity;
            WeepingAngel angel = new WeepingAngel(this.f_58857_);
            angel.setVarient(statueBlockEntity.getAngelVarients());
            angel.setType(statueBlockEntity.getAngelType());
            angel.m_7678_((double)pos.m_123341_() + 0.5, pos.m_123342_(), (double)pos.m_123343_() + 0.5, (float)Math.toRadians(22.5f * (float)((Integer)statueBlockEntity.m_58900_().m_61143_((Property)StatueBlock.ROTATION)).intValue()), 0.0f);
            angel.setPose(statueBlockEntity.getPose());
            this.f_58857_.m_7967_((Entity)angel);
            this.f_58857_.m_7471_(pos, false);
        }
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public CompoundTag m_5995_() {
        CompoundTag compoundTag = new CompoundTag();
        compoundTag.m_128359_("coffin_type", this.coffin.name());
        compoundTag.m_128379_("isOpen", this.isOpen);
        compoundTag.m_128379_("hasSkeleton", this.hasSkeleton);
        compoundTag.m_128379_("doingSomething", this.doingSomething);
        compoundTag.m_128350_("openAmount", this.openAmount);
        compoundTag.m_128350_("alpha", this.alpha);
        return compoundTag;
    }

    public void sendUpdates() {
        if (this.f_58857_ != null && this.m_58900_() != null && this.m_58900_().m_60734_() != null) {
            this.f_58857_.m_46717_(this.f_58858_, this.m_58900_().m_60734_());
            this.f_58857_.m_7260_(this.f_58858_, this.f_58857_.m_8055_(this.f_58858_), this.f_58857_.m_8055_(this.f_58858_), 3);
        }
        this.m_6596_();
    }

    public void m_142466_(CompoundTag nbt) {
        this.coffin = this.getCorrectCoffin(nbt.m_128461_("coffin_type"));
        this.isOpen = nbt.m_128471_("isOpen");
        this.hasSkeleton = nbt.m_128471_("hasSkeleton");
        this.openAmount = nbt.m_128457_("openAmount");
        this.alpha = nbt.m_128457_("alpha");
        this.doingSomething = nbt.m_128471_("doingSomething");
        super.m_142466_(nbt);
    }

    protected void m_183515_(CompoundTag compound) {
        super.m_183515_(compound);
        if (this.coffin == null) {
            this.coffin = AngelUtil.randomCoffin();
        }
        compound.m_128359_("coffin_type", this.coffin.name());
        compound.m_128379_("isOpen", this.isOpen);
        compound.m_128379_("hasSkeleton", this.hasSkeleton);
        compound.m_128379_("doingSomething", this.doingSomething);
        compound.m_128350_("openAmount", this.openAmount);
        compound.m_128350_("alpha", this.alpha);
    }

    public boolean isDoingSomething() {
        return this.doingSomething;
    }

    public void setDoingSomething(boolean doingSomething) {
        this.doingSomething = doingSomething;
        if (doingSomething) {
            this.f_58857_.m_5594_(null, this.f_58858_, (SoundEvent)WAObjects.Sounds.TARDIS_TAKEOFF.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
        }
    }

    public float getAlpha() {
        return this.alpha;
    }

    public Coffin getCorrectCoffin(String coffin) {
        for (Coffin value : Coffin.values()) {
            if (!value.name().equals(coffin)) continue;
            return value;
        }
        return Coffin.HEAVILY_WEATHERED;
    }

    public AABB getRenderBoundingBox() {
        return super.getRenderBoundingBox().m_82400_(8.0);
    }

    public static enum Coffin {
        NEW,
        WEATHERED,
        SLIGHTLY_WEATHERED,
        HEAVILY_WEATHERED,
        PTB(true),
        PTB_2(true),
        PTB_3(true),
        PTB_4(true),
        PTB_5(true);

        private final boolean isPoliceBox;

        private Coffin() {
            this.isPoliceBox = false;
        }

        private Coffin(boolean isPoliceBox) {
            this.isPoliceBox = isPoliceBox;
        }

        public static Coffin next(Coffin type) {
            int index = type.ordinal();
            int nextIndex = index + 1;
            Coffin[] angels = Coffin.values();
            return angels[nextIndex %= angels.length];
        }

        public boolean isPoliceBox() {
            return this.isPoliceBox;
        }
    }
}

