/*
 * Decompiled with CFR 0.152.
 */
package mc.craig.software.angels.common.blockentities;

import mc.craig.software.angels.client.poses.WeepingAngelPose;
import mc.craig.software.angels.common.WAObjects;
import mc.craig.software.angels.common.blockentities.IPlinth;
import mc.craig.software.angels.common.blocks.PlinthBlock;
import mc.craig.software.angels.common.entities.AngelType;
import mc.craig.software.angels.common.entities.WeepingAngel;
import mc.craig.software.angels.common.variants.AbstractVariant;
import mc.craig.software.angels.common.variants.AngelTypes;
import mc.craig.software.angels.config.WAConfig;
import mc.craig.software.angels.utils.AngelUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Difficulty;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;

public class PlinthBlockEntity
extends BlockEntity
implements BlockEntityTicker<PlinthBlockEntity>,
IPlinth {
    private boolean hasSpawned = false;
    private String type = AngelType.DISASTER_MC.name();
    private WeepingAngelPose pose = WeepingAngelPose.getRandomPose(AngelUtil.RAND);
    private AbstractVariant angelVariant = (AbstractVariant)((Object)AngelTypes.NORMAL.get());

    public PlinthBlockEntity(BlockPos blockPos, BlockState state) {
        super((BlockEntityType)WAObjects.Tiles.PLINTH.get(), blockPos, state);
    }

    public boolean getHasSpawned() {
        return this.hasSpawned;
    }

    public void setHasSpawned(boolean hasSpawned) {
        this.hasSpawned = hasSpawned;
    }

    public void m_142466_(CompoundTag compound) {
        super.m_142466_(compound);
        this.setHasSpawned(compound.m_128471_("hasSpawned"));
        this.setPose(WeepingAngelPose.getPose(compound.m_128461_("pose")));
        this.type = compound.m_128461_("model");
        if (compound.m_128441_("variant")) {
            this.setAngelVarients((AbstractVariant)AngelTypes.VARIANTS_REGISTRY.get().getValue(new ResourceLocation(compound.m_128461_("variant"))));
        }
    }

    public void m_183515_(CompoundTag compound) {
        super.m_183515_(compound);
        compound.m_128379_("hasSpawned", this.hasSpawned);
        compound.m_128359_("model", this.type);
        compound.m_128359_("pose", this.pose.name());
        compound.m_128359_("variant", this.angelVariant.getRegistryName().toString());
    }

    public AngelType getAngelType() {
        boolean found = false;
        for (AngelType value : AngelType.values()) {
            if (!value.name().equals(this.type)) continue;
            found = true;
            break;
        }
        if (!found) {
            this.type = AngelType.DISASTER_MC.name();
        }
        return AngelType.valueOf(this.type.isEmpty() ? AngelType.DISASTER_MC.name() : this.type);
    }

    public void setAngelType(String type) {
        this.type = type;
    }

    public void setAngelType(AngelType type) {
        this.type = type.name();
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public CompoundTag m_5995_() {
        CompoundTag compoundTag = new CompoundTag();
        compoundTag.m_128379_("hasSpawned", this.hasSpawned);
        compoundTag.m_128359_("model", this.type);
        compoundTag.m_128359_("pose", this.pose.name());
        compoundTag.m_128359_("variant", this.angelVariant.getRegistryName().toString());
        return compoundTag;
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt) {
        super.onDataPacket(net, pkt);
        this.handleUpdateTag(pkt.m_131708_());
    }

    public AABB getRenderBoundingBox() {
        return super.getRenderBoundingBox().m_82377_(8.0, 8.0, 8.0);
    }

    public void sendUpdates() {
        this.f_58857_.m_46717_(this.f_58858_, this.m_58900_().m_60734_());
        this.f_58857_.m_7260_(this.f_58858_, this.f_58857_.m_8055_(this.f_58858_), this.f_58857_.m_8055_(this.f_58858_), 3);
        this.m_6596_();
    }

    public void tick(Level p_155253_, BlockPos p_155254_, BlockState p_155255_, PlinthBlockEntity p_155256_) {
        PlinthBlockEntity plinth;
        BlockEntity blockEntity;
        if (this.f_58857_.f_46443_) {
            return;
        }
        boolean isClassic = this.getAngelType() == AngelType.A_DIZZLE;
        boolean current = (Boolean)this.m_58900_().m_61143_((Property)PlinthBlock.CLASSIC);
        if (isClassic && !current) {
            this.f_58857_.m_46597_(this.f_58858_, (BlockState)this.m_58900_().m_61124_((Property)PlinthBlock.CLASSIC, (Comparable)Boolean.valueOf(true)));
        } else if (!isClassic && current) {
            this.f_58857_.m_46597_(this.f_58858_, (BlockState)this.m_58900_().m_61124_((Property)PlinthBlock.CLASSIC, (Comparable)Boolean.valueOf(false)));
        }
        if (this.f_58857_.m_46791_() != Difficulty.PEACEFUL && ((Boolean)WAConfig.CONFIG.spawnFromBlocks.get()).booleanValue() && this.f_58857_.m_46755_(this.f_58858_) > 0 && (blockEntity = this.f_58857_.m_7702_(this.f_58858_)) instanceof PlinthBlockEntity && !(plinth = (PlinthBlockEntity)blockEntity).getHasSpawned()) {
            WeepingAngel angel = new WeepingAngel(this.f_58857_);
            angel.setType(this.type);
            angel.m_7678_((double)this.f_58858_.m_123341_() + 0.5, this.f_58858_.m_123342_() + 1, (double)this.f_58858_.m_123343_() + 0.5, 0.0f, 0.0f);
            angel.setPose(this.getPose());
            angel.setVarient(this.angelVariant);
            this.f_58857_.m_7967_((Entity)angel);
            plinth.setHasSpawned(true);
            this.sendUpdates();
        }
    }

    public WeepingAngelPose getPose() {
        return this.pose;
    }

    public void setPose(WeepingAngelPose pose) {
        this.pose = pose;
    }

    public void setAngelVarients(AbstractVariant angelVariants) {
        this.angelVariant = angelVariants;
    }

    public void onLoad() {
        if (this.getPose() == null) {
            this.setPose(WeepingAngelPose.HIDING);
        }
    }

    @Override
    public void changeModel() {
        this.setAngelType(AngelType.next(this.getAngelType()));
    }

    @Override
    public void changePose() {
        this.setPose(WeepingAngelPose.next(this.pose));
    }

    @Override
    public void sendUpdatesToClient() {
        this.f_58857_.m_46717_(this.f_58858_, this.m_58900_().m_60734_());
        this.f_58857_.m_7260_(this.f_58858_, this.f_58857_.m_8055_(this.f_58858_), this.f_58857_.m_8055_(this.f_58858_), 3);
        this.m_6596_();
    }

    @Override
    public AngelType getCurrentType() {
        return this.getAngelType();
    }

    @Override
    public WeepingAngelPose getCurrentPose() {
        return this.pose;
    }

    @Override
    public AbstractVariant getVariant() {
        return this.angelVariant;
    }

    @Override
    public void setAbstractVariant(AbstractVariant variant) {
        this.angelVariant = variant;
    }
}

