/*
 * Decompiled with CFR 0.152.
 */
package mc.craig.software.angels.common.blockentities;

import mc.craig.software.angels.common.WAObjects;
import mc.craig.software.angels.common.entities.AngelType;
import mc.craig.software.angels.common.entities.WeepingAngel;
import mc.craig.software.angels.common.variants.AbstractVariant;
import mc.craig.software.angels.common.variants.AngelTypes;
import mc.craig.software.angels.utils.AngelUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SnowLayerBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;

public class SnowAngelBlockEntity
extends BlockEntity
implements BlockEntityTicker<SnowAngelBlockEntity> {
    private final AABB AABB = new AABB(0.2, 0.0, 0.0, 0.8, 2.0, 0.1);
    private SnowAngelStages snowAngelStages = SnowAngelStages.ARM;
    private AbstractVariant angelVariant = (AbstractVariant)((Object)AngelTypes.NORMAL.get());
    private boolean hasSetup = false;
    private int rotation = 0;

    public SnowAngelBlockEntity(BlockPos pos, BlockState blockState) {
        super((BlockEntityType)WAObjects.Tiles.SNOW_ANGEL.get(), pos, blockState);
    }

    public SnowAngelStages getSnowAngelStage() {
        if (this.snowAngelStages == null) {
            return SnowAngelStages.BODY;
        }
        return this.snowAngelStages;
    }

    public void setSnowAngelStage(SnowAngelStages snowAngelStages) {
        this.snowAngelStages = snowAngelStages;
    }

    public AbstractVariant getVariant() {
        return this.angelVariant;
    }

    public void setVariant(AbstractVariant angelVariant) {
        this.angelVariant = angelVariant;
    }

    public void m_142466_(CompoundTag nbt) {
        super.m_142466_(nbt);
        if (nbt.m_128441_("variant")) {
            this.setVariant((AbstractVariant)AngelTypes.VARIANTS_REGISTRY.get().getValue(new ResourceLocation(nbt.m_128461_("variant"))));
        }
        if (nbt.m_128441_("snow_stage")) {
            this.setSnowAngelStage(SnowAngelStages.valueOf(nbt.m_128461_("snow_stage")));
        }
        this.rotation = nbt.m_128451_("rotation");
        this.hasSetup = nbt.m_128471_("setup");
    }

    public void m_183515_(CompoundTag compound) {
        compound.m_128359_("snow_stage", this.snowAngelStages.name());
        compound.m_128359_("variant", this.angelVariant.getRegistryName().toString());
        compound.m_128405_("rotation", this.rotation);
        compound.m_128379_("setup", this.hasSetup);
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public CompoundTag m_5995_() {
        CompoundTag compoundTag = new CompoundTag();
        compoundTag.m_128359_("snow_stage", this.snowAngelStages.name());
        compoundTag.m_128359_("variant", this.angelVariant.getRegistryName().toString());
        compoundTag.m_128405_("rotation", this.rotation);
        compoundTag.m_128379_("setup", this.hasSetup);
        return compoundTag;
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt) {
        super.onDataPacket(net, pkt);
        this.handleUpdateTag(pkt.m_131708_());
    }

    public void handleUpdateTag(CompoundTag tag) {
        super.handleUpdateTag(tag);
    }

    public AABB getRenderBoundingBox() {
        return super.getRenderBoundingBox().m_82377_(8.0, 8.0, 8.0);
    }

    public void sendUpdates() {
        this.f_58857_.m_46717_(this.f_58858_, this.m_58900_().m_60734_());
        this.f_58857_.m_7260_(this.f_58858_, this.f_58857_.m_8055_(this.f_58858_), this.f_58857_.m_8055_(this.f_58858_), 3);
        this.m_6596_();
    }

    public boolean isHasSetup() {
        return this.hasSetup;
    }

    public void setHasSetup(boolean hasSetup) {
        this.hasSetup = hasSetup;
    }

    public void tick(Level p_155253_, BlockPos p_155254_, BlockState p_155255_, SnowAngelBlockEntity p_155256_) {
        if (!this.hasSetup) {
            this.setRotation(this.f_58857_.f_46441_.nextInt(360));
            this.setSnowAngelStage(AngelUtil.randowSnowStage());
            this.hasSetup = true;
            this.sendUpdates();
        }
        if (this.snowAngelStages == SnowAngelStages.ARM) {
            return;
        }
        if (this.f_58857_ != null && !this.f_58857_.m_45976_(Player.class, this.AABB.m_82338_(this.m_58899_())).isEmpty() && !this.f_58857_.f_46443_) {
            WeepingAngel angel = new WeepingAngel(this.f_58857_);
            angel.setType(AngelType.DISASTER_MC);
            angel.setVarient(this.angelVariant);
            BlockPos newPos = this.m_58899_();
            angel.m_6034_((double)newPos.m_123341_() + 0.5, newPos.m_123342_(), (double)newPos.m_123343_() + 0.5);
            this.f_58857_.m_7967_((Entity)angel);
            Integer layers = (Integer)this.f_58857_.m_8055_(this.f_58858_).m_61143_((Property)SnowLayerBlock.f_56581_);
            this.f_58857_.m_46597_(this.f_58858_, (BlockState)Blocks.f_50125_.m_49966_().m_61124_((Property)SnowLayerBlock.f_56581_, (Comparable)layers));
        }
        if (this.angelVariant.isHeadless() && this.snowAngelStages == SnowAngelStages.HEAD || !this.hasSetup) {
            this.setSnowAngelStage(AngelUtil.randowSnowStage());
            this.hasSetup = true;
            this.sendUpdates();
        }
    }

    public boolean m_58901_() {
        return false;
    }

    public int getRotation() {
        return this.rotation;
    }

    public void setRotation(int rotation) {
        this.rotation = rotation;
        this.sendUpdates();
    }

    public static enum SnowAngelStages {
        ARM,
        HEAD,
        BODY,
        WINGS;

    }
}

