/*
 * Decompiled with CFR 0.152.
 */
package mc.craig.software.angels.common.entities;

import java.util.List;
import mc.craig.software.angels.common.entities.WeepingAngel;
import mc.craig.software.angels.common.entities.ai.BodyRotationAngel;
import mc.craig.software.angels.config.WAConfig;
import mc.craig.software.angels.utils.ViewUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.AttributeMap;
import net.minecraft.world.entity.ai.control.BodyRotationControl;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.phys.Vec3;

public class QuantumLockedLifeform
extends Monster
implements Enemy {
    private static final EntityDataAccessor<Boolean> IS_SEEN = SynchedEntityData.m_135353_(QuantumLockedLifeform.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Integer> TIME_VIEWED = SynchedEntityData.m_135353_(QuantumLockedLifeform.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<BlockPos> PREVBLOCKPOS = SynchedEntityData.m_135353_(QuantumLockedLifeform.class, (EntityDataSerializer)EntityDataSerializers.f_135038_);

    public QuantumLockedLifeform(Level worldIn, EntityType<? extends Monster> entityType) {
        super(entityType, worldIn);
    }

    public AttributeMap m_21204_() {
        return new AttributeMap(WeepingAngel.createAttributes().m_22265_());
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.getSeenTime() == 0 || this.f_19853_.m_46859_(this.m_142538_().m_7495_())) {
            this.m_21557_(false);
        }
    }

    public void m_8107_() {
        if (!this.m_21205_().m_41619_()) {
            this.m_21530_();
        }
        super.m_8107_();
        if (!this.f_19853_.f_46443_) {
            List players = this.f_19853_.m_45976_(Player.class, this.m_142469_().m_82400_((double)((Integer)WAConfig.CONFIG.stalkRange.get()).intValue()));
            players.removeIf(player -> player.m_5833_() || player.m_20145_() || player.m_5803_() || player.f_19853_ != this.f_19853_);
            if (((Boolean)WAConfig.CONFIG.freezeOnAngel.get()).booleanValue()) {
                List angels = this.f_19853_.m_45976_(WeepingAngel.class, this.m_142469_().m_82400_((double)((Integer)WAConfig.CONFIG.stalkRange.get()).intValue()));
                for (WeepingAngel angel : angels) {
                    if (angel.m_142081_() == this.m_142081_() || !ViewUtil.isInSight((LivingEntity)angel, this) || !this.m_20096_()) continue;
                    this.setSeenTime(this.getSeenTime() + 1);
                    this.m_21557_(true);
                    return;
                }
            }
            if (players.isEmpty()) {
                this.setSeenTime(0);
                this.m_7910_(0.5f);
            } else {
                Player targetPlayer = null;
                for (Player player2 : players) {
                    if (ViewUtil.isInSight((LivingEntity)player2, this) && this.m_20096_()) {
                        this.setSeenTime(this.getSeenTime() + 1);
                        this.invokeSeen(player2);
                        return;
                    }
                    if (targetPlayer != null) continue;
                    targetPlayer = player2;
                    this.setSeenTime(0);
                    this.m_7910_(0.5f);
                }
                if (this.isSeen() || !((Boolean)WAConfig.CONFIG.aggroCreative.get()).booleanValue() && targetPlayer.m_7500_()) {
                    return;
                }
                this.snapLookToPlayer(targetPlayer);
                if (this.m_20270_((Entity)targetPlayer) < 2.0f) {
                    if (this.f_19796_.nextInt(50) < 30) {
                        this.m_7327_((Entity)targetPlayer);
                    }
                } else {
                    this.moveTowards((LivingEntity)targetPlayer);
                }
            }
        }
    }

    private void snapLookToPlayer(Player targetPlayer) {
        Vec3 vecPos = this.m_20182_();
        Vec3 vecPlayerPos = targetPlayer.m_20182_();
        float angle = (float)Math.toDegrees((float)Math.atan2(vecPos.f_82481_ - vecPlayerPos.f_82481_, vecPos.f_82479_ - vecPlayerPos.f_82479_));
        this.f_20883_ = angle > 180.0f ? angle : angle + 90.0f;
        this.f_20885_ = this.f_20883_;
    }

    public void moveTowards(LivingEntity targetPlayer) {
        this.m_21573_().m_5624_((Entity)targetPlayer, (double)this.m_6113_());
    }

    protected void m_8097_() {
        super.m_8097_();
        this.m_20088_().m_135372_(IS_SEEN, (Object)false);
        this.m_20088_().m_135372_(TIME_VIEWED, (Object)0);
        this.m_20088_().m_135372_(PREVBLOCKPOS, (Object)BlockPos.f_121853_);
    }

    public void deserializeNBT(CompoundTag compound) {
        super.deserializeNBT(compound);
        if (compound.m_128441_("timeSeen")) {
            this.setSeenTime(compound.m_128451_("timeSeen"));
        }
        if (compound.m_128441_("prevPos")) {
            this.setPrevPos(this.getPrevPos());
        }
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128379_("isSeen", this.isSeen());
        compound.m_128405_("timeSeen", this.getSeenTime());
        compound.m_128356_("prevPos", this.getPrevPos().m_121878_());
    }

    public boolean m_6040_() {
        return true;
    }

    public boolean m_6051_() {
        return false;
    }

    public boolean isSeen() {
        return this.getSeenTime() > 0;
    }

    public int getSeenTime() {
        return (Integer)this.m_20088_().m_135370_(TIME_VIEWED);
    }

    public void setSeenTime(int time) {
        this.m_20088_().m_135381_(TIME_VIEWED, (Object)time);
    }

    public BlockPos getPrevPos() {
        return (BlockPos)this.m_20088_().m_135370_(PREVBLOCKPOS);
    }

    public void setPrevPos(BlockPos pos) {
        this.m_20088_().m_135381_(PREVBLOCKPOS, (Object)pos);
    }

    protected BodyRotationControl m_7560_() {
        return new BodyRotationAngel((Mob)this);
    }

    public void invokeSeen(Player player) {
        this.m_21573_().m_26536_((Path)null, 0.0);
        this.m_21557_(true);
    }

    protected boolean m_6107_() {
        return this.getSeenTime() > 0;
    }
}

