/*
 * Decompiled with CFR 0.152.
 */
package mc.craig.software.angels.common.entities;

import com.google.common.collect.ImmutableList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import mc.craig.software.angels.api.EventAngelBreakEvent;
import mc.craig.software.angels.client.poses.WeepingAngelPose;
import mc.craig.software.angels.common.WAObjects;
import mc.craig.software.angels.common.entities.AngelType;
import mc.craig.software.angels.common.entities.QuantumLockedLifeform;
import mc.craig.software.angels.common.entities.attributes.WAAttributes;
import mc.craig.software.angels.common.variants.AbstractVariant;
import mc.craig.software.angels.common.variants.AngelTypes;
import mc.craig.software.angels.config.WAConfig;
import mc.craig.software.angels.utils.AngelUtil;
import mc.craig.software.angels.utils.TagUtil;
import mc.craig.software.angels.utils.WATeleporter;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSoundPacket;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.TickTask;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.BreakDoorGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.MoveTowardsRestrictionGoal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.ai.navigation.WallClimberNavigation;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EndPortalBlock;
import net.minecraft.world.level.block.NetherPortalBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;

public class WeepingAngel
extends QuantumLockedLifeform {
    private static final EntityDataAccessor<String> TYPE = SynchedEntityData.m_135353_(WeepingAngel.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    private static final EntityDataAccessor<String> CURRENT_POSE = SynchedEntityData.m_135353_(WeepingAngel.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    private static final EntityDataAccessor<String> VARIANT = SynchedEntityData.m_135353_(WeepingAngel.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    private static final EntityDataAccessor<Float> LAUGH = SynchedEntityData.m_135353_(WeepingAngel.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final Predicate<Difficulty> DIFFICULTY = difficulty -> difficulty == Difficulty.EASY;
    private static final SoundEvent[] CHILD_SOUNDS = new SoundEvent[]{SoundEvents.f_12499_, (SoundEvent)WAObjects.Sounds.LAUGHING_CHILD.get()};
    public long timeSincePlayedSound = 0L;

    public WeepingAngel(EntityType<? extends QuantumLockedLifeform> type, Level world) {
        this(world);
    }

    public WeepingAngel(Level world) {
        super(world, (EntityType<? extends Monster>)((EntityType)WAObjects.EntityEntries.WEEPING_ANGEL.get()));
        this.f_21345_.m_25352_(0, (Goal)new BreakDoorGoal((Mob)this, DIFFICULTY));
        this.f_21345_.m_25352_(5, (Goal)new MoveTowardsRestrictionGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(5, (Goal)new MoveTowardsRestrictionGoal((PathfinderMob)this, 1.0));
        this.f_21364_ = (Integer)WAConfig.CONFIG.xpGained.get();
    }

    public static AttributeSupplier.Builder createAttributes() {
        return WeepingAngel.m_33035_().m_22268_(Attributes.f_22281_, ((Double)WAConfig.CONFIG.damage.get()).doubleValue()).m_22268_(Attributes.f_22276_, 50.0).m_22268_(Attributes.f_22278_, 1.0).m_22268_(Attributes.f_22279_, 0.8).m_22268_((Attribute)WAAttributes.BLOCK_BREAK_RANGE.get(), (double)((Integer)WAConfig.CONFIG.blockBreakRange.get()).intValue()).m_22268_(Attributes.f_22284_, 2.0);
    }

    public void m_147240_(double p_147241_, double p_147242_, double p_147243_) {
    }

    public boolean m_21532_() {
        return super.m_21532_() || !this.m_21205_().m_41619_() || !this.m_21206_().m_41619_();
    }

    public void dropAngelStuff() {
        if (this.f_19853_.m_5776_()) {
            return;
        }
        AngelUtil.dropEntityLoot((Entity)this, this.f_20888_);
        this.m_19983_(this.m_21205_());
        this.m_19983_(this.m_21206_());
    }

    @Override
    public boolean m_6051_() {
        return false;
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.m_20088_().m_135372_(TYPE, (Object)AngelUtil.randomType().name());
        this.m_20088_().m_135372_(CURRENT_POSE, (Object)WeepingAngelPose.getRandomPose(AngelUtil.RAND).name());
        this.m_20088_().m_135372_(VARIANT, (Object)this.getAngelType().getWeightedHandler().getRandom(null).getRegistryName().toString());
        this.m_20088_().m_135372_(LAUGH, (Object)Float.valueOf(this.f_19796_.nextFloat()));
    }

    public AbstractVariant getVariant() {
        return (AbstractVariant)AngelTypes.VARIANTS_REGISTRY.get().getValue(new ResourceLocation((String)this.m_20088_().m_135370_(VARIANT)));
    }

    public void setVarient(AbstractVariant varient) {
        this.m_20088_().m_135381_(VARIANT, (Object)varient.getRegistryName().toString());
    }

    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor serverWorld, DifficultyInstance difficultyInstance, MobSpawnType spawnReason, @Nullable SpawnGroupData livingEntityData, @Nullable CompoundTag compoundNBT) {
        this.m_5496_((SoundEvent)WAObjects.Sounds.ANGEL_AMBIENT.get(), 0.5f, 1.0f);
        this.setVarient(this.getAngelType().getWeightedHandler().getRandom(this));
        return super.m_6518_(serverWorld, difficultyInstance, spawnReason, livingEntityData, compoundNBT);
    }

    protected SoundEvent m_7975_(DamageSource damageSourceIn) {
        return SoundEvents.f_12446_;
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)WAObjects.Sounds.ANGEL_DEATH.get();
    }

    protected SoundEvent m_7515_() {
        if (this.isCherub() && this.f_19797_ % AngelUtil.secondsToTicks(2) == 0) {
            return CHILD_SOUNDS[this.f_19796_.nextInt(CHILD_SOUNDS.length)];
        }
        return null;
    }

    public float m_20236_(Pose p_213307_1_) {
        return this.isCherub() ? 0.5f : 1.3f;
    }

    public EntityDimensions m_6972_(Pose poseIn) {
        return this.isCherub() ? new EntityDimensions(0.8f, 0.8f, true) : super.m_6972_(poseIn);
    }

    public boolean m_6162_() {
        return this.isCherub();
    }

    public boolean m_7327_(@NotNull Entity entity) {
        if (entity instanceof ServerPlayer) {
            boolean canTeleport;
            ServerPlayer serverPlayerEntity = (ServerPlayer)entity;
            boolean bl = canTeleport = this.f_19796_.nextInt(20) < 5 && this.m_21223_() > 5.0f && !this.isInCatacomb() || (Boolean)WAConfig.CONFIG.justTeleport.get() != false;
            if (canTeleport) {
                this.teleportInteraction(serverPlayerEntity);
                return true;
            }
            if (this.isInCatacomb() || this.isCherub()) {
                this.dealDamage((Player)serverPlayerEntity);
                if (((Boolean)WAConfig.CONFIG.torchBlowOut.get()).booleanValue()) {
                    AngelUtil.extinguishHand(serverPlayerEntity, this);
                }
                return true;
            }
        }
        return false;
    }

    public boolean isInCatacomb() {
        Level level = this.f_19853_;
        if (level instanceof ServerLevel) {
            ServerLevel serverWorld = (ServerLevel)level;
            BlockPos catacomb = serverWorld.m_6018_().m_207561_(AngelUtil.CATACOMBS, this.m_142538_(), 100, false);
            if (catacomb == null) {
                return false;
            }
            return this.m_20275_(catacomb.m_123341_(), catacomb.m_123342_(), catacomb.m_123343_()) < 50.0;
        }
        return false;
    }

    public void dealDamage(Player player) {
        double damage = (Double)WAConfig.CONFIG.damage.get();
        player.m_6469_(this.m_21223_() > 5.0f ? WAObjects.ANGEL : WAObjects.ANGEL_NECK_SNAP, (float)damage);
        this.m_5634_(this.m_21223_() > 5.0f ? 4.0f : 2.0f);
        this.stealItems(player);
        this.m_21335_((Entity)player);
    }

    private void stealItems(Player player) {
        if (this.m_21205_().m_41619_() && this.f_19796_.nextBoolean()) {
            for (int i = 0; i < player.m_150109_().m_6643_(); ++i) {
                ItemStack stack = player.m_150109_().m_8020_(i);
                if (!stack.m_204117_(AngelUtil.THEFT)) continue;
                this.m_21008_(InteractionHand.MAIN_HAND, player.m_150109_().m_8020_(i).m_41777_());
                player.m_150109_().m_8020_(i).m_41764_(0);
                player.f_36095_.m_38946_();
                return;
            }
        }
    }

    public long getTimeSincePlayedSound() {
        return this.timeSincePlayedSound;
    }

    public void setTimeSincePlayedSound(long timeSincePlayedSound) {
        this.timeSincePlayedSound = timeSincePlayedSound;
    }

    protected boolean m_6149_() {
        return true;
    }

    public void m_6667_(DamageSource cause) {
        AbstractVariant variant;
        super.m_6667_(cause);
        this.m_19983_(this.m_21205_());
        this.m_19983_(this.m_21206_());
        if (this.getAngelType() == AngelType.DISASTER_MC && (variant = this.getVariant()).shouldDrop(cause, this)) {
            this.m_19998_((ItemLike)variant.stackDrop().m_41720_());
        }
    }

    public void m_7601_(BlockState state, Vec3 motionMultiplierIn) {
        if (!state.m_60713_(Blocks.f_50033_)) {
            super.m_7601_(state, motionMultiplierIn);
        }
    }

    @Override
    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128359_("wa_pose", this.getAngelPose());
        compound.m_128359_("type", this.getAngelType().name());
        compound.m_128359_("variant", this.getVariant().getRegistryName().toString());
        compound.m_128350_("laugh", this.getLaugh());
    }

    public void m_20258_(CompoundTag compound) {
        super.m_20258_(compound);
        if (compound.m_128441_("wa_pose")) {
            this.setPose(WeepingAngelPose.getPose(compound.m_128461_("wa_pose")));
        }
        if (compound.m_128441_("laugh")) {
            this.setLaugh(this.serializeNBT().m_128457_("laugh"));
        }
        if (compound.m_128441_("type")) {
            this.setType(compound.m_128461_("type"));
        }
        if (compound.m_128441_("variant")) {
            this.setVarient(Objects.requireNonNull((AbstractVariant)AngelTypes.VARIANTS_REGISTRY.get().getValue(new ResourceLocation(compound.m_128461_("variant")))));
        }
    }

    public void m_7350_(EntityDataAccessor<?> key) {
        super.m_7350_(key);
        if (TYPE.equals(key)) {
            this.m_6210_();
            this.setVarient(this.getAngelType().getWeightedHandler().getRandom(this));
        }
    }

    @Override
    public void invokeSeen(Player player) {
        super.invokeSeen(player);
        if (player instanceof ServerPlayer && this.getSeenTime() == 1 && this.getPrevPos().m_121878_() != this.m_142538_().m_121878_()) {
            this.setPrevPos(this.m_142538_());
            this.playSeenSound(player);
            this.randomisePose();
            this.f_20902_ = 0.0f;
            this.f_20901_ = 0.0f;
            this.f_20902_ = 0.0f;
        }
    }

    private void randomisePose() {
        this.setPose(WeepingAngelPose.getRandomPose(this.f_19796_));
    }

    private void playSeenSound(Player player) {
        if (player.m_20270_((Entity)this) < 15.0f) {
            this.setTimeSincePlayedSound(System.currentTimeMillis());
            ((ServerPlayer)player).f_8906_.m_141995_((Packet)new ClientboundSoundPacket(this.getSeenSound(), SoundSource.BLOCKS, player.m_20185_(), player.m_20186_(), player.m_20189_(), 0.25f, 1.0f));
        }
    }

    public SoundEvent getSeenSound() {
        AbstractVariant abstractVariant = this.getVariant();
        ItemStack itemStack = abstractVariant.stackDrop();
        Item item = itemStack.m_41720_();
        if (item instanceof BlockItem) {
            BlockItem blockItem = (BlockItem)item;
            Block block = blockItem.m_40614_();
            return block.m_49966_().m_60827_().m_56775_();
        }
        return SoundEvents.f_12447_;
    }

    protected void m_7355_(BlockPos pos, BlockState blockIn) {
        if (this.f_19853_.m_46791_() == Difficulty.HARD) {
            return;
        }
        if (!blockIn.m_60767_().m_76332_()) {
            SoundType soundtype;
            BlockState blockstate = this.f_19853_.m_8055_(pos.m_7494_());
            SoundType soundType = soundtype = blockstate.m_60734_() == Blocks.f_50125_ ? blockstate.getSoundType((LevelReader)this.f_19853_, pos, (Entity)this) : blockIn.getSoundType((LevelReader)this.f_19853_, pos, (Entity)this);
            if (this.f_19853_.m_46791_() == Difficulty.EASY) {
                this.m_5496_(soundtype.m_56776_(), 0.3f, soundtype.m_56774_());
            } else if (this.f_19853_.f_46441_.nextInt(5) == 4) {
                this.m_5496_(soundtype.m_56776_(), 0.3f, soundtype.m_56774_());
            }
        }
    }

    @Override
    public void m_8119_() {
        if (!WAConfig.CONFIG.isVariantPermitted(this.getVariant())) {
            this.setVarient(this.getAngelType().getWeightedHandler().getRandom(this));
        }
        if (!WAConfig.CONFIG.isModelPermitted(this.getAngelType())) {
            this.setType(AngelType.next(this.getAngelType()));
        }
        this.getVariant().tick(this);
        super.m_8119_();
        if (this.f_19797_ % 500 == 0 && this.m_5448_() == null && this.getSeenTime() == 0) {
            this.setPose(Objects.requireNonNull(WeepingAngelPose.HIDING));
        }
        if (this.f_19796_.nextBoolean() && ((Boolean)WAConfig.CONFIG.blockBreaking.get()).booleanValue() && this.isSeen() && ((GameRules.BooleanValue)this.f_19853_.m_46469_().m_46170_(GameRules.f_46132_)).m_46223_()) {
            this.replaceBlocks();
        }
    }

    protected PathNavigation m_6037_(Level worldIn) {
        WallClimberNavigation navigator = new WallClimberNavigation((Mob)this, worldIn);
        navigator.m_7008_(false);
        navigator.m_26477_(true);
        navigator.m_26490_(false);
        navigator.m_26517_(1.0);
        return navigator;
    }

    private void replaceBlocks() {
        if (this.f_19853_.f_46443_ || this.f_19797_ % 100 != 0) {
            return;
        }
        if (this.f_19853_.m_46803_(this.m_142538_()) == 0) {
            return;
        }
        int range = (int)this.m_21133_((Attribute)WAAttributes.BLOCK_BREAK_RANGE.get());
        Iterator iterator = BlockPos.m_121985_((BlockPos)this.m_142538_(), (int)range, (int)3, (int)range).iterator();
        while (iterator.hasNext()) {
            ServerLevel serverWorld = (ServerLevel)this.f_19853_;
            BlockPos pos = (BlockPos)iterator.next();
            BlockState blockState = serverWorld.m_8055_(pos);
            if (!this.isAllowed(blockState, pos) || blockState.m_60734_() == Blocks.f_49991_) continue;
            if (blockState.m_60734_() == Blocks.f_50081_ || blockState.m_60734_() == Blocks.f_50174_ || blockState.m_60734_() == Blocks.f_50141_) {
                AngelUtil.updateBlock((LivingEntity)this, pos, Blocks.f_50016_.m_49966_(), true);
                return;
            }
            if (blockState.m_61138_((Property)BlockStateProperties.f_61443_)) {
                if (!((Boolean)blockState.m_61143_((Property)BlockStateProperties.f_61443_)).booleanValue()) continue;
                AngelUtil.updateBlock((LivingEntity)this, pos, (BlockState)blockState.m_61124_((Property)BlockStateProperties.f_61443_, (Comparable)Boolean.valueOf(false)), false);
                return;
            }
            if (this.f_19853_.m_7702_(pos) != null) {
                BlockEntity blockEntity = this.f_19853_.m_7702_(pos);
                blockEntity.getCapability(CapabilityEnergy.ENERGY).ifPresent(iEnergyStorage -> {
                    if (iEnergyStorage.canExtract()) {
                        iEnergyStorage.extractEnergy(100, false);
                        this.m_5634_(0.5f);
                    }
                });
            }
            if (blockState.m_60734_() instanceof NetherPortalBlock || blockState.m_60734_() instanceof EndPortalBlock) {
                if (!(this.m_21223_() < this.m_21233_())) continue;
                this.m_5634_(0.5f);
                Vec3 start = this.m_20182_();
                Vec3 end = new Vec3((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_());
                Vec3 path = start.m_82546_(end);
                for (int i = 0; i < 10; ++i) {
                    double percent = (double)i / 10.0;
                    ((ServerLevel)this.f_19853_).m_8767_((ParticleOptions)ParticleTypes.f_123760_, (double)pos.m_123341_() + 0.5 + path.m_7096_() * percent, (double)pos.m_123342_() + 1.3 + path.m_7098_() * percent, (double)pos.m_123343_() + 0.5 + path.f_82481_ * percent, 20, 0.0, 0.0, 0.0, 0.0);
                }
                return;
            }
            if (blockState.getLightEmission((BlockGetter)this.f_19853_, pos) <= 0 || blockState.m_60734_() instanceof NetherPortalBlock || blockState.m_60734_() instanceof EndPortalBlock) continue;
            AngelUtil.updateBlock((LivingEntity)this, pos, Blocks.f_50016_.m_49966_(), true);
            return;
        }
    }

    private void teleportInteraction(ServerPlayer player) {
        if (this.f_19853_.f_46443_) {
            return;
        }
        AngelUtil.EnumTeleportType type = (AngelUtil.EnumTeleportType)((Object)WAConfig.CONFIG.teleportType.get());
        switch (type) {
            case STRUCTURE: {
                WATeleporter.handleStructures(player);
                break;
            }
            case DONT: {
                this.m_7327_((Entity)player);
                break;
            }
            case RANDOM_PLACE: {
                double x = player.m_20185_() + (double)this.f_19796_.nextInt((Integer)WAConfig.CONFIG.teleportRange.get());
                double z = player.m_20189_() + (double)this.f_19796_.nextInt((Integer)WAConfig.CONFIG.teleportRange.get());
                ServerLevel teleportWorld = (Boolean)WAConfig.CONFIG.angelDimTeleport.get() != false ? WATeleporter.getRandomDimension(this.f_19796_) : (ServerLevel)player.f_19853_;
                ChunkPos chunkPos = new ChunkPos(new BlockPos(x, 0.0, z));
                teleportWorld.m_8602_(chunkPos.f_45578_, chunkPos.f_45579_, true);
                teleportWorld.m_142572_().m_6937_((Runnable)new TickTask(teleportWorld.m_142572_().m_129921_() + 1, () -> {
                    BlockPos blockPos = WATeleporter.findSafePlace((Player)player, (Level)teleportWorld, new BlockPos(x, player.m_20186_(), z));
                    if (AngelUtil.isOutsideOfBorder((Level)teleportWorld, blockPos)) {
                        this.dealDamage((Player)player);
                        return;
                    }
                    if (teleportWorld != null) {
                        this.dealDamage((Player)player);
                        WATeleporter.teleportPlayerTo(player, blockPos, teleportWorld);
                        teleportWorld.m_8602_(chunkPos.f_45578_, chunkPos.f_45579_, false);
                        this.m_5634_(10.0f);
                    }
                }));
            }
        }
    }

    public boolean m_5545_(LevelAccessor worldIn, MobSpawnType spawnReasonIn) {
        return worldIn.m_46791_() != Difficulty.PEACEFUL && super.m_5545_(worldIn, spawnReasonIn);
    }

    public String getAngelPose() {
        return (String)this.m_20088_().m_135370_(CURRENT_POSE);
    }

    public void setPose(WeepingAngelPose weepingAngelPose) {
        this.m_20088_().m_135381_(CURRENT_POSE, (Object)weepingAngelPose.name());
    }

    public boolean isCherub() {
        return this.getAngelType() == AngelType.ED_ANGEL_CHILD;
    }

    public AngelType getAngelType() {
        String type = (String)this.m_20088_().m_135370_(TYPE);
        return type.isEmpty() ? AngelType.DISASTER_MC : AngelType.valueOf(type);
    }

    public void setType(String angelType) {
        this.m_20088_().m_135381_(TYPE, (Object)angelType);
    }

    public void setType(AngelType angelType) {
        this.setType(angelType.name());
    }

    protected void m_6153_() {
        ++this.f_20919_;
        if (this.f_20919_ == 20) {
            this.f_20916_ = 0;
            this.m_6089_();
        }
        for (int i = 0; i < 20; ++i) {
            double d0 = this.f_19796_.nextGaussian() * 0.02;
            double d1 = this.f_19796_.nextGaussian() * 0.02;
            double d2 = this.f_19796_.nextGaussian() * 0.02;
            this.f_19853_.m_7106_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, Blocks.f_50069_.m_49966_()), this.m_20208_(1.0), this.m_20187_(), this.m_20262_(1.0), d0, d1, d2);
        }
    }

    public void m_6074_() {
        this.m_142687_(Entity.RemovalReason.KILLED);
    }

    public boolean isAllowed(BlockState blockState, BlockPos blockPos) {
        if (TagUtil.hasTag(ForgeRegistries.BLOCKS, AngelUtil.ANGEL_IGNORE, blockState.m_60734_())) {
            return false;
        }
        EventAngelBreakEvent eventAngelBreakEvent = new EventAngelBreakEvent(this, blockState, blockPos);
        MinecraftForge.EVENT_BUS.post((Event)eventAngelBreakEvent);
        return !eventAngelBreakEvent.isCanceled();
    }

    public float getLaugh() {
        return ((Float)this.m_20088_().m_135370_(LAUGH)).floatValue();
    }

    public void setLaugh(float laugh) {
        this.m_20088_().m_135381_(LAUGH, (Object)Float.valueOf(laugh));
    }

    public Cracks getCrackiness() {
        return Cracks.byFraction(this.m_21223_() / this.m_21233_());
    }

    public static enum Cracks {
        NONE(1.0f),
        LOW(0.75f),
        MEDIUM(0.5f),
        HIGH(0.25f);

        private static final List<Cracks> BY_DAMAGE;
        private final float fraction;

        private Cracks(float p_i225732_3_) {
            this.fraction = p_i225732_3_;
        }

        public static Cracks byFraction(float p_226515_0_) {
            for (Cracks weepCracks : BY_DAMAGE) {
                if (!(p_226515_0_ < weepCracks.fraction)) continue;
                return weepCracks;
            }
            return NONE;
        }

        static {
            BY_DAMAGE = (List)Stream.of(Cracks.values()).sorted(Comparator.comparingDouble(p_226516_0_ -> p_226516_0_.fraction)).collect(ImmutableList.toImmutableList());
        }
    }
}

