/*
 * Decompiled with CFR 0.152.
 */
package mc.craig.software.angels.common.events;

import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import mc.craig.software.angels.WeepingAngels;
import mc.craig.software.angels.common.WAObjects;
import mc.craig.software.angels.common.blockentities.CoffinBlockEntity;
import mc.craig.software.angels.common.blockentities.IPlinth;
import mc.craig.software.angels.common.blockentities.StatueBlockEntity;
import mc.craig.software.angels.common.entities.QuantumLockedLifeform;
import mc.craig.software.angels.common.entities.WeepingAngel;
import mc.craig.software.angels.common.items.ChiselItem;
import mc.craig.software.angels.common.level.WAFeatures;
import mc.craig.software.angels.config.WAConfig;
import mc.craig.software.angels.network.Network;
import mc.craig.software.angels.network.messages.MessageCatacomb;
import mc.craig.software.angels.utils.AngelUtil;
import mc.craig.software.angels.utils.DamageType;
import mc.craig.software.angels.utils.PlayerUtil;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DebugStickItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.PickaxeItem;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.ChestBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.world.BiomeLoadingEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.VersionChecker;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.forgespi.language.IModInfo;

@Mod.EventBusSubscriber
public class CommonEvents {
    public static BiomeDictionary.Type[] BIOME_TYPES = new BiomeDictionary.Type[]{BiomeDictionary.Type.PLAINS, BiomeDictionary.Type.FOREST, BiomeDictionary.Type.DEAD, BiomeDictionary.Type.SNOWY, BiomeDictionary.Type.SPOOKY};

    @SubscribeEvent
    public static void onKilled(LivingDeathEvent event) {
        LivingEntity killed = event.getEntityLiving();
        DamageSource damageSource = event.getSource();
        if (damageSource == WAObjects.ANGEL_NECK_SNAP) {
            killed.m_5496_((SoundEvent)WAObjects.Sounds.ANGEL_NECK_SNAP.get(), 1.0f, 1.0f);
        }
    }

    @SubscribeEvent
    public static void onBreak(BlockEvent.BreakEvent event) {
        BlockEntity blockEntity;
        Player playerEntity = event.getPlayer();
        LevelAccessor world = event.getWorld();
        BlockPos pos = event.getPos();
        boolean isPlinth = world.m_7702_(pos) instanceof IPlinth;
        boolean hasChisel = playerEntity.m_21120_(InteractionHand.MAIN_HAND).m_41720_() instanceof ChiselItem;
        if (isPlinth && playerEntity.m_21120_(InteractionHand.MAIN_HAND).m_41720_() instanceof ChiselItem) {
            IPlinth plinth = (IPlinth)world.m_7702_(pos);
            event.setCanceled(true);
            plinth.setAbstractVariant(plinth.getCurrentType().getWeightedHandler().getRandom(null));
            plinth.sendUpdatesToClient();
            PlayerUtil.sendMessageToPlayer(playerEntity, new TranslatableComponent("Changed variant to " + plinth.getVariant().getRegistryName()), true);
        }
        if (playerEntity.m_6844_(EquipmentSlot.HEAD).m_41720_() instanceof DebugStickItem && hasChisel && (blockEntity = world.m_7702_(pos)) instanceof CoffinBlockEntity) {
            CoffinBlockEntity coffinTile = (CoffinBlockEntity)blockEntity;
            event.setCanceled(true);
            coffinTile.setCoffin(CoffinBlockEntity.Coffin.next(coffinTile.getCoffin()));
            PlayerUtil.sendMessageToPlayer(playerEntity, new TranslatableComponent(coffinTile.getCoffin().name()), true);
        }
    }

    @SubscribeEvent
    public static void onOpenChestInGraveYard(PlayerInteractEvent.RightClickBlock event) {
        if (event.getWorld().f_46443_) {
            return;
        }
        ServerLevel world = (ServerLevel)event.getWorld();
        BlockPos pos = event.getPos();
        Player player = event.getPlayer();
        boolean isGraveYard = world.m_8595_().m_207785_(pos, AngelUtil.getConfigured(world, WAFeatures.GRAVEYARD.getId())).m_73603_();
        if (!isGraveYard) {
            return;
        }
        Block block = world.m_8055_(pos).m_60734_();
        if (block instanceof ChestBlock) {
            ChestBlock chestBlock = (ChestBlock)block;
            if (!player.m_150110_().f_35937_) {
                BoundingBox box = world.m_8595_().m_207785_(pos, AngelUtil.getConfigured(world, WAFeatures.GRAVEYARD.getId())).m_73601_();
                boolean canPlaySound = false;
                Iterator iterator = BlockPos.m_121990_((BlockPos)new BlockPos(box.m_162399_(), box.m_162400_(), box.m_162401_()), (BlockPos)new BlockPos(box.m_162395_(), box.m_162396_(), box.m_162398_())).iterator();
                while (iterator.hasNext()) {
                    BlockPos blockPos = (BlockPos)iterator.next();
                    BlockState blockState = world.m_8055_(blockPos);
                    if (blockState.m_60734_() != WAObjects.Blocks.STATUE.get()) continue;
                    canPlaySound = true;
                    StatueBlockEntity statueTile = (StatueBlockEntity)world.m_7702_(blockPos);
                    WeepingAngel angel = new WeepingAngel((Level)world);
                    angel.setType(statueTile.getAngelType());
                    angel.m_7678_((double)blockPos.m_123341_() + 0.5, blockPos.m_123342_(), (double)blockPos.m_123343_() + 0.5, 0.0f, 0.0f);
                    angel.setPose(statueTile.getPose());
                    world.m_7967_((Entity)angel);
                    world.m_7471_(blockPos, false);
                }
                if (canPlaySound) {
                    world.m_5594_(null, pos, (SoundEvent)WAObjects.Sounds.ANGEL_AMBIENT.get(), SoundSource.BLOCKS, 0.2f, 1.0f);
                }
            }
        }
    }

    @SubscribeEvent
    public static void onLive(LivingEvent.LivingUpdateEvent livingUpdateEvent) {
        LivingEntity living = livingUpdateEvent.getEntityLiving();
        if (living instanceof Player && !living.f_19853_.m_5776_()) {
            ServerPlayer serverPlayerEntity = (ServerPlayer)living;
            if (serverPlayerEntity.f_19797_ % 40 == 0) {
                Network.sendTo(new MessageCatacomb(AngelUtil.isInCatacomb((LivingEntity)serverPlayerEntity)), serverPlayerEntity);
            }
        }
    }

    @SubscribeEvent
    public static void onDamage(LivingAttackEvent event) {
        if (event.getEntityLiving().f_19853_.f_46443_) {
            return;
        }
        DamageType configValue = (DamageType)((Object)WAConfig.CONFIG.damageType.get());
        DamageSource source = event.getSource();
        Entity attacker = event.getSource().m_7639_();
        if (source == DamageSource.f_19317_ || source.m_19372_()) {
            return;
        }
        LivingEntity living = event.getEntityLiving();
        if (living.m_6095_() == WAObjects.EntityEntries.WEEPING_ANGEL.get()) {
            WeepingAngel hurt = (WeepingAngel)event.getEntityLiving();
            switch (configValue) {
                case NOTHING: {
                    event.setCanceled(true);
                    break;
                }
                case GENERATOR_ONLY: {
                    event.setCanceled(source != WAObjects.GENERATOR);
                    break;
                }
                case ANY_PICKAXE_ONLY: {
                    if (CommonEvents.isAttackerHoldingPickaxe(attacker)) {
                        LivingEntity livingEntity = (LivingEntity)attacker;
                        event.setCanceled(false);
                        CommonEvents.doHurt(hurt, attacker, livingEntity.m_6844_(EquipmentSlot.MAINHAND));
                        break;
                    }
                    event.setCanceled(true);
                    break;
                }
                case ANY_PICKAXE_AND_GENERATOR_ONLY: {
                    if (!CommonEvents.isAttackerHoldingPickaxe(attacker)) break;
                    LivingEntity livingEntity = (LivingEntity)attacker;
                    event.setCanceled(false);
                    CommonEvents.doHurt(hurt, attacker, livingEntity.m_6844_(EquipmentSlot.MAINHAND));
                    break;
                }
                case DIAMOND_AND_ABOVE_PICKAXE_ONLY: {
                    if (!CommonEvents.isAttackerHoldingPickaxe(attacker)) break;
                    LivingEntity livingEntity = (LivingEntity)attacker;
                    PickaxeItem pickaxe = (PickaxeItem)livingEntity.m_6844_(EquipmentSlot.MAINHAND).m_41720_();
                    boolean isDiamondAndAbove = Objects.equals(pickaxe.m_43314_().getTag(), BlockTags.f_144284_);
                    if (isDiamondAndAbove) {
                        CommonEvents.doHurt(hurt, attacker, livingEntity.m_6844_(EquipmentSlot.MAINHAND));
                    }
                    event.setCanceled(!isDiamondAndAbove);
                }
            }
            if (!CommonEvents.isAttackerHoldingPickaxe(attacker) || configValue == DamageType.NOTHING || configValue == DamageType.GENERATOR_ONLY) {
                if (hurt.f_19853_.f_46441_.nextInt(100) <= 20) {
                    hurt.m_5496_(hurt.isCherub() ? (SoundEvent)WAObjects.Sounds.LAUGHING_CHILD.get() : (SoundEvent)WAObjects.Sounds.ANGEL_MOCKING.get(), 1.0f, hurt.getLaugh());
                }
                if (attacker != null) {
                    attacker.m_6469_(WAObjects.STONE, 2.0f);
                }
            }
        }
    }

    public static void doHurt(QuantumLockedLifeform weepingAngel, @Nullable Entity attacker, ItemStack stack) {
        ServerLevel serverWorld = (ServerLevel)weepingAngel.f_19853_;
        weepingAngel.m_5496_(SoundEvents.f_12442_, 1.0f, 1.0f);
        serverWorld.m_8767_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, Blocks.f_50069_.m_49966_()), weepingAngel.m_20185_(), weepingAngel.m_20227_(0.5), weepingAngel.m_20189_(), 5, 0.1, 0.0, 0.1, 0.2);
        if (attacker instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)attacker;
            stack.m_41622_(serverWorld.f_46441_.nextInt(4), livingEntity, living -> {
                if (weepingAngel instanceof WeepingAngel) {
                    WeepingAngel angel = (WeepingAngel)weepingAngel;
                    weepingAngel.m_5496_(angel.isCherub() ? (SoundEvent)WAObjects.Sounds.LAUGHING_CHILD.get() : (SoundEvent)WAObjects.Sounds.ANGEL_MOCKING.get(), 1.0f, angel.getLaugh());
                }
                livingEntity.m_21190_(InteractionHand.MAIN_HAND);
            });
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void onBiomeLoad(BiomeLoadingEvent biomeLoadingEvent) {
        if (((List)WAConfig.spawnBiomes.get()).contains(biomeLoadingEvent.getName().toString())) {
            WeepingAngels.LOGGER.info("Added Weeping Angel Spawns to {} with min {} & max {} with weight {} || Type {}", (Object)biomeLoadingEvent.getName().toString(), WAConfig.CONFIG.minCount.get(), WAConfig.CONFIG.maxCount.get(), WAConfig.CONFIG.spawnWeight.get(), WAConfig.CONFIG.spawnType.get());
            biomeLoadingEvent.getSpawns().getSpawner((MobCategory)WAConfig.CONFIG.spawnType.get()).add(new MobSpawnSettings.SpawnerData((EntityType)WAObjects.EntityEntries.WEEPING_ANGEL.get(), ((Integer)WAConfig.CONFIG.spawnWeight.get()).intValue(), ((Integer)WAConfig.CONFIG.minCount.get()).intValue(), ((Integer)WAConfig.CONFIG.maxCount.get()).intValue()));
        }
    }

    @SubscribeEvent
    public static void onLoad(PlayerEvent.PlayerLoggedInEvent event) {
        Entity entity = event.getEntity();
        if (entity instanceof Player) {
            Player playerEntity = (Player)entity;
            CommonEvents.versionCheck(playerEntity);
        }
    }

    public static void versionCheck(Player playerEntity) {
        VersionChecker.CheckResult version = VersionChecker.getResult((IModInfo)((IModInfo)ModList.get().getModFileById("weeping_angels").getMods().get(0)));
        if (version.status() == VersionChecker.Status.OUTDATED) {
            TranslatableComponent click = new TranslatableComponent("Download");
            click.m_6270_(Style.f_131099_.m_131162_(Boolean.valueOf(true)).m_131140_(ChatFormatting.GREEN).m_131142_(new ClickEvent(ClickEvent.Action.OPEN_URL, "https://www.curseforge.com/minecraft/mc-mods/weeping-angels-mod")));
            TranslatableComponent translationTextComponent = new TranslatableComponent(ChatFormatting.BOLD + "[" + ChatFormatting.RESET + ChatFormatting.YELLOW + "Weeping Angels" + ChatFormatting.RESET + ChatFormatting.BOLD + "]");
            translationTextComponent.m_7220_((Component)new TranslatableComponent(" New Update Found: (" + version.target() + ") ").m_7220_((Component)click));
            PlayerUtil.sendMessageToPlayer(playerEntity, translationTextComponent, false);
        }
    }

    public static boolean isAttackerHoldingPickaxe(Entity entity) {
        if (entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            return livingEntity.m_6844_(EquipmentSlot.MAINHAND).m_41720_() instanceof PickaxeItem;
        }
        return false;
    }
}

