/*
 * Decompiled with CFR 0.152.
 */
package mc.craig.software.angels.common.level.structures;

import java.util.Optional;
import java.util.Random;
import mc.craig.software.angels.config.WAConfig;
import mc.craig.software.angels.utils.AngelUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.QuartPos;
import net.minecraft.util.Mth;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.LegacyRandomSource;
import net.minecraft.world.level.levelgen.RandomSource;
import net.minecraft.world.level.levelgen.WorldgenRandom;
import net.minecraft.world.level.levelgen.feature.StructureFeature;
import net.minecraft.world.level.levelgen.feature.configurations.JigsawConfiguration;
import net.minecraft.world.level.levelgen.structure.PoolElementStructurePiece;
import net.minecraft.world.level.levelgen.structure.PostPlacementProcessor;
import net.minecraft.world.level.levelgen.structure.pieces.PieceGenerator;
import net.minecraft.world.level.levelgen.structure.pieces.PieceGeneratorSupplier;
import net.minecraft.world.level.levelgen.structure.pools.JigsawPlacement;
import org.jetbrains.annotations.NotNull;

public class CatacombStructure
extends StructureFeature<JigsawConfiguration> {
    protected static final String[] variants = new String[]{"flat", "clean", "broken", "normal", "classic"};

    public CatacombStructure() {
        super(JigsawConfiguration.f_67756_, CatacombStructure::createPiecesGenerator, PostPlacementProcessor.f_192427_);
    }

    private static boolean isFeatureChunk(PieceGeneratorSupplier.Context<JigsawConfiguration> context) {
        WorldgenRandom worldgenrandom = new WorldgenRandom((RandomSource)new LegacyRandomSource(0L));
        worldgenrandom.m_190068_(context.f_197354_(), context.f_197355_().f_45578_, context.f_197355_().f_45579_);
        Holder biome = Holder.m_205709_((Object)context.f_197358_());
        return context.f_197358_().test(context.f_197352_().m_203495_(QuartPos.m_175400_((int)context.f_197355_().m_151390_()), QuartPos.m_175400_((int)50), QuartPos.m_175400_((int)context.f_197355_().m_151393_()))) && (Boolean)WAConfig.CONFIG.genCatacombs.get() != false;
    }

    @NotNull
    private static Optional<PieceGenerator<JigsawConfiguration>> createPiecesGenerator(PieceGeneratorSupplier.Context<JigsawConfiguration> jigsawConfigurationContext) {
        if (!CatacombStructure.isFeatureChunk(jigsawConfigurationContext)) {
            return Optional.empty();
        }
        BlockPos blockpos = jigsawConfigurationContext.f_197355_().m_151394_(0);
        int yPos = Mth.m_144928_((Random)AngelUtil.RAND, (int)30, (int)40) * -1;
        return JigsawPlacement.m_210284_(jigsawConfigurationContext, PoolElementStructurePiece::new, (BlockPos)blockpos.m_175288_(yPos), (boolean)false, (boolean)false);
    }

    public GenerationStep.Decoration m_67095_() {
        return GenerationStep.Decoration.UNDERGROUND_STRUCTURES;
    }
}

