/*
 * Decompiled with CFR 0.152.
 */
package mc.craig.software.angels.common.variants;

import java.util.function.Predicate;
import mc.craig.software.angels.common.entities.WeepingAngel;
import mc.craig.software.angels.common.variants.AngelTypes;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import net.minecraftforge.registries.ForgeRegistryEntry;

public abstract class AbstractVariant
extends ForgeRegistryEntry<AbstractVariant> {
    private final Predicate<WeepingAngel> variantTest;
    private boolean isHeadless = false;

    public AbstractVariant(Predicate<WeepingAngel> weepingAngelEntityPredicate) {
        this.variantTest = weepingAngelEntityPredicate;
    }

    public void tick(WeepingAngel weepingAngel) {
        if (weepingAngel.getVariant() == AngelTypes.RUSTED_NO_ARM.get()) {
            weepingAngel.m_21559_(true);
            if (!weepingAngel.m_21206_().m_41619_()) {
                weepingAngel.m_19983_(weepingAngel.m_21206_());
                weepingAngel.m_21008_(InteractionHand.OFF_HAND, ItemStack.f_41583_);
            }
        } else {
            weepingAngel.m_21559_(false);
        }
    }

    public Predicate<WeepingAngel> getVariantTest() {
        return this.variantTest;
    }

    public ItemStack stackDrop() {
        return new ItemStack((ItemLike)Blocks.f_50016_);
    }

    public boolean shouldDrop(DamageSource damageSource, WeepingAngel quantumLockEntity) {
        return false;
    }

    public boolean isHeadless() {
        return this.isHeadless;
    }

    public AbstractVariant setHeadless(boolean isHeadless) {
        this.isHeadless = isHeadless;
        return this;
    }

    public abstract double getRarity();

    public boolean canVariantBeUsed(WeepingAngel weepingAngel) {
        if (this.variantTest == null) {
            return true;
        }
        return this.variantTest.test(weepingAngel);
    }
}

