/*
 * Decompiled with CFR 0.152.
 */
package mc.craig.software.angels.common.variants;

import java.util.function.Predicate;
import java.util.function.Supplier;
import mc.craig.software.angels.common.entities.WeepingAngel;
import mc.craig.software.angels.common.variants.AbstractVariant;
import mc.craig.software.angels.common.variants.AngelTypes;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.item.ItemStack;

public class BaseVariant
extends AbstractVariant {
    private final int rarity;
    private final Supplier<ItemStack> dropStack;

    public BaseVariant(Supplier<ItemStack> itemStackSupplier, int rarity, Predicate<WeepingAngel> variantTest) {
        super(variantTest);
        this.dropStack = itemStackSupplier;
        this.rarity = rarity;
    }

    public BaseVariant(Supplier<ItemStack> itemStackSupplier, int rarity) {
        super(AngelTypes.BANNED_FROM_NETHER);
        this.dropStack = itemStackSupplier;
        this.rarity = rarity;
    }

    @Override
    public ItemStack stackDrop() {
        return this.dropStack.get();
    }

    @Override
    public boolean shouldDrop(DamageSource damageSource, WeepingAngel quantumLockEntity) {
        return true;
    }

    @Override
    public double getRarity() {
        return this.rarity;
    }
}

