/*
 * Decompiled with CFR 0.152.
 */
package mc.craig.software.angels.common.variants;

import java.util.ArrayList;
import java.util.List;
import mc.craig.software.angels.common.entities.WeepingAngel;
import mc.craig.software.angels.common.variants.AbstractVariant;
import mc.craig.software.angels.common.variants.AngelTypes;
import mc.craig.software.angels.config.WAConfig;
import mc.craig.software.angels.utils.AngelUtil;

public class WeightedHandler {
    private final List<Entry> entries = new ArrayList<Entry>();
    private double accumulatedWeight;

    public void addEntry(AbstractVariant abstractVariant) {
        this.accumulatedWeight += abstractVariant.getRarity();
        Entry e = new Entry();
        e.abstractVariant = abstractVariant;
        e.accumulatedWeight = this.accumulatedWeight;
        this.entries.add(e);
    }

    public AbstractVariant getRandom(WeepingAngel weepingAngel) {
        double r = AngelUtil.RAND.nextDouble() * this.accumulatedWeight;
        for (Entry entry : this.entries) {
            if (!(entry.accumulatedWeight >= r) || !WAConfig.CONFIG.isVariantPermitted(entry.abstractVariant)) continue;
            if (weepingAngel == null || weepingAngel.getVariant() == null) {
                return entry.abstractVariant;
            }
            if (!weepingAngel.getVariant().canVariantBeUsed(weepingAngel)) continue;
            return entry.abstractVariant;
        }
        return (AbstractVariant)((Object)AngelTypes.NORMAL.get());
    }

    public boolean isEmpty() {
        return this.entries.isEmpty();
    }

    public List<Entry> getEntries() {
        return this.entries;
    }

    private static class Entry {
        double accumulatedWeight;
        AbstractVariant abstractVariant;

        private Entry() {
        }
    }
}

