/*
 * Decompiled with CFR 0.152.
 */
package mc.craig.software.angels.data;

import com.google.gson.JsonObject;
import java.util.List;
import java.util.Random;
import mc.craig.software.angels.common.WAObjects;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraftforge.common.loot.GlobalLootModifierSerializer;
import net.minecraftforge.common.loot.LootModifier;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegistryObject;

public class WAGlobalLoot {
    public static final DeferredRegister<GlobalLootModifierSerializer<?>> GLM = DeferredRegister.create((ResourceKey)ForgeRegistries.Keys.LOOT_MODIFIER_SERIALIZERS, (String)"weeping_angels");
    public static final RegistryObject<DiscLoot.Serializer> ANGEL_LOOT = GLM.register("loot", DiscLoot.Serializer::new);

    public static ItemStack genMusicDisc(Random random) {
        return new ItemStack(random.nextBoolean() ? (ItemLike)WAObjects.Items.SALLY.get() : (ItemLike)WAObjects.Items.TIME_PREVAILS.get());
    }

    public static class DiscLoot
    extends LootModifier {
        private final int chance;

        public DiscLoot(LootItemCondition[] conditionsIn, int chance) {
            super(conditionsIn);
            this.chance = chance;
        }

        protected List<ItemStack> doApply(List<ItemStack> generatedLoot, LootContext context) {
            if (context.m_78933_().nextInt(100) <= this.chance) {
                generatedLoot.add(WAGlobalLoot.genMusicDisc(context.m_78933_()));
            }
            return generatedLoot;
        }

        private static class Serializer
        extends GlobalLootModifierSerializer<DiscLoot> {
            private Serializer() {
            }

            public DiscLoot read(ResourceLocation location, JsonObject object, LootItemCondition[] conditions) {
                int multiplicationFactor = GsonHelper.m_13824_((JsonObject)object, (String)"chance", (int)2);
                return new DiscLoot(conditions, multiplicationFactor);
            }

            public JsonObject write(DiscLoot instance) {
                JsonObject obj = this.makeConditions(instance.conditions);
                obj.addProperty("chance", (Number)instance.chance);
                return obj;
            }
        }
    }
}

