/*
 * Decompiled with CFR 0.152.
 */
package mc.craig.software.angels.utils;

import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import mc.craig.software.angels.client.models.entity.ModelAngelChild;
import mc.craig.software.angels.client.models.entity.ModelAngelEd;
import mc.craig.software.angels.client.models.entity.ModelAplan;
import mc.craig.software.angels.client.models.entity.ModelClassicAngel;
import mc.craig.software.angels.client.models.entity.ModelDisasterAngel;
import mc.craig.software.angels.client.models.entity.ModelDoctorAngel;
import mc.craig.software.angels.client.models.entity.ModelVAWeepingAngel;
import mc.craig.software.angels.client.models.entity.ModelWeepingVillager;
import mc.craig.software.angels.client.models.entity.WAModels;
import mc.craig.software.angels.client.renders.blockentities.CoffinRenderer;
import mc.craig.software.angels.client.renders.blockentities.PlinthRender;
import mc.craig.software.angels.client.renders.blockentities.SnowAngelRenderer;
import mc.craig.software.angels.client.renders.blockentities.StatueRender;
import mc.craig.software.angels.client.sounds.EchoSound;
import mc.craig.software.angels.common.WAObjects;
import mc.craig.software.angels.common.entities.AngelType;
import mc.craig.software.angels.common.entities.WeepingAngel;
import mc.craig.software.angels.common.items.AngelSpawnerItem;
import mc.craig.software.angels.utils.AngelUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderers;
import net.minecraft.client.renderer.item.ClampedItemPropertyFunction;
import net.minecraft.client.renderer.item.ItemProperties;
import net.minecraft.client.renderer.item.ItemPropertyFunction;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class ClientUtil {
    public static final Map<AngelType, EntityModel<WeepingAngel>> MODEL_MAP = new HashMap<AngelType, EntityModel<WeepingAngel>>();

    public static EntityModel<WeepingAngel> getModelForAngel(AngelType angelType) {
        if (MODEL_MAP.isEmpty()) {
            EntityModelSet theBakerMan = Minecraft.m_91087_().m_167973_();
            MODEL_MAP.put(AngelType.ED_ANGEL_CHILD, (EntityModel<WeepingAngel>)new ModelAngelChild(theBakerMan.m_171103_(WAModels.ANGEL_CHERUB)));
            MODEL_MAP.put(AngelType.DISASTER_MC, (EntityModel<WeepingAngel>)new ModelDisasterAngel(theBakerMan.m_171103_(WAModels.ANGEL_DISASTER)));
            MODEL_MAP.put(AngelType.ED, (EntityModel<WeepingAngel>)new ModelAngelEd(theBakerMan.m_171103_(WAModels.ANGEL_ED)));
            MODEL_MAP.put(AngelType.A_DIZZLE, (EntityModel<WeepingAngel>)new ModelClassicAngel(theBakerMan.m_171103_(WAModels.ANGEL_CLASSIC)));
            MODEL_MAP.put(AngelType.VILLAGER, new ModelWeepingVillager(theBakerMan.m_171103_(WAModels.ANGEL_VILLAGER)));
            MODEL_MAP.put(AngelType.DYING, (EntityModel<WeepingAngel>)new ModelAplan(theBakerMan.m_171103_(WAModels.DYING_ANGEL), true));
            MODEL_MAP.put(AngelType.DOCTOR, new ModelDoctorAngel(theBakerMan.m_171103_(WAModels.DOCTOR_ANGEL)));
            MODEL_MAP.put(AngelType.SPARE_TIME, new ModelVAWeepingAngel(theBakerMan.m_171103_(WAModels.ANGEL_SPARE)));
        }
        return MODEL_MAP.get((Object)angelType);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void playSound(SoundEvent soundIn, float volumeSfx) {
        Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119752_((SoundEvent)soundIn, (float)volumeSfx));
    }

    public static void doClientStuff() {
        BlockEntityRenderers.m_173590_((BlockEntityType)((BlockEntityType)WAObjects.Tiles.SNOW_ANGEL.get()), SnowAngelRenderer::new);
        BlockEntityRenderers.m_173590_((BlockEntityType)((BlockEntityType)WAObjects.Tiles.PLINTH.get()), PlinthRender::new);
        BlockEntityRenderers.m_173590_((BlockEntityType)((BlockEntityType)WAObjects.Tiles.STATUE.get()), StatueRender::new);
        BlockEntityRenderers.m_173590_((BlockEntityType)((BlockEntityType)WAObjects.Tiles.COFFIN.get()), CoffinRenderer::new);
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)WAObjects.Blocks.SNOW_ANGEL.get()), (RenderType)RenderType.m_110463_());
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)WAObjects.Blocks.PLINTH.get()), (RenderType)RenderType.m_110463_());
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)WAObjects.Blocks.STATUE.get()), (RenderType)RenderType.m_110463_());
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)WAObjects.Blocks.KONTRON_ORE.get()), (RenderType)RenderType.m_110463_());
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)WAObjects.Blocks.KONTRON_ORE_DEEPSLATE.get()), (RenderType)RenderType.m_110463_());
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)WAObjects.Blocks.CHRONODYNE_GENERATOR.get()), (RenderType)RenderType.m_110463_());
        ItemProperties.register((Item)((Item)WAObjects.Items.TIMEY_WIMEY_DETECTOR.get()), (ResourceLocation)new ResourceLocation("time"), (ItemPropertyFunction)new ClampedItemPropertyFunction(){
            private double rotation;
            private double rota;
            private long lastUpdateTick;

            public float m_142187_(ItemStack itemStack, @Nullable ClientLevel clientLevel, @Nullable LivingEntity livingEntity, int p_174668_) {
                LivingEntity entity;
                Object object = entity = livingEntity != null ? livingEntity : itemStack.m_41609_();
                if (entity instanceof WeepingAngel && AngelUtil.isHalloween()) {
                    return 18.0f;
                }
                if (entity == null) {
                    return 0.0f;
                }
                if (clientLevel == null && entity.f_19853_ instanceof ClientLevel) {
                    clientLevel = (ClientLevel)entity.f_19853_;
                }
                if (clientLevel == null) {
                    return 0.0f;
                }
                double d0 = clientLevel.m_6042_().m_63956_() ? (double)clientLevel.m_46942_(1.0f) : Math.random();
                d0 = this.wobble((Level)clientLevel, d0);
                return (float)d0;
            }

            private double wobble(Level level, double p_117905_) {
                if (level.m_46467_() != this.lastUpdateTick) {
                    this.lastUpdateTick = level.m_46467_();
                    double d0 = p_117905_ - this.rotation;
                    d0 = Mth.m_14109_((double)(d0 + 0.5), (double)1.0) - 0.5;
                    this.rota += d0 * 0.1;
                    this.rota *= 0.9;
                    this.rotation = Mth.m_14109_((double)(this.rotation + this.rota), (double)1.0);
                }
                return this.rotation;
            }
        });
        ItemProperties.register((Item)((Item)WAObjects.Items.ANGEL_SPAWNER.get()), (ResourceLocation)new ResourceLocation("weeping_angels", "angel_type"), (itemStack, clientWorld, livingEntity, something) -> {
            if (itemStack == null || itemStack.m_41619_()) {
                return 0.0f;
            }
            AngelType type = AngelSpawnerItem.getType(itemStack);
            return type.ordinal();
        });
        EchoSound.addReloader();
    }
}

