/*
 * Decompiled with CFR 0.152.
 */
package mc.craig.software.angels.utils;

import com.google.common.collect.ImmutableSet;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import java.util.Set;
import mc.craig.software.angels.utils.AngelUtil;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.IntRange;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.functions.LootItemConditionalFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionType;
import net.minecraft.world.level.storage.loot.parameters.LootContextParam;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;

public class FortuneBonusEnchant
extends LootItemConditionalFunction {
    private final IntRange count;
    private final int limit;

    private FortuneBonusEnchant(LootItemCondition[] conditions, IntRange countIn, int limitIn) {
        super(conditions);
        this.count = countIn;
        this.limit = limitIn;
    }

    public Builder builder(IntRange p_215915_0_) {
        return new Builder(p_215915_0_);
    }

    public Set<LootContextParam<?>> m_6231_() {
        return ImmutableSet.of((Object)LootContextParams.f_81458_);
    }

    private boolean hasLimit() {
        return this.limit > 0;
    }

    public ItemStack m_7372_(ItemStack stack, LootContext context) {
        Entity entity = (Entity)context.m_78953_(LootContextParams.f_81458_);
        if (entity instanceof LivingEntity) {
            int i = AngelUtil.getFortuneModifier((LivingEntity)entity);
            if (i == 0) {
                return stack;
            }
            stack.m_41769_(Math.round(context.m_78933_().nextInt(5)));
            if (this.hasLimit() && stack.m_41613_() > this.limit) {
                stack.m_41764_(this.limit);
            }
        }
        return stack;
    }

    public LootItemFunctionType m_7162_() {
        return null;
    }

    public static class Builder
    extends LootItemConditionalFunction.Builder<Builder> {
        private final IntRange count;
        private int limit = 0;

        public Builder(IntRange p_i50932_1_) {
            this.count = p_i50932_1_;
        }

        protected Builder getThis() {
            return this;
        }

        public Builder setLimit(int p_216072_1_) {
            this.limit = p_216072_1_;
            return this;
        }

        public LootItemFunction m_7453_() {
            return new FortuneBonusEnchant(this.m_80699_(), this.count, this.limit);
        }
    }

    public static class Serializer
    extends LootItemConditionalFunction.Serializer<FortuneBonusEnchant> {
        public void serialize(JsonObject object, FortuneBonusEnchant functionClazz, JsonSerializationContext serializationContext) {
            super.m_6170_(object, (LootItemConditionalFunction)functionClazz, serializationContext);
            object.add("count", serializationContext.serialize((Object)functionClazz.count));
            if (functionClazz.hasLimit()) {
                object.add("limit", serializationContext.serialize((Object)functionClazz.limit));
            }
        }

        public FortuneBonusEnchant deserialize(JsonObject object, JsonDeserializationContext deserializationContext, LootItemCondition[] conditionsIn) {
            int i = GsonHelper.m_13824_((JsonObject)object, (String)"limit", (int)0);
            return new FortuneBonusEnchant(conditionsIn, (IntRange)GsonHelper.m_13836_((JsonObject)object, (String)"count", (JsonDeserializationContext)deserializationContext, IntRange.class), i);
        }
    }
}

