/*
 * Decompiled with CFR 0.152.
 */
package mc.craig.software.angels.utils;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import mc.craig.software.angels.common.WAObjects;
import mc.craig.software.angels.config.WAConfig;
import mc.craig.software.angels.network.Network;
import mc.craig.software.angels.network.messages.MessageSFX;
import mc.craig.software.angels.utils.AngelUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.feature.ConfiguredStructureFeature;
import net.minecraftforge.server.ServerLifecycleHooks;

public class WATeleporter {
    public static BlockPos findSafePlace(Player playerEntity, Level world, BlockPos pos) {
        if (world.m_46472_().equals((Object)Level.f_46430_)) {
            return ServerLevel.f_8562_;
        }
        for (int i = 5; i > 0; --i) {
            for (int y = 0; y < world.m_151558_(); ++y) {
                BlockPos newPos = new BlockPos(pos.m_123341_() + i * 20, y, pos.m_123343_() + i * 20);
                if (!WATeleporter.isTeleportFriendlyBlock(world, pos, playerEntity) || WATeleporter.isPosBelowOrAboveWorld(world, newPos.m_123342_())) continue;
                System.out.println("Teleporting player to " + newPos + " || " + world.m_8055_(newPos));
                return newPos;
            }
        }
        return world.m_5452_(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, pos);
    }

    public static ServerLevel getRandomDimension(Random rand) {
        Iterable dimensions = ServerLifecycleHooks.getCurrentServer().m_129785_();
        ArrayList allowedDimensions = Lists.newArrayList((Iterable)dimensions);
        for (ServerLevel dimension : dimensions) {
            for (String dimName : (List)WAConfig.CONFIG.notAllowedDimensions.get()) {
                if (!dimension.m_46472_().m_135782_().toString().equalsIgnoreCase(dimName)) continue;
                allowedDimensions.remove(dimension);
            }
        }
        allowedDimensions.remove(ServerLifecycleHooks.getCurrentServer().m_129880_(Level.f_46429_));
        return (ServerLevel)allowedDimensions.get(rand.nextInt(allowedDimensions.size()));
    }

    public static void teleportPlayerTo(ServerPlayer player, BlockPos destinationPos, ServerLevel targetDimension) {
        Network.sendTo(new MessageSFX(((SoundEvent)WAObjects.Sounds.TELEPORT.get()).getRegistryName()), player);
        player.m_8999_(targetDimension, (double)destinationPos.m_123341_(), (double)destinationPos.m_123342_(), (double)destinationPos.m_123343_(), player.f_20885_, player.f_19860_);
    }

    public static boolean handleStructures(ServerPlayer player) {
        ServerLevel serverWorld;
        BlockPos bPos;
        TagKey<ConfiguredStructureFeature<?, ?>> targetStructure = AngelUtil.TELEPORT_STRUCTURES;
        if (targetStructure != null && (bPos = (serverWorld = (ServerLevel)player.f_19853_).m_207561_(targetStructure, player.m_142538_(), Integer.MAX_VALUE, false)) != null) {
            WATeleporter.teleportPlayerTo(player, bPos, player.m_183503_());
            return true;
        }
        return false;
    }

    public static boolean isPosBelowOrAboveWorld(Level dim, int y) {
        if (dim.m_46472_() == Level.f_46429_) {
            return y <= 0 || y >= 126;
        }
        return y <= 0 || y >= 256;
    }

    private static boolean isTeleportFriendlyBlock(Level world, BlockPos pos, Player playerEntity) {
        BlockState state = world.m_8055_(pos);
        BlockPos blockpos = pos.m_141950_((Vec3i)playerEntity.m_142538_());
        return state.m_60767_().m_76334_() && state.m_60838_((BlockGetter)world, pos) && world.m_45756_((Entity)playerEntity, playerEntity.m_142469_().m_82338_(blockpos));
    }
}

