/*
 * Decompiled with CFR 0.152.
 */
package io.github.cottonmc.clientcommands.impl;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import io.github.cottonmc.clientcommands.ClientCommands;
import io.github.cottonmc.clientcommands.CottonClientCommandSource;
import java.util.Collections;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;

@Environment(value=EnvType.CLIENT)
public final class CommandCache {
    private static final CommandDispatcher<CottonClientCommandSource> DISPATCHER = new CommandDispatcher();

    private CommandCache() {
    }

    public static void build() {
        ClientCommands.getPlugins().forEach(provider -> provider.registerCommands(DISPATCHER));
    }

    public static int execute(String input, CottonClientCommandSource source) throws CommandSyntaxException {
        return DISPATCHER.execute(input, (Object)source);
    }

    public static boolean hasCommand(String name) {
        return DISPATCHER.findNode(Collections.singleton(name)) != null;
    }
}

