/*
 * Decompiled with CFR 0.152.
 */
package me.sargunvohra.mcmods.autoconfig1u;

import me.sargunvohra.mcmods.autoconfig1u.ConfigData;
import me.sargunvohra.mcmods.autoconfig1u.ConfigHolder;
import me.sargunvohra.mcmods.autoconfig1u.annotation.Config;
import me.sargunvohra.mcmods.autoconfig1u.serializer.ConfigSerializer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ConfigManager<T extends ConfigData>
implements ConfigHolder<T> {
    private final Logger logger = LogManager.getLogger();
    private final Config definition;
    private final Class<T> configClass;
    private final ConfigSerializer<T> serializer;
    private T config;

    ConfigManager(Config definition, Class<T> configClass, ConfigSerializer<T> serializer) {
        this.definition = definition;
        this.configClass = configClass;
        this.serializer = serializer;
        if (this.load()) {
            this.save();
        }
    }

    public Config getDefinition() {
        return this.definition;
    }

    public Class<T> getConfigClass() {
        return this.configClass;
    }

    public ConfigSerializer<T> getSerializer() {
        return this.serializer;
    }

    public void save() {
        try {
            this.serializer.serialize(this.config);
        }
        catch (ConfigSerializer.SerializationException e) {
            this.logger.error("Failed to save config '{}'", this.configClass, (Object)e);
        }
    }

    private boolean load() {
        try {
            this.config = this.serializer.deserialize();
            this.config.validatePostLoad();
            return true;
        }
        catch (ConfigData.ValidationException | ConfigSerializer.SerializationException e) {
            this.logger.error("Failed to load config '{}', using default!", this.configClass, (Object)e);
            this.config = this.serializer.createDefault();
            try {
                this.config.validatePostLoad();
            }
            catch (ConfigData.ValidationException v) {
                throw new RuntimeException("result of createDefault() was invalid!", v);
            }
            return false;
        }
    }

    @Override
    public T getConfig() {
        return this.config;
    }
}

