/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.stackup.client;

import net.minecraft.client.gui.FontRenderer;
import net.minecraft.util.math.MathHelper;
import pl.asie.stackup.StackUp;
import pl.asie.stackup.StackUpConfig;

public class StackUpTextGenerator {
    public static int getStringLenWithoutFmtCodes(String count) {
        int i = 0;
        while (count.codePointAt(i) == 167) {
            i += 2;
        }
        return count.length() - i;
    }

    public static AbbreviationResult abbreviate(FontRenderer fr, String count, int maxWidth, boolean justCheckAbbreviation) {
        String oldString = count;
        StringBuilder fmtCodes = new StringBuilder();
        int fmtCodeCount = 0;
        while (count.codePointAt(0) == 167) {
            fmtCodes.append(count, 0, 2);
            ++fmtCodeCount;
            count = count.substring(2);
        }
        AbbreviationResult result = StackUpTextGenerator.abbreviateInner(fr, count, maxWidth, justCheckAbbreviation);
        if (fmtCodeCount > 0) {
            result.setText(fmtCodes.append(result.getText()).toString());
        }
        return result;
    }

    private static AbbreviationResult abbreviateInner(FontRenderer fr, String count, int maxWidth, boolean justCheckAbbreviation) {
        int countI;
        int maxScaleFactor = StackUp.proxy.getCurrentScaleFactor();
        try {
            countI = Integer.parseInt(count);
        }
        catch (NumberFormatException e) {
            countI = -1;
        }
        if (countI < 0) {
            return StackUpTextGenerator.tryFitString(fr, maxWidth, count, count, maxScaleFactor, false);
        }
        int tmpCountI = countI;
        int paddedCountI = 1;
        while (tmpCountI >= 10) {
            tmpCountI /= 10;
            paddedCountI *= 10;
        }
        AbbreviationResult result = StackUpTextGenerator.tryFitString(fr, maxWidth, Integer.toString(paddedCountI *= tmpCountI), count, maxScaleFactor, false);
        if (!result.isFits() && !(result = StackUpTextGenerator.tryFitString(fr, maxWidth, StackUpTextGenerator.abbreviateInnerLong(paddedCountI), StackUpTextGenerator.abbreviateInnerLong(countI), maxScaleFactor, true)).isFits()) {
            result = StackUpTextGenerator.tryFitString(fr, maxWidth, StackUpTextGenerator.abbreviateInnerShort(paddedCountI), StackUpTextGenerator.abbreviateInnerShort(countI), maxScaleFactor, true);
        }
        return result;
    }

    private static AbbreviationResult tryFitString(FontRenderer fr, int maxWidth, String comparedText, String text, int maxScaleFactor, boolean abbreviated) {
        int cfgMaxScaleFactor;
        int strWidth = Math.max(fr.func_78256_a(text), fr.func_78256_a(comparedText));
        if (StackUpConfig.scaleTextLinearly) {
            float scaleFactor = (float)maxWidth / (float)strWidth;
            boolean fits = true;
            if (scaleFactor > StackUpConfig.highestScaleDown) {
                scaleFactor = StackUpConfig.highestScaleDown;
            } else if (scaleFactor < StackUpConfig.lowestScaleDown) {
                scaleFactor = StackUpConfig.lowestScaleDown;
                fits = false;
            }
            return new AbbreviationResult(text, scaleFactor, fits, abbreviated);
        }
        int cfgMinScaleFactor = MathHelper.func_76125_a((int)Math.round(StackUpConfig.lowestScaleDown * (float)maxScaleFactor), (int)1, (int)maxScaleFactor);
        if (cfgMinScaleFactor != (cfgMaxScaleFactor = MathHelper.func_76125_a((int)Math.round(StackUpConfig.highestScaleDown * (float)maxScaleFactor), (int)1, (int)maxScaleFactor))) {
            for (int currScaleFactor = cfgMaxScaleFactor; currScaleFactor >= cfgMinScaleFactor; --currScaleFactor) {
                float scale = (float)currScaleFactor / (float)maxScaleFactor;
                float scaledStrWidth = scale * (float)strWidth;
                if (!(scaledStrWidth <= (float)maxWidth)) continue;
                return new AbbreviationResult(text, scale, true, abbreviated);
            }
        }
        float scale = (float)cfgMinScaleFactor / (float)maxScaleFactor;
        float scaledStrWidth = scale * (float)strWidth;
        return new AbbreviationResult(text, (float)cfgMinScaleFactor / (float)maxScaleFactor, scaledStrWidth <= (float)maxWidth, abbreviated);
    }

    private static String abbreviateInnerShort(int countI) {
        if (countI >= 1000 && countI <= 99999) {
            return countI / 1000 + "K";
        }
        if (countI >= 100000 && countI <= 999999) {
            return "." + countI / 100000 + "M";
        }
        if (countI >= 1000000 && countI <= 99999999) {
            return countI / 1000000 + "M";
        }
        if (countI >= 100000000 && countI <= 999999999) {
            return "." + countI / 100000000 + "B";
        }
        if (countI >= 1000000000) {
            return countI / 1000000000 + "B";
        }
        return Integer.toString(countI);
    }

    private static String abbreviateInnerLong(int countI) {
        if (countI >= 100000 && countI <= 999999) {
            return countI / 1000 + "K";
        }
        if (countI >= 1000000 && countI <= 9999999) {
            int a = countI / 10000;
            return a / 100 + "." + String.format("%02d", a % 100) + "M";
        }
        if (countI >= 10000000 && countI <= 99999999) {
            int a = countI / 100000;
            return a / 10 + "." + a % 10 + "M";
        }
        if (countI >= 100000000 && countI <= 999999999) {
            int a = countI / 1000000;
            return a + "M";
        }
        if (countI >= 1000000000) {
            int a = countI / 10000000;
            return a / 100 + "." + String.format("%02d", a % 100) + "B";
        }
        return Integer.toString(countI);
    }

    public static class AbbreviationResult {
        private String text;
        private final float scaleFactor;
        private final boolean fits;
        private final boolean abbreviated;

        public AbbreviationResult(String text, float scaleFactor, boolean fits, boolean abbreviated) {
            this.text = text;
            this.scaleFactor = scaleFactor;
            this.fits = fits;
            this.abbreviated = abbreviated;
        }

        public String getText() {
            return this.text;
        }

        public void setText(String text) {
            this.text = text;
        }

        public float getScaleFactor() {
            return this.scaleFactor;
        }

        public boolean isFits() {
            return this.fits;
        }

        public boolean isAbbreviated() {
            return this.abbreviated;
        }
    }
}

