/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.stackup.script;

import java.io.IOException;
import java.io.PushbackReader;
import pl.asie.stackup.script.ScriptHandler;
import pl.asie.stackup.script.TokenException;

public abstract class Token<T> {
    private boolean invert;

    protected ComparisonType getComparisonType(PushbackReader r) throws IOException, TokenException {
        ScriptHandler.cutWhitespace(r);
        int codePoint = r.read();
        if (codePoint == 43 || codePoint == 45 || codePoint == 42 || codePoint == 47 || codePoint == 37) {
            int oldCode = codePoint;
            codePoint = r.read();
            if (codePoint == 61) {
                if (oldCode == 43) {
                    return ComparisonType.ASSIGN_ADD;
                }
                if (oldCode == 45) {
                    return ComparisonType.ASSIGN_SUB;
                }
                if (oldCode == 42) {
                    return ComparisonType.ASSIGN_MUL;
                }
                if (oldCode == 47) {
                    return ComparisonType.ASSIGN_DIV;
                }
                if (oldCode == 37) {
                    return ComparisonType.REGEX_EQUAL;
                }
                throw new TokenException("Should not get here! " + oldCode);
            }
            throw new TokenException("Invalid comparison type!");
        }
        if (codePoint == 33) {
            codePoint = r.read();
            if (codePoint == 61) {
                return ComparisonType.NOT_EQUAL;
            }
            throw new TokenException("Invalid comparison type!");
        }
        if (codePoint == 126) {
            codePoint = r.read();
            if (codePoint == 61) {
                return ComparisonType.APPROXIMATELY_EQUAL;
            }
            throw new TokenException("Invalid comparison type!");
        }
        if (codePoint == 61) {
            codePoint = r.read();
            if (codePoint != 61) {
                r.unread(codePoint);
            }
            return ComparisonType.EQUAL;
        }
        if (codePoint == 60) {
            codePoint = r.read();
            if (codePoint == 61) {
                return ComparisonType.LESS_EQUAL;
            }
            r.unread(codePoint);
            return ComparisonType.LESS_THAN;
        }
        if (codePoint == 62) {
            codePoint = r.read();
            if (codePoint == 61) {
                return ComparisonType.GREATER_EQUAL;
            }
            r.unread(codePoint);
            return ComparisonType.GREATER_THAN;
        }
        throw new TokenException("Invalid comparison type!");
    }

    public boolean isInvert() {
        return this.invert;
    }

    public void setInvert(boolean invert) {
        this.invert = invert;
    }

    public abstract void parse(PushbackReader var1) throws IOException, TokenException;

    public abstract boolean apply(T var1);

    public static enum ComparisonType {
        EQUAL,
        APPROXIMATELY_EQUAL,
        REGEX_EQUAL,
        NOT_EQUAL,
        LESS_THAN,
        LESS_EQUAL,
        GREATER_THAN,
        GREATER_EQUAL,
        ASSIGN_ADD,
        ASSIGN_SUB,
        ASSIGN_MUL,
        ASSIGN_DIV;

    }
}

