/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.stackup.script;

import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import pl.asie.stackup.script.Token;
import pl.asie.stackup.script.TokenString;

public class TokenClass<T>
extends TokenString<T> {
    private final Function<T, List<Class>> classFunction;

    public TokenClass(Function<T, List<Class>> function, boolean ignoreCase) {
        super((T t) -> ((List)function.apply(t)).stream().map(Class::getName).collect(Collectors.toList()), ignoreCase);
        this.classFunction = function;
    }

    @Override
    protected boolean isInvalidComparisonType(Token.ComparisonType type) {
        return type != Token.ComparisonType.EQUAL && type != Token.ComparisonType.GREATER_EQUAL && type != Token.ComparisonType.GREATER_THAN && type != Token.ComparisonType.NOT_EQUAL;
    }

    @Override
    public boolean apply(T object) {
        List<Class> cReceivedL = this.classFunction.apply(object);
        try {
            Class<?> cSet = Class.forName(this.getString());
            block7: for (Class cReceived : cReceivedL) {
                switch (this.getComparisonType()) {
                    default: {
                        if (cSet != cReceived) continue block7;
                        return true;
                    }
                    case NOT_EQUAL: {
                        if (cSet != cReceived) continue block7;
                        return false;
                    }
                    case GREATER_THAN: {
                        if (cSet == cReceived) {
                            return false;
                        }
                        if (!cSet.isAssignableFrom(cReceived)) continue block7;
                        return true;
                    }
                    case GREATER_EQUAL: 
                }
                if (cSet != cReceived && !cSet.isAssignableFrom(cReceived)) continue;
                return true;
            }
            return false;
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
            return false;
        }
    }
}

