/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.stackup.script;

import java.io.IOException;
import java.io.PushbackReader;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.tuple.Pair;
import pl.asie.stackup.script.ScriptHandler;
import pl.asie.stackup.script.Token;

public class TokenProvider {
    public static final TokenProvider INSTANCE = new TokenProvider();
    private final Map<String, Supplier<Token>> tokenMap = new HashMap<String, Supplier<Token>>();

    public void addToken(String key, Supplier<Token> t) {
        this.tokenMap.put(key, t);
    }

    @Nonnull
    public Pair<String, Token> getToken(PushbackReader r) throws IOException {
        boolean invToken = false;
        StringBuilder key = new StringBuilder();
        ScriptHandler.cutWhitespace(r);
        int c = r.read();
        if (c == 33) {
            invToken = true;
        } else {
            r.unread(c);
        }
        while (Character.isAlphabetic(c = r.read())) {
            key.appendCodePoint(c);
        }
        r.unread(c);
        ScriptHandler.cutWhitespace(r);
        Supplier<Token> s = this.tokenMap.get(key.toString());
        if (s != null) {
            Token t = s.get();
            t.setInvert(invToken);
            return Pair.of((Object)key.toString(), (Object)t);
        }
        return Pair.of((Object)key.toString(), null);
    }
}

