/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.stackup.script;

import java.io.IOException;
import java.io.PushbackReader;
import java.util.List;
import java.util.function.Function;
import pl.asie.stackup.script.ScriptHandler;
import pl.asie.stackup.script.Token;
import pl.asie.stackup.script.TokenException;

public class TokenString<T>
extends Token<T> {
    protected final Function<T, List<String>> function;
    private final boolean ignoreCase;
    private Token.ComparisonType type;
    private String s;

    public TokenString(Function<T, List<String>> function, boolean ignoreCase) {
        this.function = function;
        this.ignoreCase = ignoreCase;
    }

    protected boolean isInvalidComparisonType(Token.ComparisonType type) {
        return type != Token.ComparisonType.EQUAL && type != Token.ComparisonType.APPROXIMATELY_EQUAL && type != Token.ComparisonType.NOT_EQUAL;
    }

    @Override
    public void parse(PushbackReader reader) throws IOException, TokenException {
        this.type = this.getComparisonType(reader);
        if (this.isInvalidComparisonType(this.type)) {
            throw new TokenException("Unsupported comparison type " + (Object)((Object)this.type) + "!");
        }
        StringBuilder builder = new StringBuilder();
        ScriptHandler.cutWhitespace(reader);
        int c = reader.read();
        if (c != 34) {
            throw new TokenException("Expected string beginning, " + c + " found!");
        }
        while ((c = reader.read()) != 34) {
            builder.appendCodePoint(c);
        }
        ScriptHandler.cutWhitespace(reader);
        this.s = builder.toString();
    }

    protected String getString() {
        return this.s;
    }

    protected Token.ComparisonType getComparisonType() {
        return this.type;
    }

    protected boolean compare(String sReceived, String sSet) {
        switch (this.type) {
            default: {
                return this.ignoreCase ? sReceived.equalsIgnoreCase(sSet) : sReceived.equals(sSet);
            }
            case APPROXIMATELY_EQUAL: 
        }
        boolean hasStartStar = sSet.startsWith("*");
        boolean hasEndStar = sSet.endsWith("*");
        if (hasStartStar && hasEndStar) {
            if (sSet.length() == 1) {
                return true;
            }
            return sReceived.toLowerCase().contains(sSet.substring(1, sSet.length() - 1).toLowerCase());
        }
        if (hasStartStar) {
            return sReceived.toLowerCase().endsWith(sSet.substring(1, sSet.length()).toLowerCase());
        }
        if (hasEndStar) {
            return sReceived.toLowerCase().startsWith(sSet.substring(0, sSet.length() - 1).toLowerCase());
        }
        return sReceived.equalsIgnoreCase(sSet);
    }

    @Override
    public boolean apply(T object) {
        for (String str : this.function.apply(object)) {
            if (!this.compare(str, this.s)) continue;
            return this.getComparisonType() != Token.ComparisonType.NOT_EQUAL;
        }
        return this.getComparisonType() == Token.ComparisonType.NOT_EQUAL;
    }
}

