/*
 * Decompiled with CFR 0.152.
 */
package simpleflax;

import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.world.gen.structure.MapGenStructureIO;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.IWorldGenerator;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.common.registry.VillagerRegistry;
import net.minecraftforge.oredict.OreDictionary;
import simpleflax.Config;
import simpleflax.compat.SimpleHarvestCompat;
import simpleflax.compat.TheOneProbeCompat;
import simpleflax.init.FlaxObjects;
import simpleflax.proxy.CommonProxy;
import simpleflax.village.ComponentFlaxField;
import simpleflax.village.FlaxVillageGen;
import simpleflax.world.WildFlaxGenerator;

@Mod(modid="simpleflax", name="Simple Flax", version="1.2.1", acceptedMinecraftVersions="[1.12.2]")
public class SimpleFlax {
    public static final String MODID = "simpleflax";
    public static final String NAME = "Simple Flax";
    public static final String VERSION = "1.2.1";
    @SidedProxy(clientSide="simpleflax.proxy.ClientProxy", serverSide="simpleflax.proxy.CommonProxy")
    public static CommonProxy proxy;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        Config.preInit(event);
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        OreDictionary.registerOre((String)"seedFlax", (Item)FlaxObjects.FLAX_SEEDS);
        OreDictionary.registerOre((String)"cropFlax", (Item)Items.field_151007_F);
        if (Config.seedWeight != 0) {
            MinecraftForge.addGrassSeed((ItemStack)new ItemStack(FlaxObjects.FLAX_SEEDS), (int)Config.seedWeight);
        }
        MapGenStructureIO.func_143031_a(ComponentFlaxField.class, (String)"ViFF");
        if (Config.villageGenerationWeight != 0) {
            VillagerRegistry.instance().registerVillageCreationHandler((VillagerRegistry.IVillageCreationHandler)new FlaxVillageGen());
        }
        GameRegistry.registerWorldGenerator((IWorldGenerator)new WildFlaxGenerator(Config.flaxPerChunk), (int)2);
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        if (Config.simpleHarvestCompat && Loader.isModLoaded((String)"harvest")) {
            SimpleHarvestCompat.init();
        }
        if (Loader.isModLoaded((String)"theoneprobe")) {
            TheOneProbeCompat.init();
        }
    }
}

