/*
 * Decompiled with CFR 0.152.
 */
package simpleflax.blocks;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockCrops;
import net.minecraft.block.IGrowable;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.EnumPlantType;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.IPlantable;
import simpleflax.init.FlaxObjects;

public class BlockFlax
extends BlockCrops
implements IGrowable {
    public static final PropertyInteger AGE = PropertyInteger.func_177719_a((String)"ayyge", (int)0, (int)5);
    public static final PropertyEnum<Half> HALF = PropertyEnum.func_177709_a((String)"half", Half.class);
    public static final int MAX_AGE = 5;
    private static final double[] HEIGHTS = new double[]{0.2, 0.3, 0.5, 0.8, 1.0};
    private static final AxisAlignedBB[] BOUNDING_BOXES = new AxisAlignedBB[]{new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, HEIGHTS[0], 1.0), new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, HEIGHTS[1], 1.0), new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, HEIGHTS[2], 1.0), new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, HEIGHTS[3], 1.0), new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, HEIGHTS[4], 1.0)};

    public BlockFlax() {
        this.func_180632_j(this.func_185528_e(0).func_177226_a(HALF, (Comparable)((Object)Half.LOWER)));
    }

    public boolean func_185525_y(IBlockState state) {
        return false;
    }

    public boolean isMaxAgeForReal(IBlockState state) {
        return (Integer)state.func_177229_b((IProperty)this.func_185524_e()) >= this.func_185526_g();
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return BOUNDING_BOXES[Math.min((Integer)state.func_177229_b((IProperty)AGE), 4)];
    }

    protected boolean func_185514_i(IBlockState state) {
        return super.func_185514_i(state) || state.func_177230_c() instanceof BlockFlax && state.func_177229_b(HALF) == Half.LOWER && ((Integer)state.func_177229_b((IProperty)AGE)).intValue() == this.func_185526_g();
    }

    protected PropertyInteger func_185524_e() {
        return AGE;
    }

    public int func_185526_g() {
        return 4;
    }

    public void func_180650_b(World world, BlockPos pos, IBlockState state, Random random) {
        this.func_176475_e(world, pos, state);
        if (!world.func_175697_a(pos, 1)) {
            return;
        }
        if (world.func_175671_l(pos.func_177984_a()) < 9) {
            return;
        }
        int age = (Integer)state.func_177229_b((IProperty)AGE);
        Half half = (Half)((Object)state.func_177229_b(HALF));
        if (age >= this.func_185526_g()) {
            return;
        }
        float growthChance = half == Half.UPPER ? BlockFlax.func_180672_a((Block)this, (World)world, (BlockPos)pos.func_177977_b()) : BlockFlax.func_180672_a((Block)this, (World)world, (BlockPos)pos);
        if (!ForgeHooks.onCropsGrowPre((World)world, (BlockPos)pos, (IBlockState)state, (random.nextInt((int)(25.0f / growthChance) + 1) == 0 ? 1 : 0) != 0)) {
            return;
        }
        world.func_175656_a(pos, this.func_185528_e(age + 1).func_177226_a(HALF, (Comparable)((Object)half)));
        if (half == Half.LOWER && age + 1 == this.func_185526_g()) {
            world.func_175656_a(pos.func_177984_a(), this.func_185528_e(0).func_177226_a(HALF, (Comparable)((Object)Half.UPPER)));
        } else if (half == Half.UPPER && age + 1 >= this.func_185526_g() && world.func_180495_p(pos.func_177977_b()).func_177230_c() == this) {
            world.func_175656_a(pos.func_177977_b(), this.func_185528_e(5).func_177226_a(HALF, (Comparable)((Object)Half.LOWER)));
        }
        ForgeHooks.onCropsGrowPost((World)world, (BlockPos)pos, (IBlockState)state, (IBlockState)world.func_180495_p(pos));
    }

    public boolean func_176473_a(World world, BlockPos pos, IBlockState state, boolean isClient) {
        if (state.func_177229_b(HALF) == Half.UPPER) {
            return !this.isMaxAgeForReal(state);
        }
        if (!this.isMaxAgeForReal(state)) {
            return true;
        }
        IBlockState upper = world.func_180495_p(pos.func_177984_a());
        return !this.isMaxAgeForReal(upper) && upper.func_177230_c() == this;
    }

    public void func_176487_g(World world, BlockPos pos, IBlockState state) {
        int age = (Integer)state.func_177229_b((IProperty)AGE);
        Half half = (Half)((Object)state.func_177229_b(HALF));
        if (half == Half.LOWER) {
            if (age < this.func_185526_g()) {
                int potentialAge = age + this.func_185529_b(world);
                int cappedAge = Math.min(potentialAge, this.func_185526_g());
                world.func_175656_a(pos, this.func_185528_e(cappedAge).func_177226_a(HALF, (Comparable)((Object)Half.LOWER)));
                if (potentialAge >= this.func_185526_g()) {
                    int additionalAge = Math.min(potentialAge - this.func_185526_g(), this.func_185526_g());
                    if (world.func_175623_d(pos.func_177984_a())) {
                        world.func_175656_a(pos.func_177984_a(), this.func_185528_e(additionalAge).func_177226_a(HALF, (Comparable)((Object)Half.UPPER)));
                    }
                    if (additionalAge >= this.func_185526_g()) {
                        world.func_175656_a(pos, this.func_185528_e(5).func_177226_a(HALF, (Comparable)((Object)Half.LOWER)));
                    }
                }
                return;
            }
            state = world.func_180495_p(pos = pos.func_177984_a());
            if (state.func_177230_c() != this) {
                return;
            }
            age = (Integer)state.func_177229_b((IProperty)AGE);
            half = Half.UPPER;
        }
        if (half == Half.UPPER) {
            age = Math.min(age + this.func_185529_b(world), this.func_185526_g());
            world.func_175656_a(pos, this.func_185528_e(age).func_177226_a(HALF, (Comparable)((Object)Half.UPPER)));
            if (age >= this.func_185526_g() && world.func_180495_p(pos.func_177977_b()).func_177230_c() == this) {
                world.func_175656_a(pos.func_177977_b(), this.func_185528_e(5).func_177226_a(HALF, (Comparable)((Object)Half.LOWER)));
            }
        }
    }

    public boolean func_180671_f(World world, BlockPos pos, IBlockState state) {
        if (!world.func_175678_i(pos) && world.func_175699_k(pos) < 8) {
            return false;
        }
        IBlockState below = world.func_180495_p(pos.func_177977_b());
        if (state.func_177229_b(HALF) == Half.LOWER) {
            return below.func_177230_c().canSustainPlant(below, (IBlockAccess)world, pos.func_177977_b(), EnumFacing.UP, (IPlantable)this);
        }
        return below.func_177230_c() == this && below.func_177229_b(HALF) == Half.LOWER && (Integer)below.func_177229_b((IProperty)AGE) >= this.func_185526_g();
    }

    protected Item func_149866_i() {
        return FlaxObjects.FLAX_SEEDS;
    }

    protected Item func_149865_P() {
        return Items.field_151007_F;
    }

    public void getDrops(NonNullList<ItemStack> drops, IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        Random random;
        if (state.func_177229_b(HALF) == Half.UPPER) {
            return;
        }
        int age = (Integer)state.func_177229_b((IProperty)AGE);
        Random random2 = random = world instanceof World ? ((World)world).field_73012_v : new Random();
        if (age >= 5) {
            int string = 1 + random.nextInt(3) + random.nextInt(1 + fortune);
            for (int i = 0; i < string; ++i) {
                drops.add((Object)new ItemStack(Items.field_151007_F));
            }
        }
        for (int attempt = 0; attempt < fortune + 3; ++attempt) {
            if (random.nextInt(8) > Math.min(age, 4)) continue;
            drops.add((Object)new ItemStack(FlaxObjects.FLAX_SEEDS));
        }
    }

    public void func_176208_a(World world, BlockPos pos, IBlockState state, EntityPlayer player) {
        if (state.func_177229_b(HALF) == Half.UPPER && world.func_180495_p(pos.func_177977_b()).func_177230_c() == this) {
            if (player.field_71075_bZ.field_75098_d) {
                world.func_175698_g(pos.func_177977_b());
            } else {
                world.func_175655_b(pos.func_177977_b(), true);
            }
        }
    }

    public Item func_180660_a(IBlockState state, Random random, int fortune) {
        return this.isMaxAgeForReal(state) ? this.func_149865_P() : this.func_149866_i();
    }

    public IBlockState func_176203_a(int meta) {
        boolean half = meta >= 8;
        int age = Math.min(meta & 7, 5);
        return this.func_185528_e(age).func_177226_a(HALF, (Comparable)((Object)(half ? Half.UPPER : Half.LOWER)));
    }

    public int func_176201_c(IBlockState state) {
        boolean half = state.func_177229_b(HALF) == Half.UPPER;
        int age = (Integer)state.func_177229_b((IProperty)AGE);
        return (half ? 8 : 0) | age & 7;
    }

    public EnumPlantType getPlantType(IBlockAccess world, BlockPos pos) {
        return EnumPlantType.Crop;
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{AGE, HALF});
    }

    public static enum Half implements IStringSerializable
    {
        LOWER,
        UPPER;


        public String toString() {
            return this.func_176610_l();
        }

        public String func_176610_l() {
            return this == UPPER ? "upper" : "lower";
        }
    }
}

