/*
 * Decompiled with CFR 0.152.
 */
package simpleflax.blocks;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockBush;
import net.minecraft.block.SoundType;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.EnumPlantType;
import net.minecraftforge.common.IPlantable;
import simpleflax.blocks.BlockFlax;
import simpleflax.init.FlaxObjects;

public class BlockFlaxWild
extends BlockBush {
    public static final PropertyEnum<BlockFlax.Half> HALF = PropertyEnum.func_177709_a((String)"half", BlockFlax.Half.class);
    private static final AxisAlignedBB FLAX_WILD_AABB = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.0, 1.0);

    public BlockFlaxWild() {
        this.func_149647_a(null);
        this.func_149711_c(0.0f);
        this.func_149672_a(SoundType.field_185850_c);
        this.func_149649_H();
        this.func_180632_j(this.func_176223_P().func_177226_a(HALF, (Comparable)((Object)BlockFlax.Half.LOWER)));
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return FLAX_WILD_AABB;
    }

    protected boolean func_185514_i(IBlockState state) {
        return super.func_185514_i(state) || state.func_177230_c() instanceof BlockFlaxWild && state.func_177229_b(HALF) == BlockFlax.Half.LOWER;
    }

    public boolean func_180671_f(World world, BlockPos pos, IBlockState state) {
        if (!world.func_175678_i(pos) && world.func_175699_k(pos) < 8) {
            return false;
        }
        IBlockState below = world.func_180495_p(pos.func_177977_b());
        if (state.func_177229_b(HALF) == BlockFlax.Half.LOWER) {
            return below.func_177230_c().canSustainPlant(below, (IBlockAccess)world, pos.func_177977_b(), EnumFacing.UP, (IPlantable)this);
        }
        return below.func_177230_c() == this && below.func_177229_b(HALF) == BlockFlax.Half.LOWER;
    }

    public void getDrops(NonNullList<ItemStack> drops, IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        if (state.func_177229_b(HALF) == BlockFlax.Half.UPPER) {
            return;
        }
        Random random = world instanceof World ? ((World)world).field_73012_v : new Random();
        int string = 1 + random.nextInt(3) + random.nextInt(1 + fortune);
        for (int i = 0; i < string; ++i) {
            drops.add((Object)new ItemStack(Items.field_151007_F));
        }
        for (int attempt = 0; attempt < fortune + 3; ++attempt) {
            if (!random.nextBoolean()) continue;
            drops.add((Object)new ItemStack(FlaxObjects.FLAX_SEEDS));
        }
    }

    public void func_176208_a(World world, BlockPos pos, IBlockState state, EntityPlayer player) {
        if (state.func_177229_b(HALF) == BlockFlax.Half.UPPER && world.func_180495_p(pos.func_177977_b()).func_177230_c() == this) {
            if (player.field_71075_bZ.field_75098_d) {
                world.func_175698_g(pos.func_177977_b());
            } else {
                world.func_175655_b(pos.func_177977_b(), true);
            }
        }
    }

    public IBlockState func_176203_a(int meta) {
        boolean half = meta >= 8;
        return this.func_176223_P().func_177226_a(HALF, (Comparable)((Object)(half ? BlockFlax.Half.UPPER : BlockFlax.Half.LOWER)));
    }

    public int func_176201_c(IBlockState state) {
        boolean half = state.func_177229_b(HALF) == BlockFlax.Half.UPPER;
        return half ? 8 : 0;
    }

    public EnumPlantType getPlantType(IBlockAccess world, BlockPos pos) {
        return EnumPlantType.Plains;
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{HALF});
    }
}

