/*
 * Decompiled with CFR 0.152.
 */
package simpleflax.compat;

import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import simpleflax.blocks.BlockFlax;
import simpleflax.init.FlaxObjects;
import tehnut.harvest.BlockStack;
import tehnut.harvest.Crop;
import tehnut.harvest.Harvest;
import tehnut.harvest.HarvestConfig;
import tehnut.harvest.IReplantHandler;

public class SimpleHarvestCompat {
    public static void init() {
        HarvestConfig config = Harvest.config;
        Crop top = new Crop(new BlockStack((Block)FlaxObjects.FLAX_BLOCK, 12), new BlockStack((Block)FlaxObjects.FLAX_BLOCK));
        config.getCrops().add(top);
        config.getCropMap().put(top.getInitialBlock(), top);
        Crop bottom = new Crop(new BlockStack((Block)FlaxObjects.FLAX_BLOCK, 5), new BlockStack((Block)FlaxObjects.FLAX_BLOCK));
        config.getCrops().add(bottom);
        config.getCropMap().put(bottom.getInitialBlock(), bottom);
        Harvest.CUSTOM_HANDLERS.put(FlaxObjects.FLAX_BLOCK, new FlaxReplantHandler());
    }

    public static class FlaxReplantHandler
    implements IReplantHandler {
        public void handlePlant(World world, BlockPos pos, IBlockState state, EntityPlayer player, @Nullable TileEntity tileEntity) {
            if (world.field_72995_K) {
                return;
            }
            int age = (Integer)state.func_177229_b((IProperty)BlockFlax.AGE);
            if (state.func_177229_b(BlockFlax.HALF) == BlockFlax.Half.UPPER) {
                state = world.func_180495_p(pos = pos.func_177977_b());
                if (state.func_177230_c() != FlaxObjects.FLAX_BLOCK || state.func_177229_b(BlockFlax.HALF) == BlockFlax.Half.UPPER) {
                    world.func_175698_g(pos.func_177984_a());
                    return;
                }
                age = (Integer)state.func_177229_b((IProperty)BlockFlax.AGE);
            }
            Random random = world.field_73012_v;
            if (age >= 5) {
                int string = 1 + random.nextInt(3);
                for (int i = 0; i < string; ++i) {
                    Block.func_180635_a((World)world, (BlockPos)pos, (ItemStack)new ItemStack(Items.field_151007_F));
                }
            }
            boolean firstSeed = true;
            for (int attempt = 0; attempt < 3; ++attempt) {
                if (random.nextInt(8) > Math.min(age, 4)) continue;
                if (firstSeed) {
                    firstSeed = false;
                    continue;
                }
                Block.func_180635_a((World)world, (BlockPos)pos, (ItemStack)new ItemStack(FlaxObjects.FLAX_SEEDS));
            }
            world.func_175698_g(pos.func_177984_a());
            world.func_175656_a(pos, FlaxObjects.FLAX_BLOCK.func_185528_e(0).func_177226_a(BlockFlax.HALF, (Comparable)((Object)BlockFlax.Half.LOWER)));
        }
    }
}

