/*
 * Decompiled with CFR 0.152.
 */
package com.wildex999.tickdynamic;

import com.google.common.eventbus.EventBus;
import com.google.common.eventbus.Subscribe;
import com.wildex999.tickdynamic.TimerTickTask;
import com.wildex999.tickdynamic.VersionChecker;
import com.wildex999.tickdynamic.commands.CommandHandler;
import com.wildex999.tickdynamic.timemanager.ITimed;
import com.wildex999.tickdynamic.timemanager.TimeManager;
import com.wildex999.tickdynamic.timemanager.TimedEntities;
import com.wildex999.tickdynamic.timemanager.TimedGroup;
import com.wildex999.tickdynamic.timemanager.TimedTileEntities;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.Semaphore;
import net.minecraft.command.ICommand;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.World;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.common.DummyModContainer;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.LoadController;
import net.minecraftforge.fml.common.ModMetadata;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;
import net.minecraftforge.fml.common.event.FMLServerStoppingEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;

public class TickDynamicMod
extends DummyModContainer {
    public static final String MODID = "tickDynamic";
    public static final String VERSION = "0.1.3";
    public static boolean debug = false;
    public static TickDynamicMod tickDynamic;
    public Map<String, ITimed> timedObjects;
    public TimeManager root;
    public boolean enabled;
    public MinecraftServer server;
    VersionChecker versionChecker;
    public boolean versionCheckDone;
    public Semaphore tpsMutex;
    public Timer tpsTimer;
    public int tickCounter;
    public double averageTPS;
    public int tpsAverageSeconds = 5;
    public LinkedList<Integer> tpsList;
    public Configuration config;
    public static final String configCategoryDefaultEntities = "general.entitydefaults";
    public static final String configCategoryDefaultTileEntities = "general.tileentitydefaults";
    public int defaultTickTime = 50;
    public int defaultEntitySlicesMax = 100;
    public int defaultEntityMinimumObjects = 100;
    public int defaultTileEntitySlicesMax = 100;
    public int defaultTileEntityMinimumObjects = 100;
    public int defaultWorldSlicesMax = 100;
    public int defaultAverageTicks = 20;

    public TickDynamicMod() {
        super(new ModMetadata());
        ModMetadata meta = this.getMetadata();
        meta.version = VERSION;
        meta.modId = MODID;
        meta.name = "Tick Dynamic";
        meta.description = "Dynamic control of the world tickrate to reduce apparent lag.";
        meta.authorList.add("Wildex999 ( wildex999@gmail.com )");
        meta.updateUrl = "http://mods.stjerncraft.com/tickdynamic";
        meta.url = "http://mods.stjerncraft.com/tickdynamic";
        tickDynamic = this;
        this.tpsMutex = new Semaphore(1);
        this.tpsTimer = new Timer();
        this.tpsList = new LinkedList();
        this.versionChecker = new VersionChecker();
    }

    public boolean registerBus(EventBus bus, LoadController controller) {
        bus.register((Object)this);
        return true;
    }

    @Subscribe
    public void preInit(FMLPreInitializationEvent event) {
        this.config = new Configuration(event.getSuggestedConfigurationFile());
        this.loadConfig(false);
    }

    public void loadConfig(boolean includeExisting) {
        this.config.load();
        this.config.getCategory("general");
        this.config.setCategoryComment("general", "WEBSITE: http://mods.stjerncraft.com/tickdynamic   <- Head here for the documentation, if you have problems or if you have questions.\n\nSlices are the way you control the time allottment to each world, and within each world, to Entities and TileEntities.\nEach tick the time for a tick(By default 50ms) will be distributed among all the worlds, according to how many slices they have.\nIf you have 3 worlds, each with 100 slices, then each world will get 100/300 = ~33% of the time.\nSo you can thus give the Overworld a maxSlices of 300, while giving the other two 100 each. This way the Overworld will get 60% of the time.\n\nOf the time given to the world, this is further distributed to TileEntities and Entities according to their slices, the same way.\nTileEntities and Entities are given a portion of the time first given to the world, so their slices are only relative to each other within that world.If any group has unused time, then that time will be distributed to the remaining groups.\nSo even if you give 1000 slices to TileEntities and 100 to Entities, as long as as TileEntities aren't using it's full time,\nEntities will be able to use more than 100 slices of time.\n\nSo the formula for slices to time percentage is: (group.maxSlices/allSiblings.maxSlices)*100\n\nNote: maxSlices = 0 has a special meaning. It means that the group's time usage is accounted for, but not limited.\nBasically it can take all the time it needs, even if it goes above the parent maxTime, pushing its siblings down to minimumObjects.");
        this.enabled = this.config.get("general", "enabled", true, "").getBoolean();
        debug = this.config.get("general", "debug", debug, "Debug output. Warning: Setting this to true will cause a lot of console spam.\nOnly do it if developer or someone else asks for the output!").getBoolean();
        this.defaultTickTime = this.config.get("worlds", "tickTime", this.defaultTickTime, "The time allotted to a tick in milliseconds. 20 Ticks per second means 50ms per tick.\nThis is the base time allotment it will use when balancing the time usage between worlds and objects.\nYou can set this to less than 50ms if you want to leave a bit of buffer time for other things, or don't want to use 100% cpu.").getInt();
        this.defaultWorldSlicesMax = this.config.get("general", "defaultWorldSlicesMax", this.defaultWorldSlicesMax, "The default maxSlices for a new automatically added world.").getInt();
        this.config.setCategoryComment(configCategoryDefaultEntities, "The default values for new Entity groups when automatically created for new worlds.");
        this.defaultEntitySlicesMax = this.config.get(configCategoryDefaultEntities, "slicesMax", this.defaultEntitySlicesMax, "The number of time slices given to the group.").getInt();
        this.defaultEntityMinimumObjects = this.config.get(configCategoryDefaultEntities, "minimumObjects", this.defaultEntityMinimumObjects, "The minimum number of Entities to update per tick, independent of time given.").getInt();
        this.config.setCategoryComment(configCategoryDefaultTileEntities, "The default values for new TileEntity groups when automatically created for new worlds.");
        this.defaultTileEntitySlicesMax = this.config.get(configCategoryDefaultTileEntities, "slicesMax", this.defaultTileEntitySlicesMax, "The number of time slices given to the group.").getInt();
        this.defaultTileEntityMinimumObjects = this.config.get(configCategoryDefaultTileEntities, "minimumObjects", this.defaultTileEntityMinimumObjects, "The minimum number of TileEntities to update per tick, independent of time given.").getInt();
        this.defaultAverageTicks = this.config.get("general", "averageTicks", this.defaultAverageTicks, "How many ticks of data to when averaging for time balancing.\nA higher number will make it take regular spikes into account, however will make it slower to addjust to changes.").getInt();
        if (includeExisting) {
            for (ITimed timed : this.timedObjects.values()) {
                timed.loadConfig(false);
            }
            if (this.root != null) {
                this.root.setTimeMax((long)this.defaultTickTime * 1000000L);
            }
        }
        this.config.save();
    }

    public void writeConfig(boolean saveFile) {
    }

    @Subscribe
    public void init(FMLInitializationEvent event) {
        FMLCommonHandler.instance().bus().register((Object)this);
        this.timedObjects = new HashMap<String, ITimed>();
        this.root = new TimeManager(this, null, "root", null);
        this.root.init();
        this.root.setTimeMax((long)this.defaultTickTime * 1000000L);
        TimedGroup otherTimed = new TimedGroup(this, null, "other", null);
        otherTimed.setSliceMax(0);
        this.root.addChild(otherTimed);
        TimedGroup externalTimed = new TimedGroup(this, null, "external", null);
        externalTimed.setSliceMax(0);
        this.root.addChild(externalTimed);
    }

    @Subscribe
    public void serverStart(FMLServerStartingEvent event) {
        event.registerServerCommand((ICommand)new CommandHandler(this));
        this.tpsTimer.schedule((TimerTask)new TimerTickTask(this), 1000L, 1000L);
        this.versionCheckDone = false;
        this.versionChecker.runVersionCheck();
        this.server = event.getServer();
    }

    @Subscribe
    public void serverStop(FMLServerStoppingEvent event) {
        this.tpsTimer.cancel();
        this.server = null;
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void tickEventStart(TickEvent.ServerTickEvent event) {
        if (event.phase == TickEvent.Phase.START) {
            VersionChecker.VersionData versionData;
            if (!this.versionCheckDone && (versionData = this.versionChecker.getVersionData()) != null) {
                this.versionCheckDone = true;
                if (versionData.checkOk) {
                    System.out.println("TickDynamic version check: Latest version = " + versionData.modVersion + " Download URL: http://" + versionData.updateUrl);
                } else {
                    System.out.println("TickDynamic version check: Error while checking latest version!");
                }
            }
            TimedGroup externalGroup = this.getGroup("external");
            externalGroup.endTimer();
            long overTime = externalGroup.getTimeUsed() - (long)this.defaultTickTime * 1000000L;
            long overTimeTick = (long)this.defaultTickTime * 1000000L - (this.root.getTimeUsed() - externalGroup.getTimeUsed());
            if (overTimeTick < 0L) {
                overTime += overTimeTick;
            }
            if (overTime < 0L) {
                externalGroup.setTimeUsed(0L);
            } else {
                externalGroup.setTimeUsed(overTime);
            }
            externalGroup.startTimer();
            this.root.newTick(true);
            this.getGroup("other").startTimer();
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void tickEventEnd(TickEvent.ServerTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            this.getGroup("other").endTimer();
            if (debug) {
                System.out.println("Tick time used: " + this.root.getTimeUsed() / 1000000L + "ms");
            }
            this.root.balanceTime();
            this.updateTPS();
        }
    }

    public void updateTPS() {
        try {
            this.tpsMutex.acquire();
            ++this.tickCounter;
            this.averageTPS = 0.0;
            Iterator i$ = this.tpsList.iterator();
            while (i$.hasNext()) {
                int tps = (Integer)i$.next();
                this.averageTPS += (double)tps;
            }
            this.averageTPS /= (double)this.tpsList.size();
            this.tpsMutex.release();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    public TimedGroup getGroup(String name) {
        return (TimedGroup)this.timedObjects.get(name);
    }

    public TimeManager getManager(String name) {
        return (TimeManager)this.timedObjects.get(name);
    }

    public TimeManager getWorldManager(World world) {
        String managerName;
        TimeManager worldManager;
        String remote = "";
        if (world.field_72995_K) {
            remote = "r";
        }
        if ((worldManager = this.getManager(managerName = remote + "tm_DIM" + world.field_73011_w.func_177502_q())) == null) {
            worldManager = new TimeManager(this, world, managerName, "worlds.dim" + world.field_73011_w.func_177502_q());
            worldManager.init();
            if (world.field_72995_K) {
                worldManager.setSliceMax(0);
            }
            this.config.setCategoryComment("worlds.dim" + world.field_73011_w.func_177502_q(), world.field_73011_w.func_80007_l());
            this.root.addChild(worldManager);
        }
        return worldManager;
    }

    public TimedGroup getWorldGroup(World world, TimedGroup.GroupType type, String name) {
        String groupName;
        TimedGroup group;
        String remote = "";
        if (world.field_72995_K) {
            remote = "r";
        }
        if ((group = this.getGroup(groupName = remote + "DIM" + world.field_73011_w.func_177502_q() + "_" + name)) == null) {
            if (type == TimedGroup.GroupType.TileEntity) {
                group = new TimedTileEntities(this, world, groupName, "worlds.dim" + world.field_73011_w.func_177502_q() + ".tileentity");
                group.init();
            } else if (type == TimedGroup.GroupType.Entity) {
                group = new TimedEntities(this, world, groupName, "worlds.dim" + world.field_73011_w.func_177502_q() + ".entity");
                group.init();
            }
            TimeManager worldManager = this.getWorldManager(world);
            worldManager.addChild(group);
        }
        return group;
    }

    public TimedTileEntities getWorldTileEntities(World world) {
        TimedGroup teGroup = this.getWorldGroup(world, TimedGroup.GroupType.TileEntity, "te");
        return (TimedTileEntities)teGroup;
    }

    public TimedEntities getWorldEntities(World world) {
        TimedGroup entityGroup = this.getWorldGroup(world, TimedGroup.GroupType.Entity, "e");
        return (TimedEntities)entityGroup;
    }
}

