/*
 * Decompiled with CFR 0.152.
 */
package com.wildex999.tickdynamic;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.util.concurrent.atomic.AtomicBoolean;

public class VersionChecker
implements Runnable {
    AtomicBoolean checkDone = new AtomicBoolean();
    VersionData data;

    public VersionChecker() {
        this.checkDone.set(false);
    }

    @Override
    public void run() {
        this.data = new VersionData();
        this.data.checkOk = false;
        String encoding = "UTF-8";
        String url = "http://mods.stjerncraft.com:8080";
        String query = "v=error";
        try {
            query = String.format("mv=%s&v=%s", URLEncoder.encode("1.7.10-10.13.2.1230", encoding), URLEncoder.encode("0.1.3", encoding));
            URLConnection connection = new URL(url + "/?" + query).openConnection();
            connection.setRequestProperty("Accept-Charset", encoding);
            connection.setRequestProperty("Host", "mods.stjerncraft.com");
            BufferedReader in = new BufferedReader(new InputStreamReader(connection.getInputStream()));
            String response = in.readLine();
            in.close();
            String[] args = response.split(",");
            if (args.length != 4) {
                this.data.checkOk = false;
                this.checkDone.set(true);
                return;
            }
            this.data.checkOk = args[0].equals("ok");
            this.data.mcVersion = args[1];
            this.data.modVersion = args[2];
            this.data.updateUrl = args[3];
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.checkDone.set(true);
    }

    public void runVersionCheck() {
        this.checkDone.set(false);
        new Thread(this).start();
    }

    public VersionData getVersionData() {
        if (!this.checkDone.get()) {
            return null;
        }
        return this.data;
    }

    public class VersionData {
        public boolean checkOk = false;
        public String mcVersion;
        public String modVersion;
        public String updateUrl;
    }
}

