/*
 * Decompiled with CFR 0.152.
 */
package com.wildex999.tickdynamic.commands;

import com.wildex999.tickdynamic.TickDynamicMod;
import com.wildex999.tickdynamic.commands.CommandEnabled;
import com.wildex999.tickdynamic.commands.CommandList;
import com.wildex999.tickdynamic.commands.CommandReload;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommand;
import net.minecraft.command.ICommandSender;
import net.minecraft.util.BlockPos;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IChatComponent;

public class CommandHandler
implements ICommand {
    private List<String> aliases;
    private Map<String, ICommand> subCommandHandlers;
    private String listSubCommands;
    private TickDynamicMod mod;

    public CommandHandler(TickDynamicMod mod) {
        SubCommands[] subs;
        this.mod = mod;
        this.aliases = new ArrayList<String>();
        this.aliases.add("tickdynamic");
        this.aliases.add("td");
        this.subCommandHandlers = new HashMap<String, ICommand>();
        this.subCommandHandlers.put("reload", new CommandReload(mod));
        this.subCommandHandlers.put("list", new CommandList(mod));
        this.subCommandHandlers.put("enabled", new CommandEnabled(mod));
        StringBuilder builderSubCommands = new StringBuilder();
        for (SubCommands command : subs = SubCommands.values()) {
            builderSubCommands.append((Object)command).append(", ");
        }
        builderSubCommands.delete(builderSubCommands.length() - 2, builderSubCommands.length());
        this.listSubCommands = builderSubCommands.toString();
    }

    public String func_71517_b() {
        return "tickdynamic";
    }

    public String func_71518_a(ICommandSender sender) {
        return "tickdynamic [" + this.listSubCommands + "]";
    }

    public List func_71514_a() {
        return this.aliases;
    }

    public void func_71515_b(ICommandSender sender, String[] args) throws CommandException {
        if (args.length == 0) {
            sender.func_145747_a((IChatComponent)new ChatComponentText("Usage: " + this.func_71518_a(sender)));
            return;
        }
        if (args[0].equals("tps")) {
            sender.func_145747_a((IChatComponent)new ChatComponentText("Average TPS: " + CommandHandler.getTPSFormatted(this.mod) + " TPS"));
            return;
        }
        if (args[0].equals("value")) {
            sender.func_145747_a((IChatComponent)new ChatComponentText("Command not yet implemented! Use the config file and reload command for now."));
            return;
        }
        if (args[0].equals("help")) {
            sender.func_145747_a((IChatComponent)new ChatComponentText("You can find the documentation over at http://mods.stjerncraft.com/tickdynamic for now."));
            return;
        }
        ICommand subHandler = this.subCommandHandlers.get(args[0]);
        if (subHandler == null) {
            sender.func_145747_a((IChatComponent)new ChatComponentText(EnumChatFormatting.RED + "No handler for the command " + EnumChatFormatting.ITALIC + args[0]));
            return;
        }
        subHandler.func_71515_b(sender, args);
    }

    public boolean func_71519_b(ICommandSender sender) {
        return sender.func_70003_b(1, this.func_71517_b());
    }

    public List func_180525_a(ICommandSender sender, String[] args, BlockPos pos) {
        if (args.length == 1) {
            SubCommands[] subCommands;
            LinkedList<String> listOut = new LinkedList<String>();
            String lastArg = args[args.length - 1];
            for (SubCommands command : subCommands = SubCommands.values()) {
                if (!command.toString().contains(lastArg)) continue;
                listOut.add(command.toString());
            }
            return listOut;
        }
        ICommand subHandler = this.subCommandHandlers.get(args[0]);
        if (subHandler == null) {
            return null;
        }
        return subHandler.func_180525_a(sender, args, pos);
    }

    public boolean func_82358_a(String[] args, int index) {
        return false;
    }

    public int compareTo(Object arg0) {
        return 0;
    }

    public static String getTPSFormatted(TickDynamicMod mod) {
        String color = mod.averageTPS >= 19.0 ? EnumChatFormatting.GREEN.toString() : (mod.averageTPS > 10.0 ? EnumChatFormatting.YELLOW.toString() : EnumChatFormatting.RED.toString());
        DecimalFormat tpsFormat = new DecimalFormat("#.00");
        String tpsOut = color + tpsFormat.format(mod.averageTPS) + EnumChatFormatting.RESET;
        return tpsOut;
    }

    public static enum SubCommands {
        tps,
        list,
        value,
        reload,
        enabled,
        help;

    }
}

