/*
 * Decompiled with CFR 0.152.
 */
package com.wildex999.tickdynamic.commands;

import com.wildex999.tickdynamic.TickDynamicMod;
import com.wildex999.tickdynamic.commands.CommandHandler;
import com.wildex999.tickdynamic.timemanager.ITimed;
import com.wildex999.tickdynamic.timemanager.TimeManager;
import com.wildex999.tickdynamic.timemanager.TimedEntities;
import com.wildex999.tickdynamic.timemanager.TimedGroup;
import com.wildex999.tickdynamic.timemanager.TimedTileEntities;
import java.text.DecimalFormat;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import net.minecraft.command.ICommand;
import net.minecraft.command.ICommandSender;
import net.minecraft.util.BlockPos;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IChatComponent;
import net.minecraft.world.WorldServer;
import org.apache.commons.lang3.StringUtils;

public class CommandList
implements ICommand {
    private TickDynamicMod mod;
    private String[] commands = new String[]{"dimnames", "time", "entitiesrun", "tps", "maxslices", "minimumentities"};
    String commandList;
    private String formatCode = "\u00a7";
    private String rc = " ";
    private int maxWorldNameWidth;
    private int maxWorldWidth;
    private int maxTileWidth;
    private int maxEntityWidth;
    private boolean gotWorldData;
    private int rowsPerPage = 6;
    private int currentPage;
    private int maxPages;

    public CommandList(TickDynamicMod mod) {
        this.mod = mod;
        this.gotWorldData = false;
        StringBuilder commandListBuilder = new StringBuilder();
        for (String command : this.commands) {
            commandListBuilder.append(command).append(", ");
        }
        commandListBuilder.delete(commandListBuilder.length() - 2, commandListBuilder.length());
        this.commandList = commandListBuilder.toString();
    }

    public String func_71517_b() {
        return "tickdynamic list";
    }

    public String func_71518_a(ICommandSender sender) {
        return "tickdynamic list [" + this.commandList + "] [page]";
    }

    public List func_71514_a() {
        return null;
    }

    public void func_71515_b(ICommandSender sender, String[] args) {
        LinkedList<ListData> listData;
        if (args.length == 1) {
            sender.func_145747_a((IChatComponent)new ChatComponentText("Usage: " + this.func_71518_a(sender)));
            return;
        }
        this.maxWorldNameWidth = 5;
        this.maxWorldWidth = 10;
        this.maxTileWidth = 12;
        this.maxEntityWidth = 8;
        this.gotWorldData = false;
        this.currentPage = 1;
        this.maxPages = 0;
        if (args.length == 3) {
            try {
                this.currentPage = Integer.parseInt(args[2]);
                if (this.currentPage <= 0) {
                    sender.func_145747_a((IChatComponent)new ChatComponentText(EnumChatFormatting.RED + "Page number must be 1 and up, got: " + args[2]));
                    this.currentPage = 1;
                }
            }
            catch (Exception e) {
                sender.func_145747_a((IChatComponent)new ChatComponentText(EnumChatFormatting.RED + "Expected a page number, got: " + args[2]));
                return;
            }
        }
        StringBuilder outputBuilder = new StringBuilder();
        if (args[1].equals("time")) {
            listData = this.getTimeData();
        } else if (args[1].equals("tps")) {
            listData = this.getTPSData();
        } else if (args[1].equals("entitiesrun")) {
            listData = this.getEntitiesRunData();
        } else if (args[1].equals("maxslices")) {
            listData = this.getMaxSlicesData();
        } else if (args[1].equals("minimumentities")) {
            listData = this.getMinimumObjectsData();
        } else {
            if (args[1].equals("dimnames")) {
                this.writeDimNames(outputBuilder);
                this.splitAndSend(sender, outputBuilder);
                return;
            }
            sender.func_145747_a((IChatComponent)new ChatComponentText(EnumChatFormatting.RED + "No handler for the subCommand " + EnumChatFormatting.ITALIC + args[1]));
            return;
        }
        if (!this.gotWorldData) {
            this.maxWorldWidth = 0;
        }
        this.maxPages = listData.size() > this.rowsPerPage ? (int)Math.ceil((float)listData.size() / (float)this.rowsPerPage) : 1;
        if (this.currentPage > this.maxPages) {
            this.currentPage = this.maxPages;
        }
        this.writeHeader(outputBuilder, args[1]);
        int pageOffset = (this.currentPage - 1) * this.rowsPerPage;
        int rowsLeft = this.rowsPerPage;
        ListIterator<ListData> it = listData.listIterator(pageOffset);
        while (it.hasNext()) {
            ListData data = (ListData)it.next();
            outputBuilder.append(EnumChatFormatting.GRAY + "| ").append(EnumChatFormatting.RESET + data.worldName).append(EnumChatFormatting.GRAY + StringUtils.repeat((String)this.rc, (int)(this.maxWorldNameWidth - this.getVisibleLength(data.worldName))));
            if (this.gotWorldData) {
                outputBuilder.append("|| ").append(EnumChatFormatting.RESET + data.worldData).append(EnumChatFormatting.GRAY + StringUtils.repeat((String)this.rc, (int)(this.maxWorldWidth - this.getVisibleLength(data.worldData))));
            }
            outputBuilder.append("|| ").append(EnumChatFormatting.RESET + data.tileData).append(EnumChatFormatting.GRAY + StringUtils.repeat((String)this.rc, (int)(this.maxTileWidth - this.getVisibleLength(data.tileData))));
            outputBuilder.append("|| ").append(EnumChatFormatting.RESET + data.entityData).append(EnumChatFormatting.GRAY + StringUtils.repeat((String)this.rc, (int)(this.maxEntityWidth - this.getVisibleLength(data.entityData))));
            outputBuilder.append(" |\n");
            if (--rowsLeft > 0) continue;
            break;
        }
        this.writeFooter(outputBuilder, args[1]);
        this.splitAndSend(sender, outputBuilder);
    }

    public void writeHeader(StringBuilder builder, String command) {
        if (command.equals("time")) {
            builder.append(EnumChatFormatting.GREEN + "Time used / Time given (In Milliseconds)\n");
        } else if (command.equals("tps")) {
            builder.append("Server Avg. TPS: ").append(CommandHandler.getTPSFormatted(this.mod)).append("\n");
        } else if (command.equals("entitiesrun")) {
            builder.append(EnumChatFormatting.GREEN + "Average number of Entities that update per tick\n");
        } else if (command.equals("maxslices")) {
            builder.append(EnumChatFormatting.GREEN + "Slices for the different worlds and groups from config\n");
        } else if (command.equals("minimumentities")) {
            builder.append(EnumChatFormatting.GREEN + "Minimum number of entities to run, from config\n");
        }
        builder.append(EnumChatFormatting.GRAY + "+" + StringUtils.repeat((String)"=", (int)((this.maxWorldNameWidth + this.maxWorldWidth + this.maxTileWidth + this.maxEntityWidth + 15) / 2)) + "+\n");
        builder.append(EnumChatFormatting.GRAY + "| ").append(EnumChatFormatting.RESET + "World").append(EnumChatFormatting.GRAY + StringUtils.repeat((String)this.rc, (int)(this.maxWorldNameWidth - 5)));
        if (this.gotWorldData) {
            builder.append(" || ").append(EnumChatFormatting.RESET + "World Data").append(EnumChatFormatting.GRAY + StringUtils.repeat((String)this.rc, (int)(this.maxWorldWidth - 10)));
        }
        builder.append(" || ").append(EnumChatFormatting.RESET + "TileEntities").append(EnumChatFormatting.GRAY + StringUtils.repeat((String)this.rc, (int)(this.maxTileWidth - 12))).append(" || ").append(EnumChatFormatting.RESET + "Entities").append(EnumChatFormatting.GRAY + StringUtils.repeat((String)this.rc, (int)(this.maxEntityWidth - 8))).append(" |\n");
    }

    public void writeFooter(StringBuilder builder, String command) {
        if (this.maxPages == 0) {
            builder.append(EnumChatFormatting.GRAY + "+" + StringUtils.repeat((String)"=", (int)((this.maxWorldNameWidth + this.maxWorldWidth + this.maxTileWidth + this.maxEntityWidth + 15) / 2)) + "+\n");
        } else {
            String pagesStr = EnumChatFormatting.GREEN + "Page " + this.currentPage + "/" + this.maxPages;
            int pagesLength = this.getVisibleLength(pagesStr);
            int otherLength = (this.maxWorldNameWidth + this.maxWorldWidth + this.maxTileWidth + this.maxEntityWidth + 15) / 2 - pagesLength;
            builder.append(EnumChatFormatting.GRAY + "+" + StringUtils.repeat((String)"=", (int)(otherLength / 2)));
            builder.append(pagesStr);
            builder.append(EnumChatFormatting.GRAY + StringUtils.repeat((String)"=", (int)(otherLength / 2)) + "+\n");
        }
    }

    public LinkedList<ListData> getTimeData() {
        ListData newData;
        LinkedList<ListData> dataList = new LinkedList<ListData>();
        TimeManager currentManager = this.mod.root;
        DecimalFormat decimalFormat = new DecimalFormat("#.00");
        this.gotWorldData = true;
        for (ITimed timed : currentManager.getChildren()) {
            if (!timed.isManager()) continue;
            newData = new ListData();
            TimeManager manager = (TimeManager)timed;
            if (manager.world != null) {
                if (manager.world.field_72995_K) continue;
                newData.worldName = "DIM" + manager.world.field_73011_w.func_177502_q();
            } else {
                newData.worldName = "NULL";
            }
            newData.worldData = decimalFormat.format((double)manager.getTimeUsedAverage() / 1000000.0) + " / " + decimalFormat.format((double)manager.getTimeMax() / 1000000.0);
            TimedTileEntities timedTile = this.mod.getWorldTileEntities(manager.world);
            newData.tileData = decimalFormat.format((double)timedTile.getTimeUsedAverage() / 1000000.0) + " / " + decimalFormat.format((double)timedTile.getTimeMax() / 1000000.0);
            TimedEntities timedEntity = this.mod.getWorldEntities(manager.world);
            newData.entityData = decimalFormat.format((double)timedEntity.getTimeUsedAverage() / 1000000.0) + " / " + decimalFormat.format((double)timedEntity.getTimeMax() / 1000000.0);
            int length = this.getVisibleLength(newData.worldName);
            if (this.maxWorldNameWidth < length) {
                this.maxWorldNameWidth = length;
            }
            if (this.maxWorldWidth < (length = this.getVisibleLength(newData.worldData))) {
                this.maxWorldWidth = length;
            }
            if (this.maxTileWidth < (length = this.getVisibleLength(newData.tileData))) {
                this.maxTileWidth = length;
            }
            if (this.maxEntityWidth < (length = this.getVisibleLength(newData.entityData))) {
                this.maxEntityWidth = length;
            }
            dataList.add(newData);
        }
        TimedGroup other = this.mod.getGroup("other");
        if (other != null) {
            newData = new ListData();
            newData.worldName = "(Other)";
            newData.tileData = "N/A";
            newData.entityData = "N/A";
            newData.worldData = decimalFormat.format((double)other.getTimeUsedAverage() / 1000000.0) + "ms";
            dataList.add(newData);
        }
        TimedGroup external = this.mod.getGroup("external");
        if (other != null) {
            newData = new ListData();
            newData.worldName = "(External)";
            newData.tileData = "N/A";
            newData.entityData = "N/A";
            newData.worldData = decimalFormat.format((double)external.getTimeUsedAverage() / 1000000.0) + "ms";
            dataList.add(newData);
        }
        return dataList;
    }

    public LinkedList<ListData> getTPSData() {
        LinkedList<ListData> dataList = new LinkedList<ListData>();
        TimeManager currentManager = this.mod.root;
        DecimalFormat decimalFormat = new DecimalFormat("#.00");
        for (ITimed timed : currentManager.getChildren()) {
            if (!timed.isManager()) continue;
            ListData newData = new ListData();
            TimeManager manager = (TimeManager)timed;
            if (manager.world != null) {
                if (manager.world.field_72995_K) continue;
                newData.worldName = "DIM" + manager.world.field_73011_w.func_177502_q();
            } else {
                newData.worldName = "NULL";
            }
            TimedTileEntities timedTile = this.mod.getWorldTileEntities(manager.world);
            String color = timedTile.averageTPS >= 19.0 ? EnumChatFormatting.GREEN.toString() : (timedTile.averageTPS > 10.0 ? EnumChatFormatting.YELLOW.toString() : EnumChatFormatting.RED.toString());
            newData.tileData = color + decimalFormat.format(timedTile.averageTPS) + EnumChatFormatting.RESET + "TPS";
            TimedEntities timedEntity = this.mod.getWorldEntities(manager.world);
            color = timedEntity.averageTPS >= 19.0 ? EnumChatFormatting.GREEN.toString() : (timedEntity.averageTPS > 10.0 ? EnumChatFormatting.YELLOW.toString() : EnumChatFormatting.RED.toString());
            newData.entityData = color + decimalFormat.format(timedEntity.averageTPS) + EnumChatFormatting.RESET + "TPS";
            int length = this.getVisibleLength(newData.worldName);
            if (this.maxWorldNameWidth < length) {
                this.maxWorldNameWidth = length;
            }
            if (this.maxTileWidth < (length = this.getVisibleLength(newData.tileData))) {
                this.maxTileWidth = length;
            }
            if (this.maxEntityWidth < (length = this.getVisibleLength(newData.entityData))) {
                this.maxEntityWidth = length;
            }
            dataList.add(newData);
        }
        return dataList;
    }

    public LinkedList<ListData> getEntitiesRunData() {
        LinkedList<ListData> dataList = new LinkedList<ListData>();
        TimeManager currentManager = this.mod.root;
        for (ITimed timed : currentManager.getChildren()) {
            if (!timed.isManager()) continue;
            ListData newData = new ListData();
            TimeManager manager = (TimeManager)timed;
            if (manager.world != null) {
                if (manager.world.field_72995_K) continue;
                newData.worldName = "DIM" + manager.world.field_73011_w.func_177502_q();
            } else {
                newData.worldName = "NULL";
            }
            TimedTileEntities timedTile = this.mod.getWorldTileEntities(manager.world);
            newData.tileData = "" + timedTile.getObjectsRunAverage();
            TimedEntities timedEntity = this.mod.getWorldEntities(manager.world);
            newData.entityData = "" + timedEntity.getObjectsRunAverage();
            int length = this.getVisibleLength(newData.worldName);
            if (this.maxWorldNameWidth < length) {
                this.maxWorldNameWidth = length;
            }
            if (this.maxTileWidth < (length = this.getVisibleLength(newData.tileData))) {
                this.maxTileWidth = length;
            }
            if (this.maxEntityWidth < (length = this.getVisibleLength(newData.entityData))) {
                this.maxEntityWidth = length;
            }
            dataList.add(newData);
        }
        return dataList;
    }

    public LinkedList<ListData> getMaxSlicesData() {
        LinkedList<ListData> dataList = new LinkedList<ListData>();
        TimeManager currentManager = this.mod.root;
        this.gotWorldData = true;
        for (ITimed timed : currentManager.getChildren()) {
            if (!timed.isManager()) continue;
            ListData newData = new ListData();
            TimeManager manager = (TimeManager)timed;
            if (manager.world != null) {
                if (manager.world.field_72995_K) continue;
                newData.worldName = "DIM" + manager.world.field_73011_w.func_177502_q();
            } else {
                newData.worldName = "NULL";
            }
            newData.worldData = "" + manager.getSliceMax();
            TimedTileEntities timedTile = this.mod.getWorldTileEntities(manager.world);
            newData.tileData = "" + timedTile.getSliceMax();
            TimedEntities timedEntity = this.mod.getWorldEntities(manager.world);
            newData.entityData = "" + timedEntity.getSliceMax();
            int length = this.getVisibleLength(newData.worldName);
            if (this.maxWorldNameWidth < length) {
                this.maxWorldNameWidth = length;
            }
            if (this.maxWorldWidth < (length = this.getVisibleLength(newData.worldData))) {
                this.maxWorldWidth = length;
            }
            if (this.maxTileWidth < (length = this.getVisibleLength(newData.tileData))) {
                this.maxTileWidth = length;
            }
            if (this.maxEntityWidth < (length = this.getVisibleLength(newData.entityData))) {
                this.maxEntityWidth = length;
            }
            dataList.add(newData);
        }
        return dataList;
    }

    public LinkedList<ListData> getMinimumObjectsData() {
        LinkedList<ListData> dataList = new LinkedList<ListData>();
        TimeManager currentManager = this.mod.root;
        for (ITimed timed : currentManager.getChildren()) {
            if (!timed.isManager()) continue;
            ListData newData = new ListData();
            TimeManager manager = (TimeManager)timed;
            if (manager.world != null) {
                if (manager.world.field_72995_K) continue;
                newData.worldName = "DIM" + manager.world.field_73011_w.func_177502_q();
            } else {
                newData.worldName = "NULL";
            }
            TimedTileEntities timedTile = this.mod.getWorldTileEntities(manager.world);
            newData.tileData = "" + timedTile.getMinimumObjects();
            TimedEntities timedEntity = this.mod.getWorldEntities(manager.world);
            newData.entityData = "" + timedEntity.getMinimumObjects();
            int length = this.getVisibleLength(newData.worldName);
            if (this.maxWorldNameWidth < length) {
                this.maxWorldNameWidth = length;
            }
            if (this.maxTileWidth < (length = this.getVisibleLength(newData.tileData))) {
                this.maxTileWidth = length;
            }
            if (this.maxEntityWidth < (length = this.getVisibleLength(newData.entityData))) {
                this.maxEntityWidth = length;
            }
            dataList.add(newData);
        }
        return dataList;
    }

    public void writeDimNames(StringBuilder builder) {
        if (this.mod.server == null) {
            builder.append(EnumChatFormatting.RED + "Error: Server is null!");
            return;
        }
        for (WorldServer world : this.mod.server.field_71305_c) {
            String name = "NULL";
            String dimId = "NULL";
            if (world == null || world.field_72995_K) continue;
            if (world.field_73011_w != null) {
                dimId = "" + world.field_73011_w.func_177502_q();
                name = world.field_73011_w.func_80007_l();
            }
            builder.append("DIM").append(dimId).append(": ").append(name).append("\n");
        }
    }

    public void splitAndSend(ICommandSender sender, StringBuilder outputBuilder) {
        String[] chatLines;
        for (String chatLine : chatLines = outputBuilder.toString().split("\n")) {
            sender.func_145747_a((IChatComponent)new ChatComponentText(chatLine));
        }
    }

    public int getVisibleLength(String str) {
        return str.length() - StringUtils.countMatches((CharSequence)str, (CharSequence)this.formatCode) * 2;
    }

    public boolean func_71519_b(ICommandSender sender) {
        return sender.func_70003_b(1, this.func_71517_b());
    }

    public List func_180525_a(ICommandSender sender, String[] args, BlockPos pos) {
        if (args.length == 2) {
            LinkedList<String> listOut = new LinkedList<String>();
            String lastArg = args[args.length - 1];
            for (String command : this.commands) {
                if (!command.contains(lastArg)) continue;
                listOut.add(command.toString());
            }
            return listOut;
        }
        return null;
    }

    public boolean func_82358_a(String[] p_82358_1_, int p_82358_2_) {
        return false;
    }

    public int compareTo(Object o) {
        return 0;
    }

    private class ListData {
        public String worldName;
        public String worldData;
        public String tileData;
        public String entityData;

        private ListData() {
        }
    }
}

