/*
 * Decompiled with CFR 0.152.
 */
package com.wildex999.tickdynamic.timemanager;

import com.wildex999.tickdynamic.TickDynamicMod;
import com.wildex999.tickdynamic.timemanager.ITimed;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.world.World;

public class TimeManager
implements ITimed {
    private int sliceMax;
    private long timeMax;
    private List<ITimed> children = new ArrayList<ITimed>();
    public final String name;
    public final TickDynamicMod mod;
    public final World world;
    public String configEntry;

    public TimeManager(TickDynamicMod mod, World world, String name, String configEntry) {
        mod.timedObjects.put(name, this);
        this.name = name;
        this.mod = mod;
        this.world = world;
        this.configEntry = configEntry;
    }

    @Override
    public void init() {
        this.setTimeMax(0L);
        int configSlices = 100;
        if (this.configEntry != null) {
            this.loadConfig(true);
        } else {
            this.setSliceMax(this.mod.defaultWorldSlicesMax);
        }
    }

    @Override
    public void loadConfig(boolean saveDefaults) {
        if (this.configEntry == null) {
            return;
        }
        this.setSliceMax(this.mod.config.get(this.configEntry, "slicesMax", this.mod.defaultWorldSlicesMax).getInt());
        if (saveDefaults) {
            this.mod.config.save();
        }
    }

    @Override
    public void writeConfig(boolean saveFile) {
        if (this.configEntry == null) {
            return;
        }
        this.mod.config.get(this.configEntry, "slicesMax", this.mod.defaultWorldSlicesMax).setValue(this.getSliceMax());
        if (saveFile) {
            this.mod.config.save();
        }
    }

    public void balanceTime() {
        if (!this.mod.enabled) {
            return;
        }
        if (TickDynamicMod.debug) {
            System.out.println(this.name + ": balanceTime for " + this.children.size() + " children, with " + this.timeMax + " to give.");
        }
        long leftover = 0L;
        int allSlices = 0;
        ArrayList<ITimed> childrenLeft = new ArrayList<ITimed>(this.children);
        leftover = this.timeMax;
        Iterator it = childrenLeft.iterator();
        while (it.hasNext()) {
            ITimed timed = (ITimed)it.next();
            timed.setTimeMax(0L);
            allSlices += timed.getSliceMax();
            if (timed.getSliceMax() != 0) continue;
            it.remove();
            if ((leftover -= timed.getTimeUsedAverage()) > 0L) continue;
            leftover = 1L;
        }
        int allSlicesPrev = allSlices;
        while (leftover > 0L && childrenLeft.size() > 0) {
            long before = leftover;
            if (TickDynamicMod.debug) {
                System.out.println("Leftover: " + leftover);
            }
            Iterator it2 = childrenLeft.iterator();
            while (it2.hasNext()) {
                long left;
                ITimed child = (ITimed)it2.next();
                long slice = 1L + (long)((double)before * ((double)child.getSliceMax() / (double)allSlices));
                long currentMax = child.getTimeMax() + slice;
                if (currentMax > 0L) {
                    leftover -= slice;
                }
                if ((double)(left = currentMax - child.getTimeUsedAverage()) > (double)currentMax / 100.0) {
                    long giveBack = (long)((double)left - (double)currentMax / 100.0);
                    leftover += giveBack;
                    currentMax -= giveBack;
                    it2.remove();
                    allSlices -= child.getSliceMax();
                }
                child.setTimeMax(currentMax + 1L);
            }
        }
        if (leftover > 0L) {
            for (ITimed child : this.children) {
                long slice = (long)((double)leftover * ((double)child.getSliceMax() / (double)allSlicesPrev));
                child.setTimeMax(child.getTimeMax() + slice);
            }
        }
        for (ITimed child : this.children) {
            if (!child.isManager()) continue;
            ((TimeManager)child).balanceTime();
        }
    }

    public void addChild(ITimed object) {
        this.children.add(object);
    }

    public void removeChild(ITimed object) {
        this.children.remove(object);
    }

    @Override
    public void setTimeMax(long newTimeMax) {
        if (TickDynamicMod.debug) {
            System.out.println(this.name + ": setTimeMax: " + newTimeMax);
        }
        this.timeMax = newTimeMax;
    }

    @Override
    public long getTimeMax() {
        return this.timeMax;
    }

    @Override
    public void setSliceMax(int newSliceMax) {
        this.sliceMax = newSliceMax;
    }

    @Override
    public int getSliceMax() {
        return this.sliceMax;
    }

    @Override
    public long getTimeUsed() {
        long output = 0L;
        for (ITimed child : this.children) {
            output += child.getTimeUsed();
        }
        return output;
    }

    @Override
    public long getTimeUsedAverage() {
        long output = 0L;
        for (ITimed child : this.children) {
            output += child.getTimeUsedAverage();
        }
        return output;
    }

    @Override
    public long getTimeUsedLast() {
        long output = 0L;
        for (ITimed child : this.children) {
            output += child.getTimeUsedLast();
        }
        return output;
    }

    @Override
    public void newTick(boolean clearChildren) {
        if (clearChildren) {
            Iterator<ITimed> it = this.children.iterator();
            while (it.hasNext()) {
                it.next().newTick(true);
            }
        }
    }

    public List<ITimed> getChildren() {
        return this.children;
    }

    @Override
    public boolean isManager() {
        return true;
    }
}

