/*
 * Decompiled with CFR 0.152.
 */
package com.wildex999.tickdynamic.timemanager;

import com.wildex999.tickdynamic.TickDynamicMod;
import com.wildex999.tickdynamic.timemanager.TimedGroup;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.world.World;

public class TimedTileEntities
extends TimedGroup {
    protected int currentObjectIndex;
    protected int remainingObjects;
    protected World world;
    protected double currentTPS;
    protected LinkedList<Double> listTPS;
    public double averageTPS;

    public TimedTileEntities(TickDynamicMod mod, World world, String name, String configEntry) {
        super(mod, world, name, configEntry);
    }

    @Override
    public void init() {
        this.timeUsed = 0L;
        this.objectsRun = 0;
        this.currentTPS = 0.0;
        this.listTPS = new LinkedList();
        this.setTimeMax(0L);
        if (this.configEntry != null) {
            this.loadConfig(true);
        } else {
            this.setSliceMax(this.mod.defaultTileEntitySlicesMax);
            this.setMinimumObjects(this.mod.defaultTileEntityMinimumObjects);
        }
    }

    @Override
    public void loadConfig(boolean saveDefaults) {
        if (this.configEntry == null) {
            return;
        }
        this.setSliceMax(this.mod.config.get(this.configEntry, "slicesMax", this.mod.defaultTileEntitySlicesMax).getInt());
        this.setMinimumObjects(this.mod.config.get(this.configEntry, "minimumObjects", this.mod.defaultTileEntityMinimumObjects).getInt());
        if (saveDefaults) {
            this.mod.config.save();
        }
    }

    @Override
    public void writeConfig(boolean saveFile) {
        if (this.configEntry == null) {
            return;
        }
        this.mod.config.get(this.configEntry, "slicesMax", this.mod.defaultTileEntitySlicesMax).setValue(this.getSliceMax());
        this.mod.config.get(this.configEntry, "minimumObjects", this.mod.defaultTileEntityMinimumObjects).setValue(this.getMinimumObjects());
        if (saveFile) {
            this.mod.config.save();
        }
    }

    public int getTargetObjectCount() {
        if (this.timeMax == 0L || !this.mod.enabled) {
            return Integer.MAX_VALUE;
        }
        double timePerObject = (int)Math.ceil((double)this.getTimeUsedAverage() / (double)this.getObjectsRunAverage());
        if (TickDynamicMod.debug) {
            System.out.println(this.name + ": getTargetObjectCount: timeUsed:" + this.getTimeUsedAverage() + " objectsRun: " + this.getObjectsRunAverage() + " timePerObject: " + timePerObject + " timeMax: " + this.timeMax);
        }
        return (int)Math.ceil((double)this.timeMax / timePerObject);
    }

    public int getCurrentObjectIndex() {
        return this.currentObjectIndex;
    }

    public int startUpdateObjects(World world) {
        this.world = world;
        if (world.field_72995_K || !this.mod.enabled) {
            return 0;
        }
        List loadedList = this.getWorldLoadedList(world);
        this.remainingObjects = this.getTargetObjectCount();
        if (this.remainingObjects < this.minimumObjects) {
            this.remainingObjects = this.minimumObjects;
        }
        if (this.remainingObjects > loadedList.size()) {
            this.remainingObjects = loadedList.size();
        }
        this.currentTPS = loadedList.size() > 0 ? (this.currentTPS += (double)this.remainingObjects / (double)loadedList.size() * 20.0) : (this.currentTPS += 20.0);
        if (this.currentObjectIndex >= loadedList.size()) {
            this.currentObjectIndex = 0;
        }
        if (TickDynamicMod.debug) {
            System.out.println("Start (" + this.name + "). CurrentObjectIndex: " + this.currentObjectIndex + " | " + "RemainingObjects: " + this.remainingObjects + " of " + loadedList.size());
        }
        return this.currentObjectIndex;
    }

    public Iterator updateObjects(Iterator iterator) {
        if (this.world.field_72995_K || !this.mod.enabled) {
            return iterator;
        }
        List loadedList = this.getWorldLoadedList(this.world);
        if (this.remainingObjects-- <= 0) {
            return loadedList.listIterator(loadedList.size());
        }
        ++this.currentObjectIndex;
        ++this.objectsRun;
        if (!iterator.hasNext()) {
            return loadedList.iterator();
        }
        return iterator;
    }

    @Override
    public void newTick(boolean clearChildren) {
        super.newTick(clearChildren);
        if (this.listTPS.size() >= this.mod.defaultAverageTicks) {
            this.listTPS.removeFirst();
        }
        this.listTPS.add(this.currentTPS);
        this.currentTPS = 0.0;
        this.averageTPS = 0.0;
        Iterator i$ = this.listTPS.iterator();
        while (i$.hasNext()) {
            double tps = (Double)i$.next();
            this.averageTPS += tps;
        }
        this.averageTPS /= (double)this.listTPS.size();
    }

    public List getWorldLoadedList(World world) {
        return world.field_147482_g;
    }
}

