/*
 * Decompiled with CFR 0.152.
 */
package com.wildex999.patcher;

import com.wildex999.patcher.ASMClassParser;
import com.wildex999.patcher.ExtraTextifier;
import com.wildex999.patcher.PatchParser;
import com.wildex999.tickdynamic.TickDynamicMod;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import net.minecraft.launchwrapper.IClassTransformer;
import org.apache.commons.io.IOUtils;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.util.Printer;
import org.objectweb.asm.util.TraceClassVisitor;

public class TransformerPatcher
implements IClassTransformer {
    public byte[] transform(String name, String transformedName, byte[] basicClass) {
        InputStream input = this.getClass().getResourceAsStream("/patches/" + transformedName.replace('.', '/') + ".patch");
        if (input != null) {
            try {
                TickDynamicMod.logInfo("Patching class: " + transformedName, new Object[0]);
                File out2 = new File("output_original.log");
                ClassNode cn = new ClassNode();
                StringWriter stringWriter = new StringWriter();
                TraceClassVisitor printer = new TraceClassVisitor(null, (Printer)new ExtraTextifier(), new PrintWriter(stringWriter));
                TraceClassVisitor printer2 = new TraceClassVisitor(null, (Printer)new ExtraTextifier(), new PrintWriter(out2));
                ClassReader cr = new ClassReader(basicClass);
                cr.accept((ClassVisitor)printer, 8);
                cr.accept((ClassVisitor)printer2, 8);
                String baseData = ((Object)stringWriter).toString();
                String patch = IOUtils.toString((InputStream)input);
                PatchParser patchParser = new PatchParser();
                patchParser.parsePatch(patch);
                String patchedData = patchParser.patch(baseData);
                if (patchedData == null) {
                    throw new RuntimeException("Failed to patch class: " + name + ".\nThis usually means there is either a mod conflict or patch version is wrong!");
                }
                File out3 = new File("output_patched.log");
                FileOutputStream output1 = new FileOutputStream(out3);
                DataOutputStream dos1 = new DataOutputStream(output1);
                dos1.write(patchedData.getBytes());
                dos1.close();
                ASMClassParser parser = new ASMClassParser();
                ClassWriter parsedClass = parser.parseClass(patchedData);
                basicClass = parsedClass.toByteArray();
                cr = new ClassReader(basicClass);
                File out = new File("output_source.log");
                printer = new TraceClassVisitor(null, (Printer)new ExtraTextifier(), new PrintWriter(out));
                cr.accept((ClassVisitor)printer, 8);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return basicClass;
    }
}

