/*
 * Decompiled with CFR 0.152.
 */
package com.wildex999.tickdynamic;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.wildex999.tickdynamic.TickDynamicConfig;
import com.wildex999.tickdynamic.TimerTickTask;
import com.wildex999.tickdynamic.WorldEventHandler;
import com.wildex999.tickdynamic.commands.CommandHandler;
import com.wildex999.tickdynamic.listinject.EntityGroup;
import com.wildex999.tickdynamic.listinject.EntityType;
import com.wildex999.tickdynamic.timemanager.ITimed;
import com.wildex999.tickdynamic.timemanager.TimeManager;
import com.wildex999.tickdynamic.timemanager.TimedEntities;
import com.wildex999.tickdynamic.timemanager.TimedGroup;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.Semaphore;
import net.minecraft.command.ICommand;
import net.minecraft.launchwrapper.Launch;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.event.ClickEvent;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.ConfigCategory;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.common.FMLLog;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.event.FMLFingerprintViolationEvent;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;
import net.minecraftforge.fml.common.event.FMLServerStoppingEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.common.network.FMLNetworkEvent;
import org.apache.logging.log4j.Level;

@Mod(modid="tickdynamic", name="Tick Dynamic", version="1.0.0", updateJSON="https://bitbucket.org/The_Fireplace/minecraft-mod-updates/raw/master/tickdynamic.json", acceptableRemoteVersions="*", certificateFingerprint="a93cd984e835238a9296066aff9aee15a202ec51", acceptedMinecraftVersions="[1.11.2]")
public class TickDynamicMod {
    public static final String MODID = "tickdynamic";
    public static final String MODNAME = "Tick Dynamic";
    public static final String VERSION = "1.0.0";
    public static boolean nologs = false;
    public static boolean debugGroups = false;
    public static boolean debugTimer = false;
    @Mod.Instance(value="tickdynamic")
    public static TickDynamicMod instance;
    public static boolean DEV_ENV;
    public static boolean VALID_JAR;
    public Map<String, ITimed> timedObjects;
    public Map<String, EntityGroup> entityGroups;
    public TimeManager root;
    public boolean enabled;
    public MinecraftServer server;
    public Semaphore tpsMutex;
    public Timer tpsTimer;
    public int tickCounter;
    public double averageTPS;
    public int tpsAverageSeconds = 5;
    public LinkedList<Integer> tpsList;
    public Configuration config;
    public boolean saveConfig;
    public int defaultTickTime = 50;
    public int defaultEntitySlicesMax = 100;
    public int defaultEntityMinimumObjects = 100;
    public float defaultEntityMinimumTPS = 0.0f;
    public float defaultEntityMinimumTime = 0.0f;
    public int defaultWorldSlicesMax = 100;
    public int defaultAverageTicks = 20;

    @Mod.EventHandler
    public static final void onInvalidCertificate(FMLFingerprintViolationEvent event) {
        if (!DEV_ENV) {
            VALID_JAR = false;
        }
    }

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        this.tpsMutex = new Semaphore(1);
        this.tpsList = Lists.newLinkedList();
        this.config = new Configuration(event.getSuggestedConfigurationFile());
    }

    public void loadConfig(boolean groups) {
        TickDynamicConfig.loadConfig(this, groups);
    }

    public void queueSaveConfig() {
        this.saveConfig = true;
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        MinecraftForge.EVENT_BUS.register((Object)this);
        this.timedObjects = Maps.newHashMap();
        this.entityGroups = Maps.newHashMap();
        this.loadConfig(true);
        this.root = new TimeManager(null, "root", null);
        this.root.init();
        this.root.setTimeMax((long)this.defaultTickTime * 1000000L);
        TimedGroup otherTimed = new TimedGroup(null, "other", "other");
        otherTimed.setSliceMax(0);
        this.root.addChild(otherTimed);
        TimedGroup externalTimed = new TimedGroup(null, "external", "external");
        externalTimed.setSliceMax(0);
        this.root.addChild(externalTimed);
        MinecraftForge.EVENT_BUS.register((Object)new WorldEventHandler());
    }

    @Mod.EventHandler
    public void serverStart(FMLServerStartingEvent event) {
        event.registerServerCommand((ICommand)new CommandHandler());
        this.tpsTimer = new Timer();
        this.tpsTimer.schedule((TimerTask)new TimerTickTask(), 1000L, 1000L);
        this.server = event.getServer();
    }

    @Mod.EventHandler
    public void serverStop(FMLServerStoppingEvent event) {
        this.tpsTimer.cancel();
        this.server = null;
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void tickEventStart(TickEvent.ServerTickEvent event) {
        if (event.phase == TickEvent.Phase.START) {
            TimedGroup externalGroup = this.getTimedGroup("external");
            externalGroup.endTimer();
            long msPerTick = 50L;
            long overTime = externalGroup.getTimeUsed() - msPerTick * 1000000L;
            long overTimeTick = msPerTick * 1000000L - (this.root.getTimeUsed() - externalGroup.getTimeUsed());
            if (overTimeTick < 0L) {
                overTime += overTimeTick;
            }
            if (overTime < 0L) {
                externalGroup.setTimeUsed(0L);
            } else {
                externalGroup.setTimeUsed(overTime);
            }
            externalGroup.startTimer();
            this.root.newTick(true);
            this.getTimedGroup("other").startTimer();
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void tickEventEnd(TickEvent.ServerTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            this.getTimedGroup("other").endTimer();
            this.root.endTick(true);
            if (debugTimer) {
                TickDynamicMod.logTrace("Tick time used: " + this.root.getTimeUsed() / 1000000L + "ms", new Object[0]);
            }
            this.root.balanceTime();
            this.updateTPS();
            if (this.saveConfig) {
                this.saveConfig = false;
                this.config.save();
            }
        }
    }

    @SubscribeEvent
    public void clientJoinWorld(FMLNetworkEvent.ClientConnectedToServerEvent event) {
        if (!VALID_JAR) {
            new Thread(() -> {
                while (FMLClientHandler.instance().getClientPlayerEntity() == null) {
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException e) {
                        TickDynamicMod.logWarn(e.getMessage(), new Object[0]);
                    }
                }
                TickDynamicMod.logDebug("Client with invalid jar is connecting: " + FMLClientHandler.instance().getClientPlayerEntity().getDisplayNameString(), new Object[0]);
                FMLClientHandler.instance().getClientPlayerEntity().func_145747_a(new TextComponentString("Warning: Your copy of Tick Dynamic does not appear to be valid. Please click here and download a fresh copy. If you did download it from that link, please report this error on the issue tracker.").func_150255_a(new Style().func_150241_a(new ClickEvent(ClickEvent.Action.OPEN_URL, "https://mods.curse.com/mc-mods/minecraft/269359-tick-dynamic#t1:other-downloads"))));
            }).start();
        }
    }

    public void updateTPS() {
        try {
            this.tpsMutex.acquire();
            ++this.tickCounter;
            this.averageTPS = 0.0;
            Iterator iterator = this.tpsList.iterator();
            while (iterator.hasNext()) {
                int tps = (Integer)iterator.next();
                this.averageTPS += (double)tps;
            }
            this.averageTPS /= (double)this.tpsList.size();
            this.tpsMutex.release();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    public TimedGroup getTimedGroup(String name) {
        return (TimedGroup)this.timedObjects.get(name);
    }

    public EntityGroup getEntityGroup(String name) {
        return this.entityGroups.get(name);
    }

    public TimeManager getTimeManager(String name) {
        return (TimeManager)this.timedObjects.get(name);
    }

    private String getEntityGroupName(World world, String name) {
        String remote = "";
        if (world.field_72995_K) {
            remote = "client_";
        }
        StringBuilder strBuilder = new StringBuilder().append("worlds.").append(remote).append("dim").append(world.field_73011_w.getDimension());
        if (name != null && name.length() > 0) {
            strBuilder.append(".").append(name);
        }
        return strBuilder.toString();
    }

    public TimeManager getWorldTimeManager(World world) {
        String managerName = this.getEntityGroupName(world, null);
        TimeManager worldManager = this.getTimeManager(managerName);
        if (worldManager == null) {
            worldManager = new TimeManager(world, managerName, managerName);
            worldManager.init();
            if (world.field_72995_K) {
                worldManager.setSliceMax(0);
            }
            this.config.setCategoryComment(managerName, world.field_73011_w.func_186058_p().func_186065_b());
            this.root.addChild(worldManager);
        }
        return worldManager;
    }

    public TimedEntities getWorldTimedGroup(World world, String name, boolean canCreate, boolean hasConfig) {
        String groupName = this.getEntityGroupName(world, name);
        TimedGroup group = this.getTimedGroup(groupName);
        if ((group == null || !(group instanceof TimedEntities)) && canCreate) {
            String baseGroupName = "groups." + name;
            TimedGroup baseGroup = this.getTimedGroup(baseGroupName);
            group = new TimedEntities(world, name, hasConfig ? groupName : null, baseGroup);
            group.init();
            TimeManager worldManager = this.getWorldTimeManager(world);
            worldManager.addChild(group);
        }
        return (TimedEntities)group;
    }

    public EntityGroup getWorldEntityGroup(World world, String name, EntityType groupType, boolean canCreate, boolean hasConfig) {
        String groupName = this.getEntityGroupName(world, name);
        EntityGroup group = this.getEntityGroup(groupName);
        if (group == null && canCreate) {
            String baseGroupName = "groups." + name;
            EntityGroup baseGroup = this.getEntityGroup(baseGroupName);
            group = new EntityGroup(world, this.getWorldTimedGroup(world, name, true, hasConfig), name, hasConfig ? groupName : null, groupType, baseGroup);
            this.entityGroups.put(groupName, group);
        }
        return group;
    }

    public List<EntityGroup> getWorldEntityGroups(World world) {
        ArrayList<EntityGroup> groups = new ArrayList<EntityGroup>();
        String remote = "";
        int offsetCount = 10;
        if (world.field_72995_K) {
            remote = "client_";
            offsetCount += 7;
        }
        String groupNamePrefix = String.valueOf(world.field_73011_w.getDimension()) + ".";
        for (Map.Entry<String, EntityGroup> entry : this.entityGroups.entrySet()) {
            String groupName = entry.getKey();
            if (!groupName.startsWith(groupNamePrefix, offsetCount)) continue;
            groups.add(entry.getValue());
        }
        return groups;
    }

    public void clearWorldEntityGroups(World world) {
        if (world == null) {
            return;
        }
        List<EntityGroup> groups = this.getWorldEntityGroups(world);
        int groupCount = 0;
        for (EntityGroup group : groups) {
            if (group.getWorld() == null) {
                TickDynamicMod.logDebug("Unable to unload group: " + group.getName() + ". World is null.", new Object[0]);
                continue;
            }
            String groupName = this.getEntityGroupName(group.getWorld(), group.getName());
            if (!this.entityGroups.remove(groupName, group)) {
                TickDynamicMod.logError("Failed to unload EntityGroup: " + groupName + " for world: " + world.field_73011_w.func_186058_p().func_186065_b(), new Object[0]);
                TickDynamicMod.logError("This might cause the world to remain in memory!", new Object[0]);
            } else {
                ++groupCount;
            }
            group.valid = false;
        }
        TickDynamicMod.logDebug("Unloaded " + groupCount + " EntityGroups while unloading world: " + world.field_73011_w.func_186058_p().func_186065_b(), new Object[0]);
    }

    public String getWorldPrefix(World world) {
        return "worlds.dim" + world.field_73011_w.getDimension();
    }

    public ConfigCategory getWorldConfigCategory(World world) {
        return this.config.getCategory(this.getWorldPrefix(world));
    }

    public EntityGroup getWorldTileEntities(World world) {
        return this.getWorldEntityGroup(world, "tileentity", EntityType.TileEntity, true, true);
    }

    public EntityGroup getWorldEntities(World world) {
        return this.getWorldEntityGroup(world, "entity", EntityType.Entity, true, true);
    }

    public static void logInfo(String log, Object ... params) {
        if (!nologs) {
            FMLLog.log((String)MODNAME, (Level)Level.INFO, (String)log, (Object[])params);
        }
    }

    public static void logDebug(String log, Object ... params) {
        if (!nologs) {
            FMLLog.log((String)MODNAME, (Level)Level.DEBUG, (String)log, (Object[])params);
        }
    }

    public static void logError(String log, Object ... params) {
        if (!nologs) {
            FMLLog.log((String)MODNAME, (Level)Level.ERROR, (String)log, (Object[])params);
        }
    }

    public static void logTrace(String log, Object ... params) {
        if (!nologs) {
            FMLLog.log((String)MODNAME, (Level)Level.TRACE, (String)log, (Object[])params);
        }
    }

    public static void logWarn(String log, Object ... params) {
        if (!nologs) {
            FMLLog.log((String)MODNAME, (Level)Level.WARN, (String)log, (Object[])params);
        }
    }

    static {
        DEV_ENV = (Boolean)Launch.blackboard.get("fml.deobfuscatedEnvironment");
        VALID_JAR = true;
    }
}

