/*
 * Decompiled with CFR 0.152.
 */
package com.wildex999.tickdynamic.listinject;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.wildex999.tickdynamic.TickDynamicMod;
import com.wildex999.tickdynamic.listinject.EntityObject;
import com.wildex999.tickdynamic.listinject.EntityType;
import com.wildex999.tickdynamic.listinject.ListManager;
import com.wildex999.tickdynamic.timemanager.TimedEntities;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.init.Blocks;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.RegistryNamespaced;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.ModContainer;
import net.minecraftforge.fml.common.registry.EntityRegistry;
import net.minecraftforge.fml.common.registry.FMLControlledNamespacedRegistry;
import net.minecraftforge.fml.common.registry.GameData;
import net.minecraftforge.fml.relauncher.ReflectionHelper;

public class EntityGroup {
    public TimedEntities timedGroup;
    public int currentGroupTime;
    public ArrayList<EntityObject> entities;
    private HashSet<Class> entityEntries;
    private boolean catchAll;
    private boolean gotOwnEntries;
    private String name;
    private String configEntry;
    public static final String config_useCorrectedTime = "useCorrectedTime";
    public static final String config_entityNames = "entityNames";
    public static final String config_classNames = "entityClassNames";
    public static final String config_modId = "modId";
    public static final String config_groupType = "groupType";
    public static final String config_enabled = "enabled";
    private World world;
    public ListManager<? extends EntityObject> list;
    public EntityGroup base;
    public boolean enabled;
    public boolean valid;
    private boolean useCorrectedTime;
    private EntityType groupType;
    private static Map<ResourceLocation, Class> tileResourceToClassMap = Maps.newHashMap();

    public EntityGroup(World world, TimedEntities timedGroup, String name, String configEntry, EntityType groupType, EntityGroup base) {
        if (timedGroup == null && base != null) {
            TickDynamicMod.logError("Assertion failed: Created EntityGroup with a null TimedGroup!", new Object[0]);
        }
        this.name = name != null ? name : "-";
        this.timedGroup = timedGroup;
        if (timedGroup != null) {
            timedGroup.setEntityGroup(this);
        }
        this.configEntry = configEntry;
        this.groupType = groupType;
        this.entities = new ArrayList();
        this.entityEntries = new HashSet();
        this.list = null;
        if (base != null) {
            this.gotOwnEntries = false;
            this.copy(base, true);
        } else {
            this.gotOwnEntries = true;
        }
        this.base = base;
        this.world = world;
        this.readConfig(true);
        this.valid = true;
    }

    public void readConfig(boolean save) {
        if (this.configEntry == null) {
            return;
        }
        if (this.gotOwnEntries) {
            this.entityEntries.clear();
        }
        this.gotOwnEntries = false;
        this.enabled = true;
        String comment = "Whether this group is enabled or not. If not, no Entity/TileEntity will be added to it.";
        this.enabled = this.base != null && !TickDynamicMod.instance.config.hasKey(this.configEntry, config_enabled) ? TickDynamicMod.instance.config.get(this.base.configEntry, config_enabled, this.enabled, comment).getBoolean() : TickDynamicMod.instance.config.get(this.configEntry, config_enabled, this.enabled, comment).getBoolean();
        comment = "Entity or TileEntity group";
        this.groupType = this.base != null && !TickDynamicMod.instance.config.hasKey(this.configEntry, config_groupType) ? EntityType.valueOf(TickDynamicMod.instance.config.get(this.base.configEntry, config_groupType, this.groupType.toString(), comment).getString()) : EntityType.valueOf(TickDynamicMod.instance.config.get(this.configEntry, config_groupType, this.groupType.toString(), comment).getString());
        this.useCorrectedTime = true;
        comment = "Set the World time to the correct time for the TPS of this group.";
        this.useCorrectedTime = this.base != null && !TickDynamicMod.instance.config.hasKey(this.configEntry, config_useCorrectedTime) ? TickDynamicMod.instance.config.get(this.base.configEntry, config_useCorrectedTime, this.useCorrectedTime, comment).getBoolean() : TickDynamicMod.instance.config.get(this.configEntry, config_useCorrectedTime, this.useCorrectedTime, comment).getBoolean();
        String[] entities = new String[]{""};
        comment = "List of Entity/Block names(Ex: Sheep / minecraft:furnace) who are to be included in this group.";
        if (this.base != null && !TickDynamicMod.instance.config.hasKey(this.configEntry, config_entityNames)) {
            entities = TickDynamicMod.instance.config.get(this.base.configEntry, config_entityNames, entities, comment).getStringList();
        } else {
            this.gotOwnEntries = true;
            entities = TickDynamicMod.instance.config.get(this.configEntry, config_entityNames, entities, comment).getStringList();
        }
        String[] entityClasses = new String[]{""};
        comment = "List of Entity/TileEntity class names(Ex: net.minecraft.tileentity.TileEntityDropper), for Entities that are to be included in this group.";
        if (this.base != null && !TickDynamicMod.instance.config.hasKey(this.configEntry, config_classNames)) {
            entityClasses = TickDynamicMod.instance.config.get(this.base.configEntry, config_classNames, entityClasses, comment).getStringList();
        } else {
            this.gotOwnEntries = true;
            entityClasses = TickDynamicMod.instance.config.get(this.configEntry, config_classNames, entityClasses, comment).getStringList();
        }
        this.gotOwnEntries = true;
        ArrayList mods = Lists.newArrayList();
        for (ModContainer mod : Loader.instance().getActiveModList()) {
            mods.add(mod.getModId());
        }
        Object[] excludemods = new String[]{""};
        comment = "List of mods to exclude. Will exclude every Entity or TileEntity from the specific mod, independent of 'entityClassNames' and 'entityNames'\n";
        if (this.base != null && !TickDynamicMod.instance.config.hasKey(this.configEntry, config_modId)) {
            excludemods = TickDynamicMod.instance.config.get(this.base.configEntry, config_modId, (String[])excludemods, comment).getStringList();
        } else {
            this.gotOwnEntries = true;
            excludemods = TickDynamicMod.instance.config.get(this.configEntry, config_modId, (String[])excludemods, comment).getStringList();
        }
        mods.removeAll(Sets.newHashSet((Object[])excludemods));
        if (this.gotOwnEntries) {
            if (this.groupType == EntityType.Entity) {
                this.loadEntitiesByName(entities);
                this.loadEntitiesByClassName(entityClasses);
                this.loadEntitiesByModNames(mods);
            } else {
                this.loadTilesByName(entities);
                this.loadTilesByClassName(entityClasses);
                this.loadTilesByModNames(mods);
            }
        } else if (this.base != null) {
            this.shareEntries(this.base);
        }
        if (save) {
            TickDynamicMod.instance.queueSaveConfig();
        }
    }

    public String getConfigEntry() {
        return this.configEntry;
    }

    public String getName() {
        return this.name;
    }

    public TimedEntities getTimedGroup() {
        return this.timedGroup;
    }

    public EntityType getGroupType() {
        return this.groupType;
    }

    public World getWorld() {
        return this.world;
    }

    public void copy(EntityGroup other, boolean copyEntries) {
        if (copyEntries) {
            this.entityEntries.addAll(other.entityEntries);
        }
    }

    public void addEntity(EntityObject entity) {
        entity.TD_Init(this);
        this.entities.add(entity);
    }

    public boolean removeEntity(EntityObject entity) {
        int index = this.entities.indexOf(entity);
        if (index != -1) {
            int currentEntityIndex = this.timedGroup.getCurrentObjectIndex();
            if (currentEntityIndex > index) {
                this.timedGroup.setCurrentObjectIndex(currentEntityIndex - 1);
            }
            this.entities.remove(index);
            entity.TD_Deinit();
            return true;
        }
        return false;
    }

    public void clearEntities() {
        for (EntityObject entity : this.entities) {
            entity.TD_Deinit();
        }
        this.entities.clear();
    }

    public int getEntityCount() {
        return this.entities.size();
    }

    public void shareEntries(EntityGroup other) {
        this.entityEntries = other.entityEntries;
    }

    public Set<Class> getEntityEntries() {
        return this.entityEntries;
    }

    private void loadTilesByName(String[] names) {
        if (names.length == 0) {
            return;
        }
        if (names.length == 1 && names[0].length() == 0) {
            return;
        }
        for (String name : names) {
            List<Class> tileClassList = this.loadTilesByName(name);
            if (tileClassList == null) {
                TickDynamicMod.logError("Failed to find Block with the name: " + name, new Object[0]);
                continue;
            }
            if (tileClassList.size() == 0) continue;
            for (Class tileClass : tileClassList) {
                if (this.entityEntries.contains(tileClass)) continue;
                TickDynamicMod.logDebug("Found TileEntity: " + tileClass, new Object[0]);
                this.entityEntries.add(tileClass);
            }
        }
    }

    private void loadEntitiesByName(String[] names) {
        if (names.length == 0) {
            return;
        }
        if (names.length == 1 && names[0].length() == 0) {
            return;
        }
        for (String name : names) {
            Class entityClass = this.loadEntityByName(name);
            if (entityClass == null) {
                TickDynamicMod.logWarn("Failed to find an Entity by the name: " + name, new Object[0]);
                continue;
            }
            if (this.entityEntries.contains(entityClass)) continue;
            TickDynamicMod.logDebug("Found Entity: " + entityClass, new Object[0]);
            this.entityEntries.add(entityClass);
        }
    }

    private List<Class> loadTilesByName(String name) {
        FMLControlledNamespacedRegistry blockRegistry = GameData.getBlockRegistry();
        Block block = (Block)blockRegistry.getObject(new ResourceLocation(name));
        if (block == Blocks.field_150350_a) {
            return null;
        }
        Class<?> prevTile = null;
        ArrayList<Class> tileClassList = new ArrayList<Class>(16);
        for (int b = 0; b < 16; b = (int)((byte)(b + 1))) {
            TileEntity currentTile;
            IBlockState state = block.func_176203_a(b);
            if (!block.hasTileEntity(state)) continue;
            try {
                currentTile = block.createTileEntity(this.world, state);
            }
            catch (Exception e) {
                TickDynamicMod.logDebug("Exception while loading Tile for " + name + ":\n" + e.getMessage(), new Object[0]);
                currentTile = null;
            }
            Class<?> cls = currentTile.getClass();
            if (currentTile != null && cls != prevTile && !tileClassList.contains(cls)) {
                tileClassList.add(currentTile.getClass());
            }
            prevTile = cls;
        }
        return tileClassList;
    }

    private Class loadEntityByName(String name) {
        return EntityList.getClass((ResourceLocation)new ResourceLocation(name));
    }

    private void loadTilesByClassName(String[] names) {
        if (names.length == 0) {
            return;
        }
        if (names.length == 1 && names[0].length() == 0) {
            return;
        }
        for (String name : names) {
            Class entityClass = this.loadByClassName(name);
            if (entityClass == null || !TileEntity.class.isAssignableFrom(entityClass)) {
                TickDynamicMod.logWarn("Could not find TileEntity class with the name: " + name, new Object[0]);
                continue;
            }
            if (this.entityEntries.contains(entityClass)) continue;
            TickDynamicMod.logDebug("Found TileEntity class: " + entityClass, new Object[0]);
            this.entityEntries.add(entityClass);
        }
    }

    private void loadEntitiesByClassName(String[] names) {
        if (names.length == 0) {
            return;
        }
        if (names.length == 1 && names[0].length() == 0) {
            return;
        }
        for (String name : names) {
            Class entityClass = this.loadByClassName(name);
            if (entityClass == null || !Entity.class.isAssignableFrom(entityClass)) {
                TickDynamicMod.logWarn("Could not find Entity class with the name: " + name + " Class: " + entityClass, new Object[0]);
                continue;
            }
            if (this.entityEntries.contains(entityClass)) continue;
            TickDynamicMod.logDebug("Found Entity class: " + entityClass, new Object[0]);
            this.entityEntries.add(entityClass);
        }
    }

    private Class loadByClassName(String name) {
        try {
            return Class.forName(name);
        }
        catch (Exception e) {
            return null;
        }
    }

    private void loadTilesByModNames(ArrayList<String> names) {
        if (names.isEmpty()) {
            return;
        }
        if (names.size() == 1 && names.get(0).length() == 0) {
            return;
        }
        for (String name : names) {
            List<Class> classList = this.loadTilesByModName(name);
            if (classList == null) continue;
            this.entityEntries.addAll(classList);
        }
    }

    private void loadEntitiesByModNames(ArrayList<String> names) {
        if (names.isEmpty()) {
            return;
        }
        if (names.size() == 1 && names.get(0).length() == 0) {
            return;
        }
        for (String name : names) {
            List<Class> classList = this.loadEntitiesByModName(name);
            this.entityEntries.addAll(classList);
        }
    }

    private List<Class> loadTilesByModName(String name) {
        TickDynamicMod.logTrace("Attempting to load tiles for " + name, new Object[0]);
        if (tileResourceToClassMap == null) {
            return null;
        }
        return this.loadClassesFromResourceLocation(tileResourceToClassMap, name);
    }

    private List<Class> loadEntitiesByModName(String name) {
        TickDynamicMod.logTrace("Attempting to load entities for " + name, new Object[0]);
        return this.loadClassesFromRegistryData((Map)ReflectionHelper.getPrivateValue(EntityRegistry.class, (Object)EntityRegistry.instance(), (String[])new String[]{"entityClassRegistrations"}), name);
    }

    private List<Class> loadClassesFromRegistryData(Map<Class<? extends Entity>, EntityRegistry.EntityRegistration> classToRegistrationMap, String name) {
        ArrayList<Class> classList = new ArrayList<Class>();
        Set<Map.Entry<Class<? extends Entity>, EntityRegistry.EntityRegistration>> entries = classToRegistrationMap.entrySet();
        for (Map.Entry<Class<? extends Entity>, EntityRegistry.EntityRegistration> entry : entries) {
            if (!entry.getValue().getRegistryName().func_110624_b().equalsIgnoreCase(name)) continue;
            Class<? extends Entity> value = entry.getKey();
            classList.add(value);
        }
        if (!classList.isEmpty()) {
            TickDynamicMod.logTrace(((Object)classList).toString(), new Object[0]);
        }
        return classList;
    }

    private List<Class> loadClassesFromResourceLocation(Map<ResourceLocation, Class> classToRegistrationMap, String name) {
        ArrayList<Class> classList = new ArrayList<Class>();
        Set<Map.Entry<ResourceLocation, Class>> entries = classToRegistrationMap.entrySet();
        for (Map.Entry<ResourceLocation, Class> entry : entries) {
            if (!entry.getKey().func_110624_b().equalsIgnoreCase(name)) continue;
            Class value = entry.getValue();
            classList.add(value);
        }
        if (!classList.isEmpty()) {
            TickDynamicMod.logTrace(((Object)classList).toString(), new Object[0]);
        }
        return classList;
    }

    static {
        try {
            RegistryNamespaced registry = (RegistryNamespaced)ReflectionHelper.getPrivateValue(TileEntity.class, null, (String[])new String[]{"REGISTRY", "field_190562_f"});
            for (ResourceLocation entry : registry.func_148742_b()) {
                tileResourceToClassMap.put(entry, (Class)registry.func_82594_a((Object)entry));
            }
        }
        catch (Exception e) {
            TickDynamicMod.logError(e.toString(), new Object[0]);
            TickDynamicMod.logError("Unable to load TileEntities from Mods, class variable(REGISTRY) lookup failed. The code might be obfuscated!", new Object[0]);
        }
    }
}

