/*
 * Decompiled with CFR 0.152.
 */
package com.wildex999.tickdynamic.listinject;

import com.wildex999.tickdynamic.listinject.CustomProfiler;
import com.wildex999.tickdynamic.listinject.EntityIteratorTimed;
import com.wildex999.tickdynamic.listinject.EntityObject;
import com.wildex999.tickdynamic.listinject.EntityType;
import com.wildex999.tickdynamic.listinject.ListManager;
import java.util.Iterator;
import net.minecraft.world.World;

public class ListManagerEntities
extends ListManager<EntityObject> {
    public boolean updateStarted;
    public Iterator<EntityObject> entityIterator;
    public EntityObject lastObj;
    public CustomProfiler profiler;

    public ListManagerEntities(World world) {
        super(world, EntityType.Entity);
        this.profiler = (CustomProfiler)world.field_72984_F;
    }

    @Override
    public int size() {
        if (this.profiler.stage == CustomProfiler.Stage.None || this.profiler.stage == CustomProfiler.Stage.InTick || this.profiler.stage == CustomProfiler.Stage.BeforeLoop || this.profiler.stage == CustomProfiler.Stage.InRemove) {
            return super.size();
        }
        if (!this.updateStarted) {
            this.updateStarted = true;
            this.entityIterator = new EntityIteratorTimed(this, this.getAge());
        }
        if (!this.entityIterator.hasNext()) {
            this.updateStarted = false;
            this.profiler.stage = CustomProfiler.Stage.InLoop;
            return 0;
        }
        return super.size();
    }

    @Override
    public EntityObject get(int index) {
        if (!this.updateStarted || this.profiler.stage == CustomProfiler.Stage.InTick) {
            return super.get(index);
        }
        this.lastObj = this.entityIterator.next();
        return this.lastObj;
    }

    @Override
    public EntityObject remove(int index) {
        if (!this.updateStarted || this.profiler.stage != CustomProfiler.Stage.InRemove) {
            return super.remove(index);
        }
        this.entityIterator.remove();
        return this.lastObj;
    }

    @Override
    public Iterator<EntityObject> iterator() {
        return super.iterator();
    }
}

