/*
 * Decompiled with CFR 0.152.
 */
package com.wildex999.tickdynamic.timemanager;

import com.wildex999.tickdynamic.TickDynamicMod;
import com.wildex999.tickdynamic.timemanager.ITimed;
import java.util.LinkedList;
import net.minecraft.world.World;

public class TimedGroup
implements ITimed {
    protected int sliceMax;
    protected long timeMax;
    protected long timeUsed;
    protected long timeUsedAverage;
    protected long prevTimeUsed;
    protected int objectsRun;
    protected int objectsRunAverage;
    protected int prevObjectsRun;
    protected long startTime;
    protected int averageTicks = 20;
    protected LinkedList<Long> listTimeUsed;
    protected LinkedList<Integer> listObjectsRun;
    public final String name;
    public final World world;
    public String configEntry;

    public TimedGroup(World world, String name, String configEntry) {
        if (configEntry != null) {
            TickDynamicMod.instance.timedObjects.put(configEntry, this);
        } else {
            TickDynamicMod.instance.timedObjects.put(name, this);
        }
        this.name = name;
        this.world = world;
        this.configEntry = configEntry;
        this.listTimeUsed = new LinkedList();
        this.listObjectsRun = new LinkedList();
    }

    @Override
    public void init() {
        this.timeUsed = 0L;
        this.objectsRun = 0;
        this.setTimeMax(0L);
        int configSlices = 100;
        if (this.configEntry != null) {
            configSlices = TickDynamicMod.instance.config.get(this.configEntry, "slicesMax", configSlices).getInt();
        }
        this.setSliceMax(configSlices);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void loadConfig(boolean saveDefaults) {
    }

    @Override
    public void writeConfig(boolean saveFile) {
    }

    public void startTimer() {
        this.startTime = System.nanoTime();
    }

    public void startTimer(long startTime) {
        this.startTime = startTime;
    }

    public long endTimer() {
        long time = System.nanoTime() - this.startTime;
        this.timeUsed += time;
        return time;
    }

    @Override
    public void setTimeMax(long newTimeMax) {
        if (TickDynamicMod.debugTimer) {
            TickDynamicMod.logTrace(this.name + ": setTimeMax: " + newTimeMax + " timeUsed: " + this.timeUsed, new Object[0]);
        }
        this.timeMax = newTimeMax;
    }

    @Override
    public long getTimeMax() {
        return this.timeMax;
    }

    @Override
    public void setSliceMax(int newSliceMax) {
        this.sliceMax = newSliceMax;
    }

    @Override
    public int getSliceMax() {
        return this.sliceMax;
    }

    @Override
    public long getTimeUsed() {
        return this.timeUsed;
    }

    @Override
    public long getTimeUsedAverage() {
        return this.timeUsedAverage;
    }

    @Override
    public long getTimeUsedLast() {
        return this.prevTimeUsed;
    }

    @Override
    public long getReservedTime() {
        return 0L;
    }

    public void setTimeUsed(long newTimeUsed) {
        this.timeUsed = newTimeUsed;
    }

    public int getObjectsRun() {
        return this.objectsRun;
    }

    public int getObjectsRunAverage() {
        return this.objectsRunAverage;
    }

    public int getObjectsRunLast() {
        return this.prevObjectsRun;
    }

    @Override
    public void newTick(boolean recursive) {
        this.prevTimeUsed = this.timeUsed;
        this.prevObjectsRun = this.objectsRun;
        this.timeUsed = 0L;
        this.objectsRun = 0;
        if (this.listTimeUsed.size() >= this.averageTicks) {
            this.listTimeUsed.removeFirst();
        }
        this.listTimeUsed.add(this.prevTimeUsed);
        this.timeUsedAverage = 0L;
        for (Long time : this.listTimeUsed) {
            this.timeUsedAverage += time.longValue();
        }
        this.timeUsedAverage /= (long)this.listTimeUsed.size();
        if (this.listObjectsRun.size() >= this.averageTicks) {
            this.listObjectsRun.removeFirst();
        }
        this.listObjectsRun.add(this.prevObjectsRun);
        this.objectsRunAverage = 0;
        for (Integer count : this.listObjectsRun) {
            this.objectsRunAverage += count.intValue();
        }
        this.objectsRunAverage /= this.listObjectsRun.size();
    }

    @Override
    public void endTick(boolean recursive) {
    }

    @Override
    public boolean isManager() {
        return false;
    }
}

