/*
 * Decompiled with CFR 0.152.
 */
package com.wildex999.patcher;

import com.google.common.primitives.Ints;
import com.wildex999.patcher.ValueType;
import com.wildex999.tickdynamic.TickDynamicMod;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Opcodes;
import org.objectweb.asm.Type;

public class ASMClassParser {
    protected List<Token> tokens;
    protected int currentToken;
    public int classVersion = 0;
    protected ClassWriter cl;

    public ClassWriter parseClass(String classData) throws Exception {
        this.cl = new ClassWriter(0);
        this.tokens = new ArrayList<Token>();
        int tokenStart = 0;
        int curPos = 0;
        boolean inQuote = false;
        boolean escaped = false;
        boolean inToken = false;
        int currentLine = 0;
        while (curPos < classData.length()) {
            char curChar = classData.charAt(curPos);
            ++curPos;
            if (inQuote) {
                if (curChar == '\\') {
                    escaped = !escaped;
                    continue;
                }
                if (curChar != '\"' || escaped) continue;
                inQuote = false;
                continue;
            }
            if (Character.isWhitespace(curChar)) {
                Token newToken;
                if (inToken) {
                    newToken = new Token();
                    newToken.str = classData.substring(tokenStart, curPos - 1);
                    newToken.line = currentLine;
                    this.tokens.add(newToken);
                    inToken = false;
                }
                if (curChar != '\n') continue;
                newToken = new Token();
                newToken.str = "\n";
                newToken.line = currentLine++;
                this.tokens.add(newToken);
                continue;
            }
            if (!inToken) {
                inToken = true;
                tokenStart = curPos - 1;
            }
            if (curChar != '\"') continue;
            inQuote = true;
        }
        if (inToken) {
            Token newToken = new Token();
            newToken.str = classData.substring(tokenStart);
            newToken.line = currentLine;
            this.tokens.add(newToken);
        }
        this.currentToken = -1;
        TickDynamicMod.logInfo("Tokens: " + this.tokens.size(), new Object[0]);
        this.parseClassVersion();
        this.skipLine();
        this.parseClassHeader();
        String signature = null;
        while (true) {
            String value;
            if ((value = this.nextToken()) == null) {
                throw new Exception(this.getCurrentTokenLine() + ": Reached end of class data without complete parse, Patch might be corrupt!");
            }
            if (value.equals("\n")) continue;
            if (value.startsWith("//")) {
                switch (value = this.nextToken()) {
                    case "signature": {
                        signature = this.nextToken();
                        break;
                    }
                    case "compiled": {
                        ++this.currentToken;
                        this.cl.visitSource(this.nextToken(), null);
                        break;
                    }
                    default: {
                        --this.currentToken;
                    }
                }
                this.skipLine();
                continue;
            }
            if (value.startsWith("@")) {
                int valuesOffset = value.indexOf("(");
                String valuesToken = "";
                if (valuesOffset != -1) {
                    valuesToken = value.substring(valuesOffset);
                    valuesToken = valuesToken + this.getLine();
                }
                String desc = value.substring(1, valuesOffset);
                AnnotationVisitor av = this.cl.visitAnnotation(desc, true);
                this.parseAnnotation(av, valuesToken);
                av.visitEnd();
            }
            if (value.equals("}")) break;
            --this.currentToken;
            int access = this.parseAccessFlags();
            value = this.nextToken();
            if (value == null) continue;
            if (value.equals("INNERCLASS")) {
                this.parseInnerClass(access);
            } else if (value.contains("(")) {
                this.parseMethod(access, signature);
            } else {
                this.parseField(access, signature);
            }
            signature = null;
        }
        this.cl.visitEnd();
        return this.cl;
    }

    protected String nextToken() {
        if (this.currentToken >= this.tokens.size() - 1) {
            return null;
        }
        return this.tokens.get((int)(++this.currentToken)).str;
    }

    protected String getCurrentToken() {
        if (this.currentToken < 0 || this.currentToken >= this.tokens.size()) {
            return null;
        }
        return this.tokens.get((int)this.currentToken).str;
    }

    protected String previousToken() {
        if (this.currentToken <= 0 || this.currentToken >= this.tokens.size() + 1) {
            return null;
        }
        return this.tokens.get((int)(--this.currentToken)).str;
    }

    protected int getCurrentTokenLine() {
        if (this.currentToken < 0 || this.currentToken >= this.tokens.size()) {
            return -1;
        }
        return this.tokens.get((int)this.currentToken).line;
    }

    protected void skipLine() {
        String value;
        while ((value = this.nextToken()) != null && !value.equals("\n")) {
        }
    }

    protected String getLine() {
        String value;
        StringBuilder builder = new StringBuilder();
        do {
            value = this.nextToken();
            builder.append(value);
        } while (value != null && !value.equals("\n"));
        return builder.toString();
    }

    protected void parseClassVersion() throws Exception {
        String noMatchError = "Found no class version at beginning of class!";
        if (!this.nextToken().equals("//")) {
            throw new Exception(noMatchError);
        }
        if (!this.nextToken().equals("class")) {
            throw new Exception(noMatchError);
        }
        if (!this.nextToken().equals("version")) {
            throw new Exception(noMatchError);
        }
        String value = this.nextToken();
        int version = (int)Float.parseFloat(value);
        switch (version) {
            case 50: {
                this.classVersion = 50;
                TickDynamicMod.logInfo("V1_6", new Object[0]);
                break;
            }
            case 51: {
                this.classVersion = 51;
                break;
            }
            case 52: {
                this.classVersion = 52;
                break;
            }
            default: {
                throw new Exception("Unsuported class version: " + version);
            }
        }
        this.nextToken();
        value = this.nextToken();
        if (!value.equals("\n")) {
            throw new Exception("Error while parsing class version, expected \n, got: " + value);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    protected void parseClassHeader() throws Exception {
        int access = this.parseAccessFlags();
        if (access == 0) {
            throw new Exception("Error: Got zero access modifier while parsing class header!");
        }
        if (!this.nextToken().equals("class")) {
            throw new Exception("Error: Did not find class identifier while parsing class header!");
        }
        String className = this.nextToken();
        String superClassName = null;
        ArrayList<String> impl = new ArrayList<String>();
        boolean implement = false;
        block10: while (true) {
            String value = this.nextToken();
            if (implement) {
                if (value.equals("{")) break;
                impl.add(value);
                continue;
            }
            switch (value) {
                case "implements": {
                    implement = true;
                    break;
                }
                case "extends": {
                    superClassName = this.nextToken();
                    break;
                }
                case "{": {
                    break block10;
                }
            }
        }
        access += 32;
        if (superClassName == null) {
            superClassName = "java/lang/Object";
        }
        TickDynamicMod.logInfo("Writing class header:\nAccess: " + Integer.toHexString(access).toUpperCase() + "\nName: " + className + "\nSuper class: " + superClassName + "\nImplements: " + impl, new Object[0]);
        String[] implNames = null;
        if (impl.size() != 0) {
            implNames = impl.toArray(new String[impl.size()]);
        }
        this.cl.visit(this.classVersion, access, className, null, superClassName, implNames);
    }

    protected int parseAccessFlags() throws Exception {
        int access = 0;
        boolean gotTransient = false;
        boolean gotVarargs = false;
        block40: while (true) {
            String current;
            if ((current = this.nextToken()) == null) {
                return access;
            }
            switch (current) {
                case "public": {
                    ++access;
                    continue block40;
                }
                case "private": {
                    access += 2;
                    continue block40;
                }
                case "protected": {
                    access += 4;
                    continue block40;
                }
                case "static": {
                    access += 8;
                    continue block40;
                }
                case "final": {
                    access += 16;
                    continue block40;
                }
                case "synchronized": {
                    access += 32;
                    continue block40;
                }
                case "volatile": {
                    access += 64;
                    continue block40;
                }
                case "bridge": {
                    access += 64;
                    continue block40;
                }
                case "varargs": {
                    if (gotTransient) continue block40;
                    access += 128;
                    gotVarargs = true;
                    continue block40;
                }
                case "transient": {
                    if (gotVarargs) continue block40;
                    access += 128;
                    gotTransient = true;
                    continue block40;
                }
                case "native": {
                    access += 256;
                    continue block40;
                }
                case "interface": {
                    access += 512;
                    continue block40;
                }
                case "abstract": {
                    access += 1024;
                    continue block40;
                }
                case "strict": {
                    access += 2048;
                    continue block40;
                }
                case "synthetic": {
                    access += 4096;
                    continue block40;
                }
                case "annotation": {
                    access += 8192;
                    continue block40;
                }
                case "enum": {
                    access += 16384;
                    continue block40;
                }
                case "mandated": {
                    access += 32768;
                    continue block40;
                }
            }
            break;
        }
        --this.currentToken;
        return access;
    }

    protected void parseInnerClass(int access) throws Exception {
        String name = this.nextToken();
        String outerName = this.nextToken();
        String innerName = this.nextToken();
        if (outerName.equals("null")) {
            outerName = null;
        }
        if (innerName.equals("null")) {
            innerName = null;
        }
        this.cl.visitInnerClass(name, outerName, innerName, access);
    }

    protected void parseField(int access, String signature) throws Exception {
        String value;
        String desc = value = this.getCurrentToken();
        String name = this.nextToken();
        Object fieldValue = null;
        if (this.nextToken().equals("=")) {
            fieldValue = this.parseValue((String)this.nextToken()).value;
        } else {
            --this.currentToken;
        }
        FieldVisitor field = this.cl.visitField(access, name, desc, signature, fieldValue);
        if (!this.nextToken().equals("\n")) {
            throw new Exception(this.getCurrentTokenLine() + ": Error: Expected newline while parsing field: " + name + "! Got: " + this.getCurrentToken());
        }
        while ((value = this.nextToken()).startsWith("@")) {
            int valuesOffset = value.indexOf("(");
            String valuesToken = "";
            if (valuesOffset != -1) {
                valuesToken = value.substring(valuesOffset);
                valuesToken = valuesToken + this.getLine();
            }
            desc = value.substring(1, valuesOffset);
            AnnotationVisitor av = field.visitAnnotation(desc, true);
            this.parseAnnotation(av, valuesToken);
            av.visitEnd();
        }
        --this.currentToken;
        field.visitEnd();
    }

    protected void parseAnnotation(AnnotationVisitor anno, String token) throws Exception {
        char tokenChar;
        if (token == null || token.length() == 0 || token.length() == 2) {
            return;
        }
        if (token.contains("\\\"")) {
            throw new Exception(this.getCurrentTokenLine() + ": Parser currently does not handle escaped quotes in annotations! Bug me about this -_-(Unless you are on an old version");
        }
        int offset = 1;
        while (true) {
            String value;
            int index = token.indexOf("=", offset);
            String valueName = token.substring(offset, index);
            offset = index + 1;
            tokenChar = token.charAt(offset);
            if (tokenChar == '\"') {
                index = token.indexOf(34, offset + 1);
                value = token.substring(offset + 1, index);
                anno.visit(valueName, (Object)value);
                offset = index + 1;
            } else {
                if (tokenChar == '{') {
                    throw new Exception(this.getCurrentTokenLine() + ": Parser currently does not handle arrays in annotations!");
                }
                if (tokenChar == 'L') {
                    index = token.indexOf(";", offset);
                    value = token.substring(offset, index + 1);
                    offset = index + 1;
                    if (token.charAt(offset) == '.') {
                        int index2;
                        int index1 = token.indexOf(",", offset);
                        index = index1 < (index2 = token.indexOf(")", offset)) && index1 != -1 ? index1 : index2;
                        String entryName = token.substring(offset + 1, index);
                        anno.visitEnum(valueName, value, entryName);
                        offset = index;
                    } else {
                        anno.visit(valueName, (Object)Type.getType((String)value));
                    }
                } else {
                    index = token.indexOf(",", offset);
                    value = index == -1 ? token.substring(offset, token.length() - 1) : token.substring(offset, index);
                    ValueType parsedValue = this.parseValue(value);
                    anno.visit(valueName, parsedValue.value);
                    offset = index;
                }
            }
            tokenChar = token.charAt(offset);
            if (tokenChar != ',') break;
            ++offset;
        }
        if (tokenChar != ')') {
            throw new Exception(this.getCurrentTokenLine() + ": Error while parsing Annotation: Expected ',' or ')', got: " + tokenChar);
        }
    }

    protected ValueType parseValue(String token) throws Exception {
        ValueType val = new ValueType();
        if (token.startsWith("\"")) {
            val.type = ValueType.Type.TString;
            val.value = token.substring(1, token.length() - 1);
            return val;
        }
        if (token.equals("true")) {
            val.type = ValueType.Type.TBoolean;
            val.value = Boolean.TRUE;
            return val;
        }
        if (token.equals("false")) {
            val.type = ValueType.Type.TBoolean;
            val.value = Boolean.FALSE;
            return val;
        }
        if (token.startsWith("L")) {
            String objType = token.substring(0, token.indexOf("."));
            val.type = ValueType.Type.TType;
            val.value = Type.getType((String)objType);
            return val;
        }
        int index = token.indexOf("F");
        if (index != -1) {
            val.type = ValueType.Type.TFloat;
            val.value = new Float(token.substring(0, index));
            return val;
        }
        index = token.indexOf("D");
        if (index != -1) {
            val.type = ValueType.Type.TDouble;
            val.value = new Double(token.substring(0, index));
            return val;
        }
        index = token.indexOf("L");
        if (index != -1) {
            val.type = ValueType.Type.TLong;
            val.value = new Long(token.substring(0, index));
            return val;
        }
        if (token.startsWith("(char)")) {
            val.type = ValueType.Type.TChar;
            val.value = new Character(token.charAt(6));
            return val;
        }
        if (token.startsWith("(short)")) {
            val.type = ValueType.Type.TShort;
            val.value = new Short(token.substring(7));
            return val;
        }
        if (token.startsWith("(byte)")) {
            val.type = ValueType.Type.TByte;
            val.value = new Byte(token.substring(6));
            return val;
        }
        try {
            val.type = ValueType.Type.TInteger;
            val.value = new Integer(token);
            return val;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new Exception(this.getCurrentTokenLine() + ": Could not parse value: " + token);
        }
    }

    protected void parseMethod(int access, String signature) throws Exception {
        String value = this.getCurrentToken();
        String[] exceptionsArray = null;
        HashMap<String, Label> labels = new HashMap<String, Label>();
        int index = value.indexOf("(");
        String methodName = value.substring(0, index);
        String desc = value.substring(index);
        value = this.nextToken();
        if (value.equals("throws")) {
            ArrayList<String> exceptions = new ArrayList<String>();
            while (!(value = this.nextToken()).equals("\n")) {
                exceptions.add(value);
            }
            exceptionsArray = exceptions.toArray(new String[exceptions.size()]);
        } else if (!value.equals("\n")) {
            throw new Exception(this.getCurrentTokenLine() + ": Error while parsing method: Expected \\n on method header, got: " + value);
        }
        MethodVisitor method = this.cl.visitMethod(access, methodName, desc, signature, exceptionsArray);
        while ((value = this.nextToken()).startsWith("@")) {
            int valuesOffset = value.indexOf("(");
            String valuesToken = "";
            if (valuesOffset != -1) {
                valuesToken = value.substring(valuesOffset);
                valuesToken = valuesToken + this.getLine();
            }
            desc = value.substring(1, valuesOffset);
            AnnotationVisitor av = method.visitAnnotation(desc, true);
            this.parseAnnotation(av, valuesToken);
            av.visitEnd();
        }
        --this.currentToken;
        boolean lineData = false;
        String insnSignature = null;
        while (true) {
            if ((value = this.nextToken()).equals("}")) {
                --this.currentToken;
                break;
            }
            if (value.startsWith("//")) {
                value = this.nextToken();
                if (value.equals("signature")) {
                    insnSignature = this.nextToken();
                } else {
                    --this.currentToken;
                }
                this.skipLine();
                continue;
            }
            if (!value.equals("\n")) {
                lineData = true;
                --this.currentToken;
                this.parseInstruction(method, labels, insnSignature);
                insnSignature = null;
                continue;
            }
            if (!lineData) break;
            lineData = false;
        }
        method.visitEnd();
    }

    protected void parseInstruction(MethodVisitor method, Map<String, Label> labels, String signature) throws Exception {
        String value = this.nextToken();
        String[] insn = new String[]{"NOP", "ACONST_NULL", "ICONST_M1", "ICONST_0", "ICONST_1", "ICONST_2", "ICONST_3", "ICONST_4", "ICONST_5", "LCONST_0", "LCONST_1", "FCONST_0", "FCONST_1", "FCONST_2", "DCONST_0", "DCONST_1", "IALOAD", "LALOAD", "FALOAD", "DALOAD", "AALOAD", "BALOAD", "CALOAD", "SALOAD", "IASTORE", "LASTORE", "FASTORE", "DASTORE", "AASTORE", "BASTORE", "CASTORE", "SASTORE", "POP", "POP2", "DUP", "DUP_X1", "DUP_X2", "DUP2", "DUP2_X1", "DUP2_X2", "SWAP", "IADD", "LADD", "FADD", "DADD", "ISUB", "LSUB", "FSUB", "DSUB", "IMUL", "LMUL", "FMUL", "DMUL", "IDIV", "LDIV", "FDIV", "DDIV", "IREM", "LREM", "FREM", "DREM", "INEG", "LNEG", "FNEG", "DNEG", "ISHL", "LSHL", "ISHR", "LSHR", "IUSHR", "LUSHR", "IAND", "LAND", "IOR", "LOR", "IXOR", "LXOR", "I2L", "I2F", "I2D", "L2I", "L2F", "L2D", "F2I", "F2L", "F2D", "D2I", "D2L", "D2F", "I2B", "I2C", "I2S", "LCMP", "FCMPL", "FCMPG", "DCMPL", "DCMPG", "IRETURN", "LRETURN", "FRETURN", "DRETURN", "ARETURN", "RETURN", "ARRAYLENGTH", "ATHROW", "MONITORENTER", "MONITOREXIT"};
        String[] intInsn = new String[]{"BIPUSH", "SIPUSH", "NEWARRAY"};
        String[] varInsn = new String[]{"ILOAD", "LLOAD", "FLOAD", "DLOAD", "ALOAD", "ISTORE", "LSTORE", "FSTORE", "DSTORE", "ASTORE", "RET"};
        String[] typeInsn = new String[]{"NEW", "ANEWARRAY", "CHECKCAST", "INSTANCEOF"};
        String[] fieldInsn = new String[]{"GETSTATIC", "PUTSTATIC", "GETFIELD", "PUTFIELD"};
        String[] methodInsn = new String[]{"INVOKEVIRTUAL", "INVOKESPECIAL", "INVOKESTATIC", "INVOKEINTERFACE"};
        String[] jumpInsn = new String[]{"IFEQ", "IFNE", "IFLT", "IFGE", "IFGT", "IFLE", "IF_ICMPEQ", "IF_ICMPNE", "IF_ICMPLT", "IF_ICMPGE", "IF_ICMPGT", "IF_ICMPLE", "IF_ACMPEQ", "IF_ACMPNE", "GOTO", "JSR", "IFNULL", "IFNONNULL"};
        if (this.stringArrayContains(insn, value)) {
            int opcode = Opcodes.class.getField(value).getInt(null);
            method.visitInsn(opcode);
        } else if (this.stringArrayContains(intInsn, value)) {
            int opcode = Opcodes.class.getField(value).getInt(null);
            if (value.equals("NEWARRAY")) {
                method.visitIntInsn(opcode, Opcodes.class.getField(this.nextToken()).getInt(null));
            } else {
                method.visitIntInsn(opcode, Integer.parseInt(this.nextToken()));
            }
        } else if (this.stringArrayContains(varInsn, value)) {
            int opcode = Opcodes.class.getField(value).getInt(null);
            method.visitVarInsn(opcode, Integer.parseInt(this.nextToken()));
        } else if (this.stringArrayContains(typeInsn, value)) {
            int opcode = Opcodes.class.getField(value).getInt(null);
            method.visitTypeInsn(opcode, this.nextToken());
        } else if (this.stringArrayContains(fieldInsn, value)) {
            int opcode = Opcodes.class.getField(value).getInt(null);
            String temp = this.nextToken();
            int index = temp.indexOf(".");
            String owner = temp.substring(0, index);
            String field = temp.substring(index + 1);
            ++this.currentToken;
            temp = this.nextToken();
            method.visitFieldInsn(opcode, owner, field, temp);
        } else if (this.stringArrayContains(methodInsn, value)) {
            int opcode = Opcodes.class.getField(value).getInt(null);
            String temp = this.nextToken();
            int index = temp.indexOf(".");
            String owner = temp.substring(0, index);
            String field = temp.substring(index + 1);
            temp = this.nextToken();
            method.visitMethodInsn(opcode, owner, field, temp);
        } else if (this.stringArrayContains(jumpInsn, value)) {
            int opcode = Opcodes.class.getField(value).getInt(null);
            String labelIndex = this.nextToken();
            method.visitJumpInsn(opcode, this.getLabel(labels, labelIndex));
        } else if (value.startsWith("L") && StringUtils.isNumeric((CharSequence)value.substring(1))) {
            method.visitLabel(this.getLabel(labels, value));
        } else if (value.equals("LDC")) {
            ValueType obj = this.parseValue(this.nextToken());
            method.visitLdcInsn(obj.value);
        } else if (value.equals("IINC")) {
            int index = Integer.parseInt(this.nextToken());
            int increase = Integer.parseInt(this.nextToken());
            method.visitIincInsn(index, increase);
        } else if (value.equals("TABLESWITCH")) {
            ++this.currentToken;
            int min = 0;
            int max = 0;
            ArrayList<Label> labelList = new ArrayList<Label>();
            while (true) {
                String temp;
                if ((temp = this.nextToken()).equals("default:")) break;
                int index = Integer.parseInt(temp.substring(0, temp.length() - 1));
                labelList.add(this.getLabel(labels, this.nextToken()));
                if (index > max) {
                    max = index;
                    continue;
                }
                if (index >= min) continue;
                min = index;
            }
            Label defLabel = this.getLabel(labels, this.nextToken());
            method.visitTableSwitchInsn(min, max, defLabel, (Label[])labelList.toArray());
        } else if (value.equals("LOOKUPSWITCH")) {
            ArrayList<Integer> keyList = new ArrayList<Integer>();
            ArrayList<Label> labelList = new ArrayList<Label>();
            while (true) {
                String temp;
                if ((temp = this.nextToken()).equals("default:")) break;
                keyList.add(Integer.parseInt(temp.substring(0, temp.length() - 1)));
                labelList.add(this.getLabel(labels, this.nextToken()));
            }
            Label defLabel = this.getLabel(labels, this.nextToken());
            method.visitLookupSwitchInsn(defLabel, Ints.toArray(keyList), (Label[])labelList.toArray());
        } else if (value.equals("MULTIANEWARRAY")) {
            method.visitMultiANewArrayInsn(this.nextToken(), Integer.parseInt(this.nextToken()));
        } else {
            if (value.equals("INVOKEDYNAMIC")) {
                throw new Exception(this.getCurrentTokenLine() + ": Error while parsing method instructions: Handling 'INVOKEDYNAMIC' not yet implemented!");
            }
            if (value.equals("TRYCATCHBLOCK")) {
                Label start = this.getLabel(labels, this.nextToken());
                Label end = this.getLabel(labels, this.nextToken());
                Label handler = this.getLabel(labels, this.nextToken());
                method.visitTryCatchBlock(start, end, handler, this.nextToken());
            } else if (value.equals("LOCALVARIABLE")) {
                String name = this.nextToken();
                String desc = this.nextToken();
                Label start = this.getLabel(labels, this.nextToken());
                Label end = this.getLabel(labels, this.nextToken());
                int index = Integer.parseInt(this.nextToken());
                method.visitLocalVariable(name, desc, signature, start, end, index);
            } else if (value.equals("LINENUMBER")) {
                int line = Integer.parseInt(this.nextToken());
                Label start = this.getLabel(labels, this.nextToken());
                method.visitLineNumber(line, start);
            } else if (value.equals("FRAME")) {
                String typeStr = this.nextToken();
                int type = 0;
                switch (typeStr) {
                    case "NEW": {
                        type = -1;
                        break;
                    }
                    case "FULL": {
                        type = 0;
                        break;
                    }
                    case "SAME": {
                        type = 3;
                        break;
                    }
                    case "SAME1": {
                        type = 4;
                        break;
                    }
                    case "APPEND": {
                        type = 1;
                        break;
                    }
                    case "CHOP": {
                        type = 2;
                        break;
                    }
                    default: {
                        throw new Exception(this.getCurrentTokenLine() + ": Error while parsing method frame: No known FRAME type found. Got: " + typeStr);
                    }
                }
                Object[] localTypes = null;
                Object[] stackTypes = null;
                int localCount = 0;
                int stackCount = 0;
                if (type == -1 || type == 0) {
                    localTypes = this.parseFrameElements(labels);
                    localCount = localTypes.length;
                    stackTypes = this.parseFrameElements(labels);
                    stackCount = stackTypes.length;
                } else if (type == 4) {
                    stackTypes = new Object[]{this.nextToken()};
                    stackCount = 1;
                } else if (type == 1) {
                    localTypes = this.parseFrameElements(labels);
                    localCount = localTypes.length;
                } else if (type == 2) {
                    localCount = Integer.parseInt(this.nextToken());
                }
                method.visitFrame(type, localCount, localTypes, stackCount, stackTypes);
            } else if (value.equals("MAXSTACK")) {
                ++this.currentToken;
                int maxStack = Integer.parseInt(this.nextToken());
                ++this.currentToken;
                if (!this.nextToken().equals("MAXLOCALS")) {
                    throw new Exception(this.getCurrentTokenLine() + ": Error while parsing method: Expected MAXLOCALS, got: " + this.getCurrentToken());
                }
                ++this.currentToken;
                int maxLocals = Integer.parseInt(this.nextToken());
                method.visitMaxs(maxStack, maxLocals);
            } else {
                throw new RuntimeException(this.getCurrentTokenLine() + ": Parser got unknown method instruction: " + value);
            }
        }
    }

    protected Object[] parseFrameElements(Map<String, Label> labels) throws Exception {
        ArrayList<Object> objects = new ArrayList<Object>();
        String value = this.nextToken();
        if (value.equals("[]")) {
            return objects.toArray();
        }
        if (value.endsWith("]")) {
            objects.add(this.parseFrameType(labels, value.substring(1, value.length() - 1)));
            return objects.toArray();
        }
        objects.add(this.parseFrameType(labels, value.substring(1)));
        while (true) {
            if ((value = this.nextToken()).endsWith("]")) {
                objects.add(this.parseFrameType(labels, value.substring(0, value.length() - 1)));
                return objects.toArray();
            }
            objects.add(this.parseFrameType(labels, value));
        }
    }

    protected Object parseFrameType(Map<String, Label> labels, String typeStr) throws Exception {
        if (typeStr.length() == 1) {
            switch (typeStr) {
                case "T": {
                    return Opcodes.TOP;
                }
                case "I": {
                    return Opcodes.INTEGER;
                }
                case "F": {
                    return Opcodes.FLOAT;
                }
                case "D": {
                    return Opcodes.DOUBLE;
                }
                case "J": {
                    return Opcodes.LONG;
                }
                case "N": {
                    return Opcodes.NULL;
                }
                case "U": {
                    return Opcodes.UNINITIALIZED_THIS;
                }
            }
            throw new Exception(this.getCurrentTokenLine() + ": Error while parsing frame type, found no type for " + typeStr);
        }
        if (typeStr.startsWith("L") && StringUtils.isNumeric((CharSequence)typeStr.substring(1))) {
            return this.getLabel(labels, typeStr);
        }
        return typeStr;
    }

    protected Label getLabel(Map<String, Label> labelMap, String labelIndex) {
        Label label = labelMap.computeIfAbsent(labelIndex, k -> new Label());
        return label;
    }

    protected boolean stringArrayContains(String[] arr, String value) {
        for (String anArr : arr) {
            if (!anArr.equals(value)) continue;
            return true;
        }
        return false;
    }

    public class Token {
        public String str;
        public int line;
    }
}

