/*
 * Decompiled with CFR 0.152.
 */
package com.wildex999.tickdynamic;

import com.wildex999.tickdynamic.TickDynamicMod;
import com.wildex999.tickdynamic.listinject.EntityGroup;
import com.wildex999.tickdynamic.listinject.EntityType;
import com.wildex999.tickdynamic.listinject.ListManager;
import com.wildex999.tickdynamic.timemanager.ITimed;
import com.wildex999.tickdynamic.timemanager.TimedEntities;
import java.util.ArrayList;
import java.util.Set;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.common.config.ConfigCategory;
import net.minecraftforge.common.config.Configuration;

public class TickDynamicConfig {
    public static void loadConfig(TickDynamicMod mod, boolean groups) {
        mod.config = new Configuration(mod.config.getConfigFile());
        mod.config.getCategory("general");
        mod.config.setCategoryComment("general", "WEBSITE: https://mods.curse.com/mc-mods/minecraft/269359-tick-dynamic   <- Head here for the documentation, or if you have questions.\nISSUE TRACKER: https://github.com/The-Fireplace/TickDynamic/issues   <- Go here if you have problems, log spam, or suggestions to improve the mod.\n\nSlices are the way you control the time allotment to each world, and within each world, to Entities and TileEntities.\nEach tick the time for a tick(By default 50ms) will be distributed among all the worlds, according to how many slices they have.\nIf you have 3 worlds, each with 100 slices, then each world will get 100/300 = ~33% of the time.\nSo you can thus give the Overworld a maxSlices of 300, while giving the other two 100 each. This way the Overworld will get 60% of the time.\n\nOf the time given to the world, this is further distributed to TileEntities and Entities according to their slices, the same way.\nTileEntities and Entities are given a portion of the time first given to the world, so their slices are only relative to each other within that world.If any group has unused time, then that time will be distributed to the remaining groups.\nSo even if you give 1000 slices to TileEntities and 100 to Entities, as long as as TileEntities aren't using it's full time,\nEntities will be able to use more than 100 slices of time.\n\nSo the formula for slices to time percentage is: (singleGroupInWorld.maxSlices/combinedGroupsInWorld.maxSlices)*100\n\nNote: maxSlices = 0 has a special meaning. It means that the group's time usage is accounted for, but not limited.\nBasically it can take all the time it needs, even if it goes above the parent maxTime, pushing its siblings down to minimumObjects.");
        mod.enabled = mod.config.get("general", "enabled", true, "").getBoolean();
        TickDynamicMod.nologs = mod.config.get("general", "nologs", TickDynamicMod.nologs, "Disables all log output to the console. Make sure this is off before providing the author with logs.").getBoolean();
        TickDynamicMod.debugGroups = mod.config.get("general", "debugGroups", TickDynamicMod.debugGroups, "Debug Group mapping and assignment. Will spam during world load and config reload!!!").getBoolean();
        TickDynamicMod.debugTimer = mod.config.get("general", "debugTimer", TickDynamicMod.debugTimer, "Debug output from time allocation and calculation. Warning: Setting this to true will cause a lot of console spam.\nOnly do it if developer or someone else asks for the output!").getBoolean();
        mod.defaultWorldSlicesMax = mod.config.get("general", "defaultWorldSlicesMax", mod.defaultWorldSlicesMax, "The default maxSlices for a new automatically added world.").getInt();
        mod.defaultAverageTicks = mod.config.get("general", "averageTicks", mod.defaultAverageTicks, "How many ticks of data to use when averaging for time balancing.\nA higher number will make it take regular spikes into account, however will make it slower to adjust to changes.").getInt();
        mod.defaultTickTime = mod.config.get("worlds", "tickTime", mod.defaultTickTime, "The time allotted to a tick in milliseconds. 20 Ticks per second means 50ms per tick.\nThis is the base time allotment it will use when balancing the time usage between worlds and objects.\nYou can set this to less than 50ms if you want to leave a bit of buffer time for other things, or don't want to use 100% cpu.").getInt();
        if (groups) {
            TickDynamicConfig.loadGlobalGroups(mod);
            if (!mod.config.hasCategory("worlds.dim0.entity")) {
                mod.config.get("worlds.dim0.entity", "slicesMax", mod.defaultEntitySlicesMax);
                mod.config.get("worlds.dim0.entity", "groupType", EntityType.Entity.toString());
            }
            if (!mod.config.hasCategory("worlds.dim0.tileentity")) {
                mod.config.get("worlds.dim0.tileentity", "slicesMax", mod.defaultEntitySlicesMax);
                mod.config.get("worlds.dim0.tileentity", "groupType", EntityType.TileEntity.toString());
            }
            WorldServer[] worlds = DimensionManager.getWorlds();
            for (WorldServer world : worlds) {
                TickDynamicMod.logDebug("Reloading " + world.field_73011_w.func_186058_p().func_186065_b(), new Object[0]);
                if (world.field_72996_f instanceof ListManager) {
                    ListManager entityList = (ListManager)world.field_72996_f;
                    TickDynamicMod.logDebug("Reloading " + entityList.size() + " Entities...", new Object[0]);
                    entityList.reloadGroups();
                }
                if (!(world.field_147482_g instanceof ListManager)) continue;
                ListManager tileList = (ListManager)world.field_147482_g;
                TickDynamicMod.logDebug("Reloading " + tileList.size() + " TileEntities...", new Object[0]);
                tileList.reloadGroups();
            }
            TickDynamicMod.logDebug("Done reloading worlds", new Object[0]);
            for (ITimed timed : mod.timedObjects.values()) {
                if (timed instanceof TimedEntities) {
                    TimedEntities timedGroup = (TimedEntities)timed;
                    if (!timedGroup.getEntityGroup().valid) {
                        mod.timedObjects.remove(timedGroup);
                        continue;
                    }
                }
                timed.loadConfig(false);
            }
            if (mod.root != null) {
                mod.root.setTimeMax((long)mod.defaultTickTime * 1000000L);
            }
        }
        mod.config.save();
    }

    public static void loadGlobalGroups(TickDynamicMod mod) {
        mod.config.setCategoryComment("groups", "Groups define a list of Entities and/or TileEntities and the configuration for them.\nYou can define the groups here, and they will automatically be part of every world.\n\nIf you wish to override the settings for a group in a specific world, you can simply include a group with the same name in the world,\nand then provide the new values. Any value you do not define will be read from the global group.\nSo you can for example define a group for all Animal mobs, and define them to get less time than other Entities in all worlds,\nbut then define them to get even less time in a certain world without having to re-define the list of Entities.\n\nNote that the groups 'entity' and 'tileentity' are special groups. Any TileEntity or Entity which are not included in any other group,\nwill be automatically included in these two groups.");
        TickDynamicConfig.loadDefaultGlobalGroups(mod);
        TickDynamicConfig.loadGroups("groups");
    }

    public static void loadGroups(String category) {
        ConfigCategory groupsCat = TickDynamicMod.instance.config.getCategory(category);
        Set groups = groupsCat.getChildren();
        ArrayList<String> toRemove = new ArrayList<String>();
        for (String groupPath : TickDynamicMod.instance.entityGroups.keySet()) {
            EntityGroup entityGroup;
            if (!groupPath.startsWith(category)) continue;
            int nameIndex = groupPath.lastIndexOf(".");
            String groupName = nameIndex == -1 ? groupPath : groupPath.substring(nameIndex + 1);
            boolean remove = true;
            if (TickDynamicMod.instance.config.hasCategory(groupPath)) {
                remove = false;
            }
            if (remove && (entityGroup = TickDynamicMod.instance.entityGroups.get(groupPath)) != null && entityGroup.base != null && TickDynamicMod.instance.config.hasCategory("groups." + groupName)) {
                remove = false;
            }
            if (!remove) continue;
            TickDynamicMod.logDebug("Remove Group: " + groupPath, new Object[0]);
            toRemove.add(groupPath);
        }
        for (String groupPath : toRemove) {
            EntityGroup groupRemoved = TickDynamicMod.instance.entityGroups.remove(groupPath);
            if (groupRemoved == null) continue;
            groupRemoved.valid = false;
        }
        ArrayList<EntityGroup> updateGroups = new ArrayList<EntityGroup>();
        for (ConfigCategory group : groups) {
            String groupPath = category + "." + group.getName();
            EntityGroup entityGroup = TickDynamicMod.instance.getEntityGroup(groupPath);
            if (entityGroup == null) {
                TickDynamicMod.logDebug("Loading group: " + groupPath, new Object[0]);
                TimedEntities timedEntities = (TimedEntities)TickDynamicMod.instance.getTimedGroup(groupPath);
                if (timedEntities == null) {
                    timedEntities = new TimedEntities(null, group.getName(), groupPath, null);
                    timedEntities.init();
                }
                entityGroup = new EntityGroup(null, timedEntities, group.getName(), groupPath, EntityType.Entity, null);
                TickDynamicMod.instance.entityGroups.put(groupPath, entityGroup);
                TickDynamicMod.logDebug("New Group: " + groupPath, new Object[0]);
                continue;
            }
            updateGroups.add(entityGroup);
            TickDynamicMod.logDebug("Update Group: " + groupPath, new Object[0]);
        }
        for (EntityGroup entityGroup : updateGroups) {
            entityGroup.readConfig(false);
        }
    }

    public static void loadDefaultGlobalGroups(TickDynamicMod mod) {
        TimedEntities timedGroup;
        String groupPath = "groups.entity";
        EntityGroup group = mod.getEntityGroup(groupPath);
        if (group == null) {
            timedGroup = new TimedEntities(null, "entity", groupPath, null);
            timedGroup.init();
            group = new EntityGroup(null, timedGroup, "entity", groupPath, EntityType.Entity, null);
            mod.entityGroups.put(groupPath, group);
        }
        if ((group = mod.getEntityGroup(groupPath = "groups.players")) == null) {
            mod.config.get(groupPath, "slicesMax", 0);
            String[] entityClasses = new String[]{EntityPlayer.class.getName(), EntityPlayerMP.class.getName()};
            mod.config.get(groupPath, "entityClassNames", entityClasses);
            timedGroup = new TimedEntities(null, "players", groupPath, null);
            timedGroup.init();
            group = new EntityGroup(null, timedGroup, "players", groupPath, EntityType.Entity, null);
            mod.entityGroups.put(groupPath, group);
        }
        if ((group = mod.getEntityGroup(groupPath = "groups.tileentity")) == null) {
            timedGroup = new TimedEntities(null, "tileentity", groupPath, null);
            timedGroup.init();
            group = new EntityGroup(null, timedGroup, "tileentity", groupPath, EntityType.TileEntity, null);
            mod.entityGroups.put(groupPath, group);
        }
    }
}

