/*
 * Decompiled with CFR 0.152.
 */
package com.wildex999.tickdynamic;

import com.google.common.collect.Maps;
import com.wildex999.tickdynamic.TickDynamicMod;
import com.wildex999.tickdynamic.listinject.CustomProfiler;
import com.wildex999.tickdynamic.listinject.EntityType;
import com.wildex999.tickdynamic.listinject.ListManager;
import com.wildex999.tickdynamic.listinject.ListManagerEntities;
import com.wildex999.tickdynamic.timemanager.ITimed;
import com.wildex999.tickdynamic.timemanager.TimeManager;
import com.wildex999.tickdynamic.timemanager.TimedEntities;
import java.util.HashMap;
import java.util.List;
import net.minecraft.profiler.Profiler;
import net.minecraft.world.World;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.ReflectionHelper;

public class WorldEventHandler {
    private HashMap<World, ListManagerEntities> entityListManager = Maps.newHashMap();
    private HashMap<World, ListManager> tileListManager = Maps.newHashMap();

    @SubscribeEvent
    public void worldTickEvent(TickEvent.WorldTickEvent event) {
        Profiler profiler = event.world.field_72984_F;
        if (!(profiler instanceof CustomProfiler)) {
            return;
        }
        CustomProfiler customProfiler = (CustomProfiler)profiler;
        if (event.phase == TickEvent.Phase.START) {
            customProfiler.setStage(CustomProfiler.Stage.BeforeLoop);
        } else {
            customProfiler.setStage(CustomProfiler.Stage.None);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onDimensionLoad(WorldEvent.Load event) {
        List tiles;
        List entities;
        if (event.getWorld().field_72995_K) {
            return;
        }
        TickDynamicMod.logDebug("World load: " + event.getWorld().field_73011_w.func_186058_p().func_186065_b(), new Object[0]);
        try {
            this.setCustomProfiler(event.getWorld(), new CustomProfiler(event.getWorld().field_72984_F));
        }
        catch (Exception e) {
            TickDynamicMod.logError("Unable to set TickDynamic World profiler! World will not be using TickDynamic: " + event.getWorld(), new Object[0]);
            e.printStackTrace();
            return;
        }
        ListManagerEntities entityManager = new ListManagerEntities(event.getWorld());
        this.entityListManager.put(event.getWorld(), entityManager);
        ListManager tileEntityManager = new ListManager(event.getWorld(), EntityType.TileEntity);
        this.tileListManager.put(event.getWorld(), tileEntityManager);
        TickDynamicMod.logDebug("Adding " + event.getWorld().field_72996_f.size() + " existing Entities.", new Object[0]);
        List oldList = entities = event.getWorld().field_72996_f;
        ReflectionHelper.setPrivateValue(World.class, (Object)event.getWorld(), (Object)entityManager, (String[])new String[]{"loadedEntityList", "field_72996_f"});
        entityManager.addAll(oldList);
        TickDynamicMod.logDebug("Adding " + event.getWorld().field_175730_i.size() + " existing TileEntities.", new Object[0]);
        oldList = tiles = event.getWorld().field_175730_i;
        ReflectionHelper.setPrivateValue(World.class, (Object)event.getWorld(), tileEntityManager, (String[])new String[]{"tickableTileEntities", "field_175730_i"});
        tileEntityManager.addAll(oldList);
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onDimensionUnload(WorldEvent.Unload event) {
        if (event.getWorld() == null || event.getWorld().field_72995_K) {
            return;
        }
        TickDynamicMod.logDebug("TickDynamic unloading injected lists for world: " + event.getWorld().field_73011_w.func_186058_p().func_186065_b(), new Object[0]);
        try {
            CustomProfiler customProfiler = (CustomProfiler)event.getWorld().field_72984_F;
            this.setCustomProfiler(event.getWorld(), customProfiler.original);
        }
        catch (Exception e) {
            TickDynamicMod.logError("Failed to revert World Profiler to original", new Object[0]);
            e.printStackTrace();
        }
        ListManager list = this.entityListManager.remove(event.getWorld());
        if (list != null) {
            list.clear();
        }
        if ((list = this.tileListManager.remove(event.getWorld())) != null) {
            list.clear();
        }
        TickDynamicMod.instance.clearWorldEntityGroups(event.getWorld());
        TimeManager manager = TickDynamicMod.instance.getWorldTimeManager(event.getWorld());
        if (manager != null) {
            TickDynamicMod.instance.timedObjects.remove(manager);
        }
        for (ITimed timed : TickDynamicMod.instance.timedObjects.values()) {
            if (!(timed instanceof TimedEntities)) continue;
            TimedEntities timedGroup = (TimedEntities)timed;
            if (timedGroup.getEntityGroup().valid) continue;
            TickDynamicMod.instance.timedObjects.remove(timedGroup);
        }
    }

    private void setCustomProfiler(World world, Profiler profiler) throws Exception {
        ReflectionHelper.setPrivateValue(World.class, (Object)world, (Object)profiler, (String[])new String[]{"theProfiler", "field_72984_F"});
    }
}

