/*
 * Decompiled with CFR 0.152.
 */
package com.wildex999.tickdynamic.listinject;

import net.minecraft.profiler.Profiler;

public class CustomProfiler
extends Profiler {
    public final Profiler original;
    public Stage stage;
    public boolean reachedTile;
    private int depthCount;

    public CustomProfiler(Profiler originalProfiler) {
        this.original = originalProfiler;
        this.stage = Stage.None;
        this.reachedTile = false;
    }

    public void setStage(Stage stage) {
        this.stage = stage;
    }

    public void func_76320_a(String sectionName) {
        switch (this.stage) {
            case None: {
                break;
            }
            case BeforeLoop: {
                if (!sectionName.equals("regular")) break;
                this.setStage(Stage.InLoop);
                break;
            }
            case InLoop: {
                switch (sectionName) {
                    case "tick": {
                        this.setStage(Stage.InTick);
                        this.depthCount = 0;
                        break;
                    }
                    case "remove": {
                        this.setStage(Stage.InRemove);
                        this.depthCount = 0;
                        break;
                    }
                    case "blockEntities": {
                        this.setStage(Stage.None);
                        this.reachedTile = true;
                    }
                }
                break;
            }
            case InTick: {
                if (this.depthCount <= 1 && sectionName.equals("remove")) {
                    this.setStage(Stage.InRemove);
                    this.depthCount = 0;
                    break;
                }
            }
            case InRemove: {
                ++this.depthCount;
            }
        }
        this.original.func_76320_a(sectionName);
    }

    public void func_76319_b() {
        switch (this.stage) {
            case InTick: {
                if (this.depthCount-- > 0) break;
                this.setStage(Stage.InLoop);
                break;
            }
            case InRemove: {
                if (this.depthCount-- > 0) break;
                this.setStage(Stage.InLoop);
                break;
            }
        }
        this.original.func_76319_b();
    }

    public static enum Stage {
        None,
        BeforeLoop,
        InLoop,
        InTick,
        InRemove;

    }
}

