/*
 * Decompiled with CFR 0.152.
 */
package com.wildex999.tickdynamic.listinject;

import com.wildex999.tickdynamic.listinject.EntityGroup;
import com.wildex999.tickdynamic.listinject.EntityObject;
import com.wildex999.tickdynamic.listinject.ListManager;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;

public class EntityIterator
implements Iterator<EntityObject> {
    private ListManager list;
    private int currentAge;
    private EntityGroup currentGroup;
    private EntityObject currentObject;
    private Iterator<EntityGroup> groupIterator;
    private List<EntityObject> entityList;
    private int currentIndex;

    public EntityIterator(ListManager list, int age) {
        this.list = list;
        this.currentAge = age;
        this.groupIterator = list.getGroupIterator();
        this.currentIndex = 0;
    }

    @Override
    public boolean hasNext() {
        if (this.currentAge != this.list.age) {
            throw new ConcurrentModificationException("List modified before going to next entry");
        }
        while (this.entityList == null || this.currentIndex >= this.entityList.size()) {
            this.currentIndex = 0;
            this.entityList = null;
            if (!this.groupIterator.hasNext()) {
                return false;
            }
            this.currentGroup = this.groupIterator.next();
            if (this.currentGroup == null) {
                return false;
            }
            this.entityList = this.currentGroup.entities;
        }
        return true;
    }

    @Override
    public EntityObject next() {
        if (this.currentAge != this.list.age) {
            throw new ConcurrentModificationException("List modified before going to next entry");
        }
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        this.currentObject = this.entityList.get(this.currentIndex++);
        return this.currentObject;
    }

    @Override
    public void remove() {
        if (this.currentAge != this.list.age) {
            throw new ConcurrentModificationException("List modified before going to next entry");
        }
        if (this.currentObject == null) {
            return;
        }
        this.list.remove(this.currentObject);
        ++this.currentAge;
        --this.currentIndex;
        if (this.currentIndex < 0) {
            this.currentIndex = 0;
        }
    }
}

