/*
 * Decompiled with CFR 0.152.
 */
package com.wildex999.tickdynamic.timemanager;

import com.wildex999.tickdynamic.TickDynamicMod;
import com.wildex999.tickdynamic.listinject.EntityGroup;
import com.wildex999.tickdynamic.timemanager.TimedGroup;
import java.util.Iterator;
import java.util.LinkedList;
import net.minecraft.world.World;

public class TimedEntities
extends TimedGroup {
    protected int currentObjectIndex;
    protected int updateCount;
    protected TimedGroup base;
    protected EntityGroup entityGroup;
    public static final String configKeyMinimumObjects = "minimumObjects";
    public static final String configKeyMinimumTPS = "minimumTPS";
    public static final String configKeyMinimumTime = "minimumTime";
    protected int minimumObjects;
    protected float minimumTPS;
    protected float minimumTime;
    protected double currentTPS;
    protected LinkedList<Double> listTPS;
    public double averageTPS;

    public TimedEntities(World world, String name, String configEntry, TimedGroup base) {
        super(world, name, configEntry);
        this.base = base;
    }

    @Override
    public void init() {
        this.currentTPS = 0.0;
        this.objectsRun = 0;
        this.listTPS = new LinkedList();
        this.setTimeMax(0L);
        if (this.base == null) {
            this.setSliceMax(TickDynamicMod.instance.defaultEntitySlicesMax);
            this.setMinimumObjects(TickDynamicMod.instance.defaultEntityMinimumObjects);
            this.setMinimumTPS(TickDynamicMod.instance.defaultEntityMinimumTPS);
            this.setMinimumTime(TickDynamicMod.instance.defaultEntityMinimumTime);
        } else {
            this.setSliceMax(this.base.getSliceMax());
            if (this.base instanceof TimedEntities) {
                TimedEntities baseEntities = (TimedEntities)this.base;
                this.setMinimumObjects(baseEntities.getMinimumObjects());
                this.setMinimumTPS(baseEntities.getMinimumTPS());
                this.setMinimumTime(baseEntities.getMinimumTime());
            }
        }
        this.loadConfig(true);
    }

    @Override
    public void loadConfig(boolean saveDefaults) {
        if (this.configEntry == null) {
            return;
        }
        String comment = "The number of slices given to this Group";
        this.sliceMax = this.base != null && !TickDynamicMod.instance.config.hasKey(this.configEntry, "slicesMax") ? TickDynamicMod.instance.config.get(this.base.configEntry, "slicesMax", this.sliceMax, comment).getInt() : TickDynamicMod.instance.config.get(this.configEntry, "slicesMax", this.sliceMax, comment).getInt();
        this.setSliceMax(this.sliceMax);
        comment = "Minimum number of objects to tick, independent of slices. Set to 0 to disable.";
        this.minimumObjects = this.base != null && !TickDynamicMod.instance.config.hasKey(this.configEntry, configKeyMinimumObjects) ? TickDynamicMod.instance.config.get(this.base.configEntry, configKeyMinimumObjects, this.minimumObjects, comment).getInt() : TickDynamicMod.instance.config.get(this.configEntry, configKeyMinimumObjects, this.minimumObjects, comment).getInt();
        this.setMinimumObjects(this.minimumObjects);
        comment = "Minimum TPS to keep, independent of slices. Set to 0 to disable.";
        this.minimumTPS = this.base != null && !TickDynamicMod.instance.config.hasKey(this.configEntry, configKeyMinimumTPS) ? (float)TickDynamicMod.instance.config.get(this.base.configEntry, configKeyMinimumTPS, (double)this.minimumTPS, comment).getDouble() : (float)TickDynamicMod.instance.config.get(this.configEntry, configKeyMinimumTPS, (double)this.minimumTPS, comment).getDouble();
        this.setMinimumTPS(this.minimumTPS);
        comment = "Minimum Time to keep(In milliseconds), independent of slices. Set to 0 to disable.";
        this.minimumTime = this.base != null && !TickDynamicMod.instance.config.hasKey(this.configEntry, configKeyMinimumTime) ? (float)TickDynamicMod.instance.config.get(this.base.configEntry, configKeyMinimumTime, (double)this.minimumTime, comment).getDouble() : (float)TickDynamicMod.instance.config.get(this.configEntry, configKeyMinimumTime, (double)this.minimumTime, comment).getDouble();
        this.setMinimumTime(this.minimumTime);
        if (saveDefaults) {
            TickDynamicMod.instance.queueSaveConfig();
        }
    }

    @Override
    public void writeConfig(boolean saveFile) {
        if (this.configEntry == null) {
            return;
        }
        if (saveFile) {
            TickDynamicMod.instance.queueSaveConfig();
        }
    }

    public void setMinimumObjects(int minimum) {
        this.minimumObjects = minimum;
    }

    public int getMinimumObjects() {
        return this.minimumObjects;
    }

    public void setMinimumTPS(float minimum) {
        this.minimumTPS = minimum;
    }

    public float getMinimumTPS() {
        return this.minimumTPS;
    }

    public void setMinimumTime(float minimum) {
        this.minimumTime = minimum;
    }

    public float getMinimumTime() {
        return this.minimumTime;
    }

    public int getTargetObjectCount() {
        if (this.timeMax == 0L || !TickDynamicMod.instance.enabled) {
            return Integer.MAX_VALUE;
        }
        double timePerObject = (int)Math.ceil((double)this.getTimeUsedAverage() / (double)this.getObjectsRunAverage());
        if (TickDynamicMod.debugTimer) {
            TickDynamicMod.logTrace(this.name + ": getTargetObjectCount: timeUsed:" + this.getTimeUsedAverage() + " objectsRun: " + this.getObjectsRunAverage() + " timePerObject: " + timePerObject + " timeMax: " + this.timeMax, new Object[0]);
        }
        return (int)Math.ceil((double)this.timeMax / timePerObject);
    }

    public void setEntityGroup(EntityGroup entityGroup) {
        this.entityGroup = entityGroup;
    }

    public EntityGroup getEntityGroup() {
        return this.entityGroup;
    }

    public int getCurrentObjectIndex() {
        return this.currentObjectIndex;
    }

    public void setCurrentObjectIndex(int index) {
        this.currentObjectIndex = index < 0 ? 0 : index;
    }

    public int startUpdateObjects() {
        if (this.entityGroup == null) {
            TickDynamicMod.logDebug("No EntityGroup for group:" + this.getName(), new Object[0]);
            return 0;
        }
        int listSize = this.entityGroup.getEntityCount();
        if (!TickDynamicMod.instance.enabled) {
            return listSize;
        }
        this.updateCount = this.getTargetObjectCount();
        if (this.updateCount < this.minimumObjects) {
            this.updateCount = this.minimumObjects;
        }
        if (this.updateCount > listSize) {
            this.updateCount = listSize;
        }
        this.currentTPS = listSize > 0 ? (double)this.updateCount / (double)listSize * 20.0 : 20.0;
        if (this.currentObjectIndex >= listSize) {
            this.currentObjectIndex = 0;
        }
        if (TickDynamicMod.debugTimer) {
            TickDynamicMod.logTrace("Start (" + this.name + "). Update Offset: " + this.currentObjectIndex + " | Updating: " + this.updateCount + " of " + listSize, new Object[0]);
        }
        return this.currentObjectIndex;
    }

    public int getUpdateCount() {
        return this.updateCount;
    }

    public void endUpdateObjects(int entitiesUpdated) {
        if (!TickDynamicMod.instance.enabled || this.entityGroup == null) {
            return;
        }
        int listSize = this.entityGroup.getEntityCount();
        this.objectsRun += entitiesUpdated;
        this.currentObjectIndex += entitiesUpdated;
        if (listSize > 0) {
            while (this.currentObjectIndex >= listSize) {
                this.currentObjectIndex -= listSize;
            }
        } else {
            this.currentObjectIndex = 0;
        }
    }

    @Override
    public void newTick(boolean clearChildren) {
        super.newTick(clearChildren);
        if (this.listTPS.size() >= TickDynamicMod.instance.defaultAverageTicks) {
            this.listTPS.removeFirst();
        }
        this.listTPS.add(this.currentTPS);
        this.currentTPS = 0.0;
        this.averageTPS = 0.0;
        Iterator iterator = this.listTPS.iterator();
        while (iterator.hasNext()) {
            double tps = (Double)iterator.next();
            this.averageTPS += tps;
        }
        this.averageTPS /= (double)this.listTPS.size();
    }

    @Override
    public long getReservedTime() {
        long reserved;
        if (this.sliceMax == 0) {
            return this.getTimeUsedAverage();
        }
        long reservedObjects = 0L;
        double timePerObject = (int)Math.ceil((double)this.getTimeUsedAverage() / (double)this.getObjectsRunAverage());
        if (this.getMinimumObjects() > 0) {
            reservedObjects = (long)(timePerObject * (double)this.getMinimumObjects());
        }
        long reservedTPS = 0L;
        if (this.getMinimumTPS() > 0.0f && this.world != null) {
            reservedTPS = (long)((double)this.getEntitiesCount() / 20.0 * (double)this.getMinimumTPS());
        }
        long reservedTime = 0L;
        if (this.getMinimumTime() > 0.0f) {
            reservedTime = (long)(this.getMinimumTime() * 1000000.0f);
        }
        if (reservedTPS > (reserved = reservedObjects)) {
            reserved = reservedTPS;
        }
        if (reservedTime > reserved) {
            reserved = reservedTime;
        }
        return reserved;
    }

    public int getEntitiesCount() {
        if (this.entityGroup == null) {
            return 0;
        }
        return this.entityGroup.entities.size();
    }
}

