/*
 * Decompiled with CFR 0.152.
 */
package io.github.moulberry.repo.data;

import io.github.moulberry.repo.IReloadable;
import io.github.moulberry.repo.NEURepoFile;
import io.github.moulberry.repo.NEURepository;
import io.github.moulberry.repo.NEURepositoryException;
import io.github.moulberry.repo.util.NEUId;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class ItemOverlays
implements IReloadable {
    List<ItemOverlayFile> overlays;
    private static final Pattern PATH_PATTERN = Pattern.compile("itemsOverlay/([0-9]+)/(.+)\\.snbt");

    public static ItemOverlays forRepo(NEURepository repository) {
        ItemOverlays overlays = new ItemOverlays();
        repository.registerReloadListener(overlays);
        return overlays;
    }

    @Override
    public void reload(NEURepository repository) throws NEURepositoryException {
        Stream<NEURepoFile> files = repository.tree("itemsOverlay");
        try {
            this.overlays = files.filter(NEURepoFile::isFile).map(file -> {
                Matcher matcher = PATH_PATTERN.matcher(file.getPath());
                if (matcher.matches()) {
                    int version = Integer.parseInt(matcher.group(1));
                    String name = matcher.group(2);
                    return new ItemOverlayFile((NEURepoFile)file, version, name);
                }
                return null;
            }).filter(Objects::nonNull).collect(Collectors.toList());
        }
        finally {
            if (Collections.singletonList(files).get(0) != null) {
                files.close();
            }
        }
    }

    public Map<@NEUId String, ItemOverlayFile> getMostUpToDateCompatibleWith(int version) {
        return this.overlays.stream().filter(it -> ((ItemOverlayFile)it).version <= version).collect(Collectors.toMap(ItemOverlayFile::getItemId, Function.identity(), (a, b) -> ((ItemOverlayFile)a).version > ((ItemOverlayFile)b).version ? a : b));
    }

    public List<ItemOverlayFile> getOverlays() {
        return this.overlays;
    }

    public static final class ItemOverlayFile {
        private final NEURepoFile file;
        private final int version;
        @NEUId
        private final String itemId;

        public ItemOverlayFile(NEURepoFile file, int version, String itemId) {
            this.file = file;
            this.version = version;
            this.itemId = itemId;
        }

        public NEURepoFile getFile() {
            return this.file;
        }

        public int getVersion() {
            return this.version;
        }

        public String getItemId() {
            return this.itemId;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ItemOverlayFile)) {
                return false;
            }
            ItemOverlayFile other = (ItemOverlayFile)o;
            if (this.getVersion() != other.getVersion()) {
                return false;
            }
            NEURepoFile this$file = this.getFile();
            NEURepoFile other$file = other.getFile();
            if (this$file == null ? other$file != null : !this$file.equals(other$file)) {
                return false;
            }
            String this$itemId = this.getItemId();
            String other$itemId = other.getItemId();
            return !(this$itemId == null ? other$itemId != null : !this$itemId.equals(other$itemId));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getVersion();
            NEURepoFile $file = this.getFile();
            result = result * 59 + ($file == null ? 43 : $file.hashCode());
            String $itemId = this.getItemId();
            result = result * 59 + ($itemId == null ? 43 : $itemId.hashCode());
            return result;
        }

        public String toString() {
            return "ItemOverlays.ItemOverlayFile(file=" + this.getFile() + ", version=" + this.getVersion() + ", itemId=" + this.getItemId() + ")";
        }
    }
}

