/*
 * Decompiled with CFR 0.152.
 */
package io.github.moulberry.repo.data;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import io.github.moulberry.repo.data.NEUItem;
import io.github.moulberry.repo.util.NEUId;
import java.lang.reflect.Type;

public class NEUIngredient {
    @NEUId
    String itemId;
    double amount;
    public static final String NEU_SENTINEL_EMPTY = "NEU_SENTINEL_EMPTY";
    public static final String NEU_SENTINEL_COINS = "SKYBLOCK_COIN";
    public static final NEUIngredient SENTINEL_EMPTY = new NEUIngredient();

    private NEUIngredient() {
    }

    public static NEUIngredient ofCoins(double coins) {
        NEUIngredient neuIngredient = new NEUIngredient();
        neuIngredient.amount = coins;
        neuIngredient.itemId = NEU_SENTINEL_COINS;
        return neuIngredient;
    }

    public static NEUIngredient fromItem(NEUItem item, int count) {
        NEUIngredient ingredient = new NEUIngredient();
        ingredient.amount = count;
        ingredient.itemId = item.getSkyblockItemId();
        return ingredient;
    }

    public static NEUIngredient fromString(String string) {
        String[] parts = string.split(":");
        NEUIngredient ingredient = new NEUIngredient();
        if (parts.length == 2) {
            ingredient.amount = Double.parseDouble(parts[1]);
        } else if (parts.length == 1) {
            ingredient.amount = 1.0;
        } else {
            throw new IllegalArgumentException("Could not parse ingredient " + string);
        }
        ingredient.itemId = parts[0];
        if (NEU_SENTINEL_EMPTY.equals(ingredient.itemId)) {
            return SENTINEL_EMPTY;
        }
        return ingredient;
    }

    public String toString() {
        return String.format("NEUIngredient{%s:%f}", this.itemId, this.amount);
    }

    public String getItemId() {
        return this.itemId;
    }

    public double getAmount() {
        return this.amount;
    }

    static {
        NEUIngredient.SENTINEL_EMPTY.itemId = NEU_SENTINEL_EMPTY;
        NEUIngredient.SENTINEL_EMPTY.amount = 0.0;
    }

    public static class Serializer
    implements JsonDeserializer<NEUIngredient> {
        public NEUIngredient deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            if (!json.isJsonPrimitive()) {
                throw new JsonParseException("Expected string for ingredient, found " + json);
            }
            JsonPrimitive p = json.getAsJsonPrimitive();
            if (!p.isString()) {
                throw new JsonParseException("Expected string for ingredient, found " + json);
            }
            String asString = json.getAsString();
            return NEUIngredient.fromString(asString);
        }
    }
}

