/*
 * Decompiled with CFR 0.152.
 */
package net.azureaaron.dandelion.deps.moulconfig.common;

import org.jetbrains.annotations.NotNull;

public final class Layer
implements Comparable<Layer> {
    private final int sortIndex;
    public static final Layer ROOT = new Layer(0);
    public static final Layer TOOLTIP = new Layer(300);
    public static final Layer OVERLAY = new Layer(100);

    public Layer next() {
        return new Layer(this.sortIndex + 1);
    }

    @Override
    public int compareTo(@NotNull Layer o) {
        return Integer.compare(this.sortIndex, o.sortIndex);
    }

    public int getSortIndex() {
        return this.sortIndex;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Layer)) {
            return false;
        }
        Layer other = (Layer)o;
        return this.getSortIndex() == other.getSortIndex();
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getSortIndex();
        return result;
    }

    public String toString() {
        return "Layer(sortIndex=" + this.getSortIndex() + ")";
    }

    public Layer(int sortIndex) {
        this.sortIndex = sortIndex;
    }
}

