/*
 * Decompiled with CFR 0.152.
 */
package net.azureaaron.dandelion.deps.moulconfig.common;

import java.util.List;
import java.util.function.Consumer;
import net.azureaaron.dandelion.deps.moulconfig.common.IFontRenderer;
import net.azureaaron.dandelion.deps.moulconfig.common.IItemStack;
import net.azureaaron.dandelion.deps.moulconfig.common.IMinecraft;
import net.azureaaron.dandelion.deps.moulconfig.common.KeyboardConstants;
import net.azureaaron.dandelion.deps.moulconfig.common.Layer;
import net.azureaaron.dandelion.deps.moulconfig.common.MyResourceLocation;
import net.azureaaron.dandelion.deps.moulconfig.common.TextureFilter;
import net.azureaaron.dandelion.deps.moulconfig.common.text.StructuredText;
import net.azureaaron.dandelion.deps.moulconfig.deps.libninepatch.NinePatch;
import net.azureaaron.dandelion.deps.moulconfig.internal.NinePatchRenderer;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;
import org.jspecify.annotations.NullMarked;

@NullMarked
@ApiStatus.NonExtendable
public interface RenderContext {
    public void pushMatrix();

    public void popMatrix();

    public void translate(float var1, float var2);

    public void scale(float var1, float var2);

    default public void scale(float scalar) {
        this.scale(scalar, scalar);
    }

    public void drawOnTop(Layer var1, ScissorBehaviour var2, Consumer<RenderContext> var3);

    default public boolean isMouseButtonDown(int mouseButton) {
        return IMinecraft.INSTANCE.isMouseButtonDown(mouseButton);
    }

    default public boolean isKeyboardKeyDown(int keyboardKey) {
        return IMinecraft.INSTANCE.isKeyboardKeyDown(keyboardKey);
    }

    default public boolean isShiftDown() {
        return this.isKeyboardKeyDown(KeyboardConstants.INSTANCE.getShiftLeft()) || this.isKeyboardKeyDown(KeyboardConstants.INSTANCE.getShiftRight());
    }

    default public boolean isPhysicalCtrlDown() {
        return this.isKeyboardKeyDown(KeyboardConstants.INSTANCE.getCtrlLeft()) || this.isKeyboardKeyDown(KeyboardConstants.INSTANCE.getCtrlRight());
    }

    default public boolean isCmdDown() {
        return this.isKeyboardKeyDown(KeyboardConstants.INSTANCE.getCmdLeft()) || this.isKeyboardKeyDown(KeyboardConstants.INSTANCE.getCmdRight());
    }

    default public boolean isLogicalCtrlDown() {
        if (this.getMinecraft().isOnMacOs()) {
            return this.isCmdDown();
        }
        return this.isPhysicalCtrlDown();
    }

    default public void drawStringScaledMaxWidth(StructuredText text, IFontRenderer fontRenderer, int x, int y, boolean shadow, int width, int color) {
        this.pushMatrix();
        this.translate(x, y);
        float scale = Math.min(1.0f, Math.max(0.1f, (float)width / (float)fontRenderer.getStringWidth(text)));
        this.scale(scale, scale);
        this.drawString(fontRenderer, text, 0, 0, color, shadow);
        this.popMatrix();
    }

    default public void drawStringCenteredScaledMaxWidth(StructuredText text, IFontRenderer fr, float x, float y, boolean shadow, int length, int color) {
        this.pushMatrix();
        int strLength = fr.getStringWidth(text);
        float factor = Math.min((float)length / (float)strLength, 1.0f);
        this.translate(x, y);
        this.scale(factor, factor);
        this.drawString(fr, text, -strLength / 2, -fr.getHeight() / 2, color, shadow);
        this.popMatrix();
    }

    default public void drawVerticalLine(int x, int startY, int endY, int color) {
        if (startY > endY) {
            int temp = startY;
            startY = endY;
            endY = temp;
        }
        this.drawColoredRect(x, startY + 1, x + 1, endY, color);
    }

    default public void drawHorizontalLine(int y, int startX, int endX, int color) {
        if (startX > endX) {
            int temp = startX;
            startX = endX;
            endX = temp;
        }
        this.drawColoredRect(startX, y, endX + 1, y + 1, color);
    }

    default public void drawColoredTriangles(int colour, float ... coordinates) {
        if (!1.$assertionsDisabled && coordinates.length % 6 != 0) {
            throw new AssertionError();
        }
        float[] newCoordinates = new float[coordinates.length / 3 * 4];
        for (int i2 = 0; i2 < coordinates.length / 6; ++i2) {
            newCoordinates[i2 * 8] = coordinates[i2 * 6];
            newCoordinates[i2 * 8 + 1] = coordinates[i2 * 6 + 1];
            newCoordinates[i2 * 8 + 2] = coordinates[i2 * 6 + 2];
            newCoordinates[i2 * 8 + 3] = coordinates[i2 * 6 + 3];
            newCoordinates[i2 * 8 + 4] = coordinates[i2 * 6 + 4];
            newCoordinates[i2 * 8 + 5] = coordinates[i2 * 6 + 5];
            newCoordinates[i2 * 8 + 6] = coordinates[i2 * 6 + 4];
            newCoordinates[i2 * 8 + 7] = coordinates[i2 * 6 + 5];
        }
        this.drawColouredQuads(colour, newCoordinates);
    }

    public void drawColouredQuads(int var1, float ... var2);

    default public void drawOpenCloseTriangle(boolean isOpen, float x, float y, float width, float height, int color) {
        if (isOpen) {
            this.drawColoredTriangles(color, x, y, x + width / 2.0f, y + height, x + width, y);
        } else {
            this.drawColoredTriangles(color, x, y + height, x + width, y + height / 2.0f, x, y);
        }
    }

    public void drawString(IFontRenderer var1, StructuredText var2, int var3, int var4, int var5, boolean var6);

    public void drawColoredRect(float var1, float var2, float var3, float var4, int var5);

    public void invertedRect(float var1, float var2, float var3, float var4, int var5);

    default public void drawTexturedRect(MyResourceLocation texture, float x, float y, float width, float height) {
        this.drawComplexTexture(texture, x, y, width, height, drawTextureBuilder -> {});
    }

    public void drawTexturedTintedRect(MyResourceLocation var1, float var2, float var3, float var4, float var5, float var6, float var7, float var8, float var9, int var10, TextureFilter var11);

    default public void drawComplexTexture(MyResourceLocation texture, float x, float y, float width, float height, Consumer<DrawTextureBuilder> block) {
        DrawTextureBuilder drawBuilder = new DrawTextureBuilder(texture, x, y, width, height);
        block.accept(drawBuilder);
        drawBuilder.applyTo(this);
    }

    default public void drawNinePatch(NinePatch<MyResourceLocation> patch, float x, float y, int width, int height) {
        this.pushMatrix();
        this.translate(x, y);
        patch.draw(NinePatchRenderer.INSTANCE, this, width, height);
        this.popMatrix();
    }

    default public void drawDarkRect(int x, int y, int width, int height) {
        this.drawDarkRect(x, y, width, height, true);
    }

    public void drawDarkRect(int var1, int var2, int var3, int var4, boolean var5);

    public void drawGradientRect(int var1, int var2, int var3, int var4, int var5, int var6);

    public void pushScissor(int var1, int var2, int var3, int var4);

    public void pushRawScissor(int var1, int var2, int var3, int var4);

    public void popScissor();

    public void assertNoScissors();

    @Deprecated
    public void clearScissor();

    public void renderItemStack(IItemStack var1, int var2, int var3, @Nullable StructuredText var4);

    public void drawTooltipNow(int var1, int var2, List<StructuredText> var3);

    default public void scheduleDrawTooltip(int x, int y, List<StructuredText> tooltipLines) {
        this.drawOnTop(Layer.TOOLTIP, ScissorBehaviour.ESCAPE, it -> it.drawTooltipNow(x, y, tooltipLines));
    }

    public void renderExtraLayers();

    default public IMinecraft getMinecraft() {
        return IMinecraft.INSTANCE;
    }

    static {
        if (1.$assertionsDisabled) {
            // empty if block
        }
    }

    public static class DrawTextureBuilder {
        MyResourceLocation texture;
        float x;
        float y;
        float width;
        float height;
        float u1 = 0.0f;
        float v1 = 0.0f;
        float u2 = 1.0f;
        float v2 = 1.0f;
        int color = -1;
        TextureFilter filter = TextureFilter.NEAREST;

        public DrawTextureBuilder(MyResourceLocation texture, float x, float y, float width, float height) {
            this.texture = texture;
            this.x = x;
            this.y = y;
            this.width = width;
            this.height = height;
        }

        public DrawTextureBuilder uv(float u1, float v1, float u2, float v2) {
            this.u1 = u1;
            this.v1 = v1;
            this.u2 = u2;
            this.v2 = v2;
            return this;
        }

        public DrawTextureBuilder color(int color) {
            this.color = color;
            return this;
        }

        public DrawTextureBuilder filter(TextureFilter filter) {
            this.filter = filter;
            return this;
        }

        public void applyTo(RenderContext renderContext) {
            renderContext.drawTexturedTintedRect(this.texture, this.x, this.y, this.width, this.height, this.u1, this.v1, this.u2, this.v2, this.color, this.filter);
        }
    }

    public static enum ScissorBehaviour {
        ESCAPE,
        INHERIT;

    }
}

