/*
 * Decompiled with CFR 0.152.
 */
package net.azureaaron.dandelion.deps.moulconfig.gui.component;

import java.util.function.BiFunction;
import net.azureaaron.dandelion.deps.moulconfig.gui.GuiComponent;
import net.azureaaron.dandelion.deps.moulconfig.gui.GuiImmediateContext;
import net.azureaaron.dandelion.deps.moulconfig.gui.KeyboardEvent;
import net.azureaaron.dandelion.deps.moulconfig.gui.MouseEvent;

public class ScrollPanelComponent
extends GuiComponent {
    final int width;
    final int height;
    final GuiComponent child;
    int scrollOffset;

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    @Override
    public <T> T foldChildren(T initial, BiFunction<GuiComponent, T, T> visitor) {
        return visitor.apply(this.child, (GuiComponent)initial);
    }

    @Override
    public void render(GuiImmediateContext context) {
        context.getRenderContext().pushScissor(0, 0, context.getWidth(), context.getHeight());
        context.getRenderContext().pushMatrix();
        context.getRenderContext().translate(0.0f, -this.scrollOffset);
        this.child.render(context.translatedNonRendering(0, -this.scrollOffset, context.getWidth(), context.getHeight()));
        context.getRenderContext().popMatrix();
        context.getRenderContext().popScissor();
    }

    @Override
    public boolean keyboardEvent(KeyboardEvent event, GuiImmediateContext context) {
        return this.child.keyboardEvent(event, context.translatedNonRendering(0, -this.scrollOffset, context.getWidth(), context.getHeight()));
    }

    @Override
    public boolean mouseEvent(MouseEvent mouseEvent, GuiImmediateContext context) {
        if (this.child.mouseEvent(mouseEvent, context.translatedNonRendering(0, -this.scrollOffset, context.getWidth(), context.getHeight()))) {
            return true;
        }
        if (context.isHovered() && mouseEvent instanceof MouseEvent.Scroll) {
            this.scrollOffset = (int)Math.max(0.0f, Math.min((float)this.scrollOffset - ((MouseEvent.Scroll)mouseEvent).getDWheel() * 15.0f, (float)(this.child.getHeight() - this.height)));
            return true;
        }
        return false;
    }

    public ScrollPanelComponent(int width, int height, GuiComponent child) {
        this.width = width;
        this.height = height;
        this.child = child;
    }
}

