/*
 * Decompiled with CFR 0.152.
 */
package net.azureaaron.dandelion.deps.moulconfig.gui.editors;

import java.lang.reflect.ParameterizedType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import kotlin.Pair;
import net.azureaaron.dandelion.deps.moulconfig.GuiTextures;
import net.azureaaron.dandelion.deps.moulconfig.common.IFontRenderer;
import net.azureaaron.dandelion.deps.moulconfig.common.IMinecraft;
import net.azureaaron.dandelion.deps.moulconfig.common.RenderContext;
import net.azureaaron.dandelion.deps.moulconfig.common.text.StructuredText;
import net.azureaaron.dandelion.deps.moulconfig.gui.GuiComponent;
import net.azureaaron.dandelion.deps.moulconfig.gui.GuiImmediateContext;
import net.azureaaron.dandelion.deps.moulconfig.gui.MouseEvent;
import net.azureaaron.dandelion.deps.moulconfig.gui.component.ButtonComponent;
import net.azureaaron.dandelion.deps.moulconfig.gui.component.CenterComponent;
import net.azureaaron.dandelion.deps.moulconfig.gui.component.FixedComponent;
import net.azureaaron.dandelion.deps.moulconfig.gui.component.RowComponent;
import net.azureaaron.dandelion.deps.moulconfig.gui.component.SpacerComponent;
import net.azureaaron.dandelion.deps.moulconfig.gui.component.TextComponent;
import net.azureaaron.dandelion.deps.moulconfig.gui.editors.ComponentEditor;
import net.azureaaron.dandelion.deps.moulconfig.internal.ColourUtil;
import net.azureaaron.dandelion.deps.moulconfig.internal.LerpingInteger2;
import net.azureaaron.dandelion.deps.moulconfig.internal.Rect;
import net.azureaaron.dandelion.deps.moulconfig.internal.TypeUtils;
import net.azureaaron.dandelion.deps.moulconfig.internal.Warnings;
import net.azureaaron.dandelion.deps.moulconfig.observer.GetSetter;
import net.azureaaron.dandelion.deps.moulconfig.processor.ProcessedOption;
import org.jetbrains.annotations.NotNull;

public class GuiOptionEditorDraggableList
extends ComponentEditor {
    private Map<Object, StructuredText> exampleText = new HashMap<Object, StructuredText>();
    private boolean enableDeleting;
    private List<Object> activeText;
    private final boolean requireNonEmpty;
    private int dragStartIndex = -1;
    private LerpingInteger2 trashAnimation = new LerpingInteger2(255, 3, 2);
    private Pair<Integer, Integer> lastListRenderPos = new Pair((Object)0, (Object)0);
    private Enum<?>[] enumConstants;
    private String exampleTextConcat;
    GuiComponent delegate;
    Rect trashCanBoundingBox;

    public GuiOptionEditorDraggableList(ProcessedOption option, String[] exampleText, boolean enableDeleting) {
        this(option, exampleText, enableDeleting, false);
    }

    public GuiOptionEditorDraggableList(ProcessedOption option, String[] exampleText, boolean enableDeleting, boolean requireNonEmpty) {
        super(option);
        this.enableDeleting = enableDeleting;
        this.activeText = (List)option.get();
        this.requireNonEmpty = requireNonEmpty;
        Class<?> elementType = TypeUtils.resolveRawType(((ParameterizedType)option.getType()).getActualTypeArguments()[0]);
        if (Enum.class.isAssignableFrom(elementType)) {
            Class<?> enumType = elementType;
            this.enumConstants = (Enum[])enumType.getEnumConstants();
            for (int i2 = 0; i2 < this.enumConstants.length; ++i2) {
                this.exampleText.put(this.enumConstants[i2], StructuredText.of(this.enumConstants[i2].toString()));
            }
        } else {
            for (int i3 = 0; i3 < exampleText.length; ++i3) {
                this.exampleText.put(i3, StructuredText.of(exampleText[i3]));
            }
        }
    }

    private void saveChanges() {
        this.option.explicitNotifyChange();
    }

    private StructuredText getExampleText(Object forObject) {
        StructuredText str = this.exampleText.get(forObject);
        if (str == null) {
            str = StructuredText.of("<unknown " + forObject + ">");
            Warnings.warnOnce("Could not find draggable list object for " + forObject + " on option " + this.option.getDebugDeclarationLocation(), forObject, this.option);
        }
        return str;
    }

    public boolean canDeleteRightNow() {
        return this.enableDeleting && (this.activeText.size() > 1 || !this.requireNonEmpty);
    }

    @Override
    @NotNull
    public GuiComponent getDelegate() {
        if (this.delegate == null) {
            this.delegate = this.wrapComponent(new FixedComponent(new RowComponent(new ButtonComponent((GuiComponent)new CenterComponent(new TextComponent(StructuredText.of(" Add "))), 2, () -> {
                Pair<Integer, Integer> pos = IMinecraft.INSTANCE.getMousePosition();
                if (this.activeText.size() == this.exampleText.size()) {
                    return;
                }
                this.openOverlay(this.makeDropDownOverlay(), (Integer)pos.getFirst(), (Integer)pos.getSecond());
            }), new SpacerComponent(GetSetter.constant(5), GetSetter.constant(0)), new GuiComponent(){

                @Override
                public int getWidth() {
                    return 11;
                }

                @Override
                public int getHeight() {
                    return 14;
                }

                @Override
                public void render(@NotNull GuiImmediateContext context) {
                    if (context.isHovered() && GuiOptionEditorDraggableList.this.dragStartIndex >= 0 && GuiOptionEditorDraggableList.this.canDeleteRightNow()) {
                        GuiOptionEditorDraggableList.this.trashAnimation.setTarget(0);
                    } else {
                        GuiOptionEditorDraggableList.this.trashAnimation.setTarget(255);
                    }
                    int nonRedTints = GuiOptionEditorDraggableList.this.trashAnimation.getValue();
                    context.getRenderContext().drawComplexTexture(GuiTextures.DELETE, 0.0f, 0.0f, 11.0f, 14.0f, draw -> draw.color(ColourUtil.packARGB(255, 255, nonRedTints, nonRedTints)));
                    GuiOptionEditorDraggableList.this.trashCanBoundingBox = Rect.ofGuiImmediateContext(context);
                }
            }), 48, 16), new GuiComponent(){

                @Override
                public int getWidth() {
                    return 0;
                }

                @Override
                public int getHeight() {
                    int height = 5;
                    IFontRenderer fr = IMinecraft.INSTANCE.getDefaultFontRenderer();
                    for (Object object : GuiOptionEditorDraggableList.this.activeText) {
                        StructuredText str = GuiOptionEditorDraggableList.this.getExampleText(object);
                        height += (fr.getHeight() + 1) * fr.splitLines(str).size();
                    }
                    return height;
                }

                @Override
                public boolean mouseEvent(@NotNull MouseEvent mouseEvent, @NotNull GuiImmediateContext context) {
                    if (mouseEvent instanceof MouseEvent.Click) {
                        MouseEvent.Click click = (MouseEvent.Click)mouseEvent;
                        IFontRenderer fr = IMinecraft.INSTANCE.getDefaultFontRenderer();
                        if (click.getMouseState()) {
                            int i2 = 0;
                            int yOff = 0;
                            for (Object indexObject : GuiOptionEditorDraggableList.this.activeText) {
                                StructuredText str = GuiOptionEditorDraggableList.this.getExampleText(indexObject);
                                List<StructuredText> multilines = fr.splitLines(str);
                                int ySize = multilines.size() * (fr.getHeight() + 1);
                                GuiImmediateContext trans = context.translated(0, yOff, context.getWidth(), ySize);
                                if (trans.isHovered()) {
                                    GuiOptionEditorDraggableList.this.dragStartIndex = i2;
                                    int mouseY = trans.getMouseY() - 4;
                                    GuiOptionEditorDraggableList.this.openOverlay(GuiOptionEditorDraggableList.this.makeDragComponent(indexObject, trans.getMouseX(), mouseY, context.getWidth()), context.getAbsoluteMouseX() - trans.getMouseX(), context.getAbsoluteMouseY() - mouseY);
                                    return true;
                                }
                                ++i2;
                                yOff += ySize;
                            }
                        }
                    }
                    return super.mouseEvent(mouseEvent, context);
                }

                @Override
                public void render(@NotNull GuiImmediateContext context) {
                    GuiOptionEditorDraggableList.this.lastListRenderPos = new Pair((Object)context.getRenderOffsetX(), (Object)context.getRenderOffsetY());
                    RenderContext renderContext = context.getRenderContext();
                    int width = context.getWidth();
                    IFontRenderer fr = IMinecraft.INSTANCE.getDefaultFontRenderer();
                    int height = context.getHeight();
                    renderContext.drawColoredRect(0.0f, 0.0f, width, height, -2236963);
                    renderContext.drawColoredRect(1.0f, 1.0f, width - 1, height - 1, -16777216);
                    int i2 = 0;
                    int yOff = 0;
                    for (Object indexObject : GuiOptionEditorDraggableList.this.activeText) {
                        StructuredText str = GuiOptionEditorDraggableList.this.getExampleText(indexObject);
                        List<StructuredText> multilines = fr.splitLines(str);
                        int ySize = multilines.size() * (fr.getHeight() + 1);
                        if (i2++ != GuiOptionEditorDraggableList.this.dragStartIndex) {
                            for (int multilineIndex = 0; multilineIndex < multilines.size(); ++multilineIndex) {
                                StructuredText line = multilines.get(multilineIndex);
                                renderContext.drawStringScaledMaxWidth(line, fr, 15, 5 + yOff + multilineIndex * 10, true, width - 20, -1);
                            }
                            renderContext.drawString(fr, StructuredText.of("\u2261"), 5, 4 + yOff + ySize / 2 - 4, 0xFFFFFF, true);
                        }
                        yOff += ySize;
                    }
                }
            });
        }
        return this.delegate;
    }

    GuiComponent makeDragComponent(final Object indexObject, final int mouseOffsetX, final int mouseOffsetY, final int width) {
        return new GuiComponent(){

            @Override
            public int getWidth() {
                return width;
            }

            @Override
            public int getHeight() {
                return 11;
            }

            @Override
            public boolean mouseEvent(@NotNull MouseEvent mouseEvent, @NotNull GuiImmediateContext context) {
                MouseEvent.Click click;
                if (mouseEvent instanceof MouseEvent.Click && !(click = (MouseEvent.Click)mouseEvent).getMouseState()) {
                    GuiOptionEditorDraggableList.this.closeOverlay();
                    if (GuiOptionEditorDraggableList.this.canDeleteRightNow() && GuiOptionEditorDraggableList.this.trashCanBoundingBox.includesPoint(context.getAbsoluteMouseX(), context.getAbsoluteMouseY())) {
                        GuiOptionEditorDraggableList.this.activeText.remove(GuiOptionEditorDraggableList.this.dragStartIndex);
                        GuiOptionEditorDraggableList.this.saveChanges();
                    }
                    GuiOptionEditorDraggableList.this.dragStartIndex = -1;
                    return true;
                }
                if (mouseEvent instanceof MouseEvent.Move) {
                    int mx = context.getAbsoluteMouseX() - mouseOffsetX;
                    int my = context.getAbsoluteMouseY() - mouseOffsetY;
                    GuiOptionEditorDraggableList.this.openOverlay(GuiOptionEditorDraggableList.this.getOverlayDelegate(), mx, my);
                    GuiOptionEditorDraggableList.this.reorderElements(width, mx, my);
                }
                return super.mouseEvent(mouseEvent, context);
            }

            @Override
            public void render(@NotNull GuiImmediateContext context) {
                RenderContext renderContext = context.getRenderContext();
                IFontRenderer fr = IMinecraft.INSTANCE.getDefaultFontRenderer();
                StructuredText text = GuiOptionEditorDraggableList.this.getExampleText(indexObject);
                StructuredText firstLine = fr.splitLines(text).get(0);
                renderContext.drawString(fr, StructuredText.of("\u2261"), 5, 1, 0xFFFFFF, true);
                renderContext.drawStringScaledMaxWidth(firstLine, fr, 15, 1, true, context.getWidth() - 20, -1);
            }
        };
    }

    private void reorderElements(int width, int mouseX, int mouseY) {
        assert (this.lastListRenderPos != null);
        int renderX = (Integer)this.lastListRenderPos.getFirst();
        if (mouseX < renderX || mouseX > renderX + width) {
            return;
        }
        int renderY = (Integer)this.lastListRenderPos.getSecond();
        IFontRenderer fr = IMinecraft.INSTANCE.getDefaultFontRenderer();
        int i2 = 0;
        int yOff = renderY;
        for (Object indexObject : this.activeText) {
            StructuredText str = this.getExampleText(indexObject);
            List<StructuredText> multilines = fr.splitLines(str);
            int ySize = multilines.size() * (fr.getHeight() + 1);
            if (yOff > mouseY && mouseY < yOff + ySize) {
                Object toSwap = this.activeText.get(i2);
                Object moving = this.activeText.get(this.dragStartIndex);
                this.activeText.set(i2, moving);
                this.activeText.set(this.dragStartIndex, toSwap);
                this.dragStartIndex = i2;
                return;
            }
            ++i2;
            yOff += ySize;
        }
        this.saveChanges();
    }

    GuiComponent makeDropDownOverlay() {
        return new GuiComponent(){

            @Override
            public int getWidth() {
                return 100;
            }

            @Override
            public int getHeight() {
                ArrayList remaining = new ArrayList(GuiOptionEditorDraggableList.this.exampleText.keySet());
                remaining.removeAll(GuiOptionEditorDraggableList.this.activeText);
                return -1 + 12 * remaining.size();
            }

            @Override
            public boolean mouseEvent(@NotNull MouseEvent mouseEvent, @NotNull GuiImmediateContext context) {
                if (mouseEvent instanceof MouseEvent.Click) {
                    MouseEvent.Click click = (MouseEvent.Click)mouseEvent;
                    if (click.getMouseState() && context.isHovered()) {
                        ArrayList remaining = new ArrayList(GuiOptionEditorDraggableList.this.exampleText.keySet());
                        remaining.removeAll(GuiOptionEditorDraggableList.this.activeText);
                        int dropdownY = -1;
                        for (Object indexObject : remaining) {
                            if (context.translated(0, dropdownY + 3, context.getWidth(), 10).isHovered()) {
                                GuiOptionEditorDraggableList.this.activeText.add(indexObject);
                                return true;
                            }
                            dropdownY += 12;
                        }
                    } else if (click.getMouseState()) {
                        GuiOptionEditorDraggableList.this.closeOverlay();
                    }
                }
                return super.mouseEvent(mouseEvent, context);
            }

            @Override
            public void render(@NotNull GuiImmediateContext context) {
                ArrayList remaining = new ArrayList(GuiOptionEditorDraggableList.this.exampleText.keySet());
                remaining.removeAll(GuiOptionEditorDraggableList.this.activeText);
                if (remaining.isEmpty()) {
                    GuiOptionEditorDraggableList.this.closeOverlay();
                    return;
                }
                int dropdownHeight = context.getHeight();
                int dropdownWidth = context.getWidth();
                IFontRenderer fr = IMinecraft.INSTANCE.getDefaultFontRenderer();
                RenderContext renderContext = context.getRenderContext();
                int main = -14671834;
                int outline = -12566458;
                renderContext.drawColoredRect(0.0f, 0.0f, 1.0f, dropdownHeight, outline);
                renderContext.drawColoredRect(1.0f, 0.0f, dropdownWidth, 1.0f, outline);
                renderContext.drawColoredRect(dropdownWidth - 1, 1.0f, dropdownWidth, dropdownHeight, outline);
                renderContext.drawColoredRect(1.0f, dropdownHeight - 1, dropdownWidth - 1, dropdownHeight, outline);
                renderContext.drawColoredRect(1.0f, 1.0f, dropdownWidth - 1, dropdownHeight - 1, main);
                int dropdownY = -1;
                for (Object indexObject : remaining) {
                    StructuredText str = GuiOptionEditorDraggableList.this.getExampleText(indexObject);
                    if (str.getText().isEmpty()) {
                        str = StructuredText.of("<NONE>");
                    }
                    renderContext.drawStringScaledMaxWidth(fr.splitLines(str).get(0), fr, 3, 3 + dropdownY, false, dropdownWidth - 6, -6250336);
                    dropdownY += 12;
                }
            }
        };
    }

    @Override
    public boolean fulfillsSearch(String word) {
        if (this.exampleTextConcat == null) {
            this.exampleTextConcat = this.exampleText.values().stream().map(StructuredText::getText).collect(Collectors.joining(" ")).toLowerCase(Locale.ROOT);
        }
        return super.fulfillsSearch(word) || this.exampleTextConcat.contains(word);
    }
}

