/*
 * Decompiled with CFR 0.152.
 */
package net.azureaaron.dandelion.deps.moulconfig.gui.editors;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import net.azureaaron.dandelion.deps.moulconfig.common.IFontRenderer;
import net.azureaaron.dandelion.deps.moulconfig.common.IMinecraft;
import net.azureaaron.dandelion.deps.moulconfig.common.text.StructuredText;
import net.azureaaron.dandelion.deps.moulconfig.gui.GuiComponent;
import net.azureaaron.dandelion.deps.moulconfig.gui.GuiImmediateContext;
import net.azureaaron.dandelion.deps.moulconfig.gui.MouseEvent;
import net.azureaaron.dandelion.deps.moulconfig.gui.editors.ComponentEditor;
import net.azureaaron.dandelion.deps.moulconfig.processor.ProcessedOption;
import org.jetbrains.annotations.NotNull;

public class GuiOptionEditorDropdown
extends ComponentEditor {
    private List<StructuredText> values;
    private boolean useOrdinal;
    private Enum<?>[] constants;
    private String valuesForSearch;
    int componentWidth = 0;
    private GuiComponent dropdownOverlay = new GuiComponent(){

        @Override
        public int getWidth() {
            return GuiOptionEditorDropdown.this.componentWidth;
        }

        @Override
        public int getHeight() {
            return 13 + 12 * GuiOptionEditorDropdown.this.values.size();
        }

        @Override
        public boolean mouseEvent(@NotNull MouseEvent mouseEvent, @NotNull GuiImmediateContext context) {
            if (mouseEvent instanceof MouseEvent.Click) {
                MouseEvent.Click click = (MouseEvent.Click)mouseEvent;
                if (click.getMouseState()) {
                    GuiOptionEditorDropdown.this.closeOverlay();
                }
                if (click.getMouseState() && click.getMouseButton() == 0 && context.isHovered()) {
                    int top = 0;
                    int mouseY = context.getMouseY();
                    int dropdownY = 13;
                    for (int ordinal = 0; ordinal < GuiOptionEditorDropdown.this.values.size(); ++ordinal) {
                        if (mouseY >= top + 3 + dropdownY && mouseY <= top + 3 + dropdownY + 12) {
                            int selected = ordinal;
                            if (GuiOptionEditorDropdown.this.constants != null) {
                                GuiOptionEditorDropdown.this.option.set(GuiOptionEditorDropdown.this.constants[selected]);
                            } else if (GuiOptionEditorDropdown.this.useOrdinal) {
                                GuiOptionEditorDropdown.this.option.set(selected);
                            } else {
                                GuiOptionEditorDropdown.this.option.set(((StructuredText)GuiOptionEditorDropdown.this.values.get(selected)).getText());
                            }
                        }
                        dropdownY += 12;
                    }
                }
                return true;
            }
            return super.mouseEvent(mouseEvent, context);
        }

        @Override
        public void render(@NotNull GuiImmediateContext context) {
            int selected = GuiOptionEditorDropdown.this.getSelectedIndex();
            StructuredText selectedString = StructuredText.of(" - Select - ");
            if (selected >= 0 && selected < GuiOptionEditorDropdown.this.values.size()) {
                selectedString = (StructuredText)GuiOptionEditorDropdown.this.values.get(selected);
            }
            int dropdownHeight = context.getHeight();
            int dropdownWidth = context.getWidth();
            int main = -14671834;
            int outlineColour = -1;
            context.getRenderContext().pushMatrix();
            int left = 0;
            int top = 0;
            context.getRenderContext().drawColoredRect(left, top, left + 1, top + dropdownHeight, outlineColour);
            context.getRenderContext().drawColoredRect(left + 1, top, left + dropdownWidth, top + 1, outlineColour);
            context.getRenderContext().drawColoredRect(left + dropdownWidth - 1, top + 1, left + dropdownWidth, top + dropdownHeight, outlineColour);
            context.getRenderContext().drawColoredRect(left + 1, top + dropdownHeight - 1, left + dropdownWidth - 1, top + dropdownHeight, outlineColour);
            context.getRenderContext().drawColoredRect(left + 1, top + 1, left + dropdownWidth - 1, top + dropdownHeight - 1, main);
            context.getRenderContext().drawColoredRect(left + 1, top + 14 - 1, left + dropdownWidth - 1, top + 14, outlineColour);
            int dropdownY = 13;
            IFontRenderer fr = IMinecraft.INSTANCE.getDefaultFontRenderer();
            for (StructuredText option : GuiOptionEditorDropdown.this.values) {
                if (option.getText().isEmpty()) {
                    option = StructuredText.of("<NONE>");
                }
                context.getRenderContext().drawStringScaledMaxWidth(option, fr, left + 3, top + 3 + dropdownY, false, dropdownWidth - 6, -6250336);
                dropdownY += 12;
            }
            context.getRenderContext().drawStringScaledMaxWidth(selectedString, fr, left + 3, top + 3, false, dropdownWidth - 16, -6250336);
            context.getRenderContext().drawOpenCloseTriangle(false, context.getWidth() - 10, 4.0f, 6.0f, 6.0f, -1);
            context.getRenderContext().popMatrix();
        }
    };
    private GuiComponent component = this.wrapComponent(new GuiComponent(){

        @Override
        public int getWidth() {
            return 80;
        }

        @Override
        public int getHeight() {
            return 14;
        }

        @Override
        public boolean mouseEvent(@NotNull MouseEvent mouseEvent, @NotNull GuiImmediateContext context) {
            if (mouseEvent instanceof MouseEvent.Click && ((MouseEvent.Click)mouseEvent).getMouseState() && context.isHovered()) {
                if (!GuiOptionEditorDropdown.this.isOverlayOpen()) {
                    GuiOptionEditorDropdown.this.componentWidth = context.getWidth();
                    int scaledHeight = context.getRenderContext().getMinecraft().getScaledHeight();
                    int clampedY = context.getRenderOffsetY() + GuiOptionEditorDropdown.this.dropdownOverlay.getHeight() > scaledHeight ? scaledHeight - GuiOptionEditorDropdown.this.dropdownOverlay.getHeight() : context.getRenderOffsetY();
                    GuiOptionEditorDropdown.this.openOverlay(GuiOptionEditorDropdown.this.dropdownOverlay, context.getRenderOffsetX(), clampedY);
                }
                return true;
            }
            return super.mouseEvent(mouseEvent, context);
        }

        @Override
        public void render(@NotNull GuiImmediateContext context) {
            int dropdownWidth = context.getWidth();
            int selected = GuiOptionEditorDropdown.this.getSelectedIndex();
            if (selected >= GuiOptionEditorDropdown.this.values.size()) {
                selected = GuiOptionEditorDropdown.this.values.size();
            }
            StructuredText selectedString = StructuredText.of(" - Select - ");
            if (selected >= 0 && selected < GuiOptionEditorDropdown.this.values.size()) {
                selectedString = (StructuredText)GuiOptionEditorDropdown.this.values.get(selected);
            }
            context.getRenderContext().drawDarkRect(0, 0, dropdownWidth, context.getHeight(), false);
            context.getRenderContext().drawOpenCloseTriangle(true, context.getWidth() - 10, 4.0f, 6.0f, 6.0f, -1);
            context.getRenderContext().drawStringScaledMaxWidth(selectedString, IMinecraft.INSTANCE.getDefaultFontRenderer(), 3, 3, false, context.getWidth() - 16, -6250336);
        }
    });

    public GuiOptionEditorDropdown(ProcessedOption option, String[] values) {
        this(option, values, false);
    }

    public GuiOptionEditorDropdown(ProcessedOption option, String[] values, boolean forceGivenValues) {
        super(option);
        Class clazz = (Class)option.getType();
        if (Enum.class.isAssignableFrom(clazz) && !forceGivenValues) {
            this.constants = (Enum[])clazz.getEnumConstants();
            this.values = new ArrayList<StructuredText>();
            for (Enum<?> constant : this.constants) {
                this.values.add(StructuredText.of(constant.toString()));
            }
        } else {
            this.values = Arrays.stream(values).map(StructuredText::of).collect(Collectors.toList());
            assert (values.length > 0);
        }
        this.useOrdinal = clazz == Integer.TYPE || clazz == Integer.class;
    }

    @Override
    @NotNull
    public GuiComponent getDelegate() {
        return this.component;
    }

    private int getSelectedIndex() {
        Object selectedObject = this.option.get();
        if (selectedObject == null) {
            return -1;
        }
        if (this.useOrdinal) {
            return (Integer)selectedObject;
        }
        if (this.constants != null) {
            return ((Enum)selectedObject).ordinal();
        }
        return this.values.stream().map(StructuredText::getText).collect(Collectors.toList()).indexOf(selectedObject);
    }

    @Override
    public boolean fulfillsSearch(String word) {
        if (this.valuesForSearch == null) {
            this.valuesForSearch = this.values.stream().map(StructuredText::getText).collect(Collectors.joining(" ")).toLowerCase(Locale.ROOT);
        }
        return super.fulfillsSearch(word) || this.valuesForSearch.contains(word);
    }
}

