/*
 * Decompiled with CFR 0.152.
 */
package net.azureaaron.dandelion.deps.moulconfig.internal;

import java.util.function.Predicate;
import net.azureaaron.dandelion.deps.moulconfig.GuiTextures;
import net.azureaaron.dandelion.deps.moulconfig.internal.Warnings;
import org.jetbrains.annotations.Nullable;

public class StackUtil {
    private final StackTraceElement[] stackTrace;
    private int offset;
    public static final String MOULCONFIG_BASE_PACKAGE = GuiTextures.class.getPackage().getName();

    public StackUtil(StackTraceElement[] stackTrace) {
        this.stackTrace = stackTrace;
    }

    public StackUtil skipWhile(Predicate<StackTraceElement> filter) {
        while (this.stackTrace.length > this.offset && filter.test(this.stackTrace[this.offset])) {
            ++this.offset;
        }
        return this;
    }

    public StackUtil skip(int count) {
        this.offset = Math.min(this.offset + count, this.stackTrace.length);
        return this;
    }

    @Nullable
    public StackTraceElement takeOne() {
        if (this.offset >= this.stackTrace.length) {
            return null;
        }
        return this.stackTrace[this.offset++];
    }

    public void warn(String warningText) {
        StackTraceElement firstOffender = this.takeOne();
        assert (firstOffender != null);
        Warnings.warnAt(warningText, firstOffender, this.skipWhile(StackUtil.moulConfigLibrary()).takeOne());
    }

    public static Predicate<StackTraceElement> inTests() {
        return it -> it.getClassName().startsWith(MOULCONFIG_BASE_PACKAGE + ".test.");
    }

    public static Predicate<StackTraceElement> anyMoulConfig() {
        return it -> it.getClassName().startsWith(MOULCONFIG_BASE_PACKAGE + ".");
    }

    public static Predicate<StackTraceElement> moulConfigLibrary() {
        return StackUtil.anyMoulConfig().and(StackUtil.inTests().negate());
    }

    public static Predicate<StackTraceElement> defaultSkips() {
        return it -> it.getClassName().equals(StackUtil.class.getName()) || it.getClassName().equals(Warnings.class.getName()) || it.getClassName().startsWith("java.") || it.getClassName().startsWith("kotlin.");
    }

    public static StackUtil getWalker() {
        return new StackUtil(new Exception().getStackTrace()).skip(1);
    }
}

